/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteSyncedObject {
    private final ReadWriteLock _readWriteLock;

    protected ReadWriteSyncedObject(boolean threadSafe) {
        this._readWriteLock = threadSafe ? new ReentrantReadWriteLock(true) : null;
    }

    public boolean isThreadSafe() {
        return null != this._readWriteLock;
    }

    protected Lock acquireReadLock(Lock otherLock) {
        Lock result = null;
        if (null != this._readWriteLock) {
            result = this._readWriteLock.readLock();
            this.lockSafe(result, otherLock);
        }
        return result;
    }

    protected Lock acquireReadLock() {
        if (null == this._readWriteLock) {
            return null;
        }
        Lock readLock = this._readWriteLock.readLock();
        readLock.lock();
        return readLock;
    }

    protected Lock acquireWriteLock(Lock otherLock) {
        Lock result = null;
        if (null != this._readWriteLock) {
            result = this._readWriteLock.writeLock();
            this.lockSafe(result, otherLock);
        }
        return result;
    }

    protected Lock acquireWriteLock() {
        return this.acquireWriteLock(null);
    }

    private void lockSafe(Lock thisLock, Lock otherLock) {
        if (null == otherLock) {
            thisLock.lock();
        } else {
            boolean done = false;
            while (!done) {
                done = thisLock.tryLock();
                if (done) continue;
                otherLock.unlock();
                otherLock.lock();
            }
        }
    }

    protected void releaseLock(Lock lock) {
        if (null != lock) {
            lock.unlock();
        }
    }
}

