/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

public class RateMonitor {
    private final String _name;
    private long _startTime;
    private long _numTicks;
    private double _rate;
    private long _durationSoFar;
    private State _state;

    public RateMonitor(String name) {
        this._name = name;
        this._startTime = -1L;
        this._numTicks = 0L;
        this._state = State.INIT;
    }

    public boolean started() {
        return this._startTime > 0L;
    }

    public void suspend() {
        if (this._state == State.STARTED || this._state == State.RESUMED) {
            this._durationSoFar += this.getNanoTime() - this._startTime;
            this._startTime = 0L;
            this._state = State.SUSPENDED;
        }
    }

    public void resume() {
        if (this._state == State.SUSPENDED) {
            this._startTime = this.getNanoTime();
            this._state = State.RESUMED;
        }
    }

    public void start() {
        this._startTime = this.getNanoTime();
        this._durationSoFar = 0L;
        this._numTicks = 0L;
        this._state = State.STARTED;
    }

    public void tick() {
        assert (this._state != State.STOPPED && this._state != State.SUSPENDED);
        ++this._numTicks;
    }

    public void ticks(long ticks) {
        assert (this._state != State.STOPPED && this._state != State.SUSPENDED);
        this._numTicks += ticks;
    }

    public double getRate() {
        long duration = this.getDuration();
        this._rate = this._numTicks > 1000000000L ? 1.0E9 * ((double)this._numTicks / (double)duration) : (double)this._numTicks * 1.0E9 / (double)duration;
        return this._rate;
    }

    public long getDuration() {
        long duration = 0L;
        switch (this._state) {
            case STARTED: {
                duration = this.getNanoTime() - this._startTime;
                break;
            }
            case RESUMED: {
                duration = this.getNanoTime() - this._startTime + this._durationSoFar;
                break;
            }
            case STOPPED: 
            case SUSPENDED: {
                duration = this._durationSoFar;
                break;
            }
            case INIT: {
                throw new RuntimeException("RateMonitor not started !!");
            }
        }
        return duration;
    }

    public long getNumTicks() {
        return this._numTicks;
    }

    public void stop() {
        if (this._state != State.SUSPENDED) {
            this._durationSoFar += this.getNanoTime() - this._startTime;
        }
        this._state = State.STOPPED;
    }

    public String toString() {
        return "RateMonitor [_name=" + this._name + ", _numTicks=" + this._numTicks + ", _rate=" + this._rate + ", _durationSoFar=" + this._durationSoFar + ", state = " + (Object)((Object)this._state) + "]";
    }

    public State getState() {
        return this._state;
    }

    public boolean isStarted() {
        return this._state == State.STARTED;
    }

    public long getNanoTime() {
        return System.nanoTime();
    }

    public void sleep(long msec) throws InterruptedException {
        Thread.sleep(msec);
    }

    public static class MockRateMonitor
    extends RateMonitor {
        private long _currentTimeInNs = 0L;

        public MockRateMonitor(String name) {
            super(name);
        }

        @Override
        public long getNanoTime() {
            return this._currentTimeInNs;
        }

        public void setNanoTime(long ns) {
            this._currentTimeInNs = ns;
        }

        @Override
        public void sleep(long msec) throws InterruptedException {
            this._currentTimeInNs += msec * 1000000L;
        }
    }

    private static enum State {
        INIT,
        STARTED,
        SUSPENDED,
        RESUMED,
        STOPPED;

    }
}

