/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import com.linkedin.databus.core.util.RateMonitor;
import com.linkedin.databus2.core.DatabusException;
import org.apache.log4j.Logger;

public class RateControl {
    private RateMonitor _ra = null;
    private long _maxEventsPerSec = Long.MIN_VALUE;
    private long _maxthrottleDurationInSecs = Long.MIN_VALUE;
    private final boolean _enabled;
    private boolean _expired = false;
    private long _numSleeps = 0L;
    public static final String MODULE = RateControl.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public RateControl(long numEventsPerSec, long throttleDurationInSecs) {
        String name = "internalRateControl";
        this._ra = new RateMonitor("internalRateControl");
        this._ra.start();
        this._maxEventsPerSec = numEventsPerSec;
        this._maxthrottleDurationInSecs = throttleDurationInSecs;
        this._numSleeps = 0L;
        this._enabled = this._maxEventsPerSec > 0L && this._maxthrottleDurationInSecs > 0L;
        this._expired = false;
    }

    public long incrementEventCount() throws DatabusException {
        if (!this.isEnabled()) {
            return Long.MIN_VALUE;
        }
        if (this.checkExpired()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Throttle duration has expired. Accepting events without rate control");
            }
            return Long.MIN_VALUE;
        }
        this._ra.tick();
        if (!this.checkRateExceeded()) {
            return this._ra.getNumTicks();
        }
        try {
            long duration = this.computeSleepDuration();
            this.sleepToMaintainRate(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this._ra.getNumTicks();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    protected long sleepToMaintainRate(long duration) throws InterruptedException, DatabusException {
        boolean needToSleep;
        long remainingTimeMSec;
        if (duration <= 0L) {
            throw new DatabusException("Negative duration specified");
        }
        long remainingTimeNSec = duration;
        if ((remainingTimeNSec -= (remainingTimeMSec = remainingTimeNSec / 1000000L) * 1000000L) > 0L) {
            ++remainingTimeMSec;
        }
        boolean bl = needToSleep = remainingTimeMSec > 0L;
        if (needToSleep) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sleeping for remainingTimeMSec = " + remainingTimeMSec));
            }
            this._ra.sleep(remainingTimeMSec);
            ++this._numSleeps;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No need to sleep. remainingTimeMSec = " + remainingTimeMSec));
        }
        return remainingTimeMSec;
    }

    protected boolean checkExpired() throws DatabusException {
        if (!this._enabled) {
            return false;
        }
        if (this._expired) {
            return true;
        }
        long throttleDurationInNs = this._ra.getDuration();
        if (throttleDurationInNs < this._maxthrottleDurationInSecs * 1000000000L) {
            if (this._expired) {
                throw new DatabusException("Throttle duration has not expired. _expired must be set to false");
            }
        } else {
            LOG.info((Object)("Ending throttling of events as " + this._maxthrottleDurationInSecs + " have expired"));
            this._expired = true;
        }
        return this._expired;
    }

    protected boolean checkRateExceeded() {
        double rate = this._ra.getRate();
        return rate > (double)this._maxEventsPerSec;
    }

    protected long computeSleepDuration() throws DatabusException {
        long numNSecsExpiredSoFar;
        long numEvents = this._ra.getNumTicks();
        long numNSecsToHaveExpired = numEvents * 1000000000L / this._maxEventsPerSec;
        if (numNSecsToHaveExpired > (numNSecsExpiredSoFar = this._ra.getDuration())) {
            return numNSecsToHaveExpired - numNSecsExpiredSoFar;
        }
        return 0L;
    }

    public long getNumSleeps() {
        return this._numSleeps;
    }

    public void resetNumSleeps() {
        this._numSleeps = 0L;
    }
}

