/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import com.linkedin.databus.core.util.BufferPositionParser;
import com.linkedin.databus.core.util.Range;
import java.util.Arrays;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class RangeBasedReaderWriterLock {
    public static final String MODULE = RangeBasedReaderWriterLock.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private static final long MAX_LOCK_WAIT_MS = 60000L;
    private final PriorityQueue<LockToken> readerRanges = new PriorityQueue(100);
    private final ReentrantLock mutex;
    private final Condition writesPossible;
    private final Condition readsPossible;
    private Range writerRange = new Range(-1L, 0L);
    private boolean writerIn = false;
    private boolean writerWaiting;

    public RangeBasedReaderWriterLock() {
        this.mutex = new ReentrantLock();
        this.writesPossible = this.mutex.newCondition();
        this.readsPossible = this.mutex.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockToken acquireReaderLock(long startOffset, long endOffset, BufferPositionParser parser, String ownerName) throws InterruptedException, TimeoutException {
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug((Object)("Asked to acquire reader lock from " + parser.toString(startOffset) + " to " + parser.toString(endOffset) + " for " + ownerName));
        }
        Range readerRange = new Range(startOffset, endOffset);
        this.mutex.lock();
        try {
            boolean timeout = false;
            while (this.writerIn && this.writerRange.intersects(readerRange)) {
                if (debug) {
                    LOG.debug((Object)("Waiting for reads to be possible since writer is In. Reader Range is :" + readerRange.toString(parser) + ". Writer Range is :" + this.writerRange.toString(parser)));
                }
                if (timeout) {
                    throw new TimeoutException();
                }
                if (!this.readsPossible.await(60000L, TimeUnit.MILLISECONDS)) {
                    timeout = true;
                }
                if (!debug) continue;
                LOG.info((Object)"Waiting for reads to be possible: coming out of wait");
            }
            LockToken returnVal = new LockToken(readerRange, ownerName);
            this.readerRanges.add(returnVal);
            if (debug) {
                LOG.debug((Object)("Returning with reader lock from " + parser.toString(startOffset) + " to " + parser.toString(endOffset)));
            }
            LockToken lockToken = returnVal;
            return lockToken;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftReaderLockStart(LockToken lockId, long newStartOffset, BufferPositionParser parser) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Being asked to shift reader lock start to " + parser.toString(newStartOffset) + " for " + lockId));
        }
        this.mutex.lock();
        try {
            boolean lockFound = this.readerRanges.remove(lockId);
            assert (lockFound) : "lock:" + lockId + "; this:" + this.toString();
            lockId.setRangeStart(newStartOffset);
            this.readerRanges.add(lockId);
            this.writesPossible.signal();
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shiftReaderLockStartIfWriterWaiting(LockToken lockId, long newStartOffset, BufferPositionParser parser) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Being asked to shift reader lock start to " + parser.toString(newStartOffset) + ";writerWaiting = " + this.writerWaiting));
        }
        if (this.writerWaiting) {
            this.mutex.lock();
            try {
                this.readerRanges.remove(lockId);
                lockId.setRangeStart(newStartOffset);
                this.readerRanges.add(lockId);
                this.writesPossible.signal();
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReaderLock(LockToken lockId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Being asked to release reader lock " + lockId));
        }
        this.mutex.lock();
        try {
            boolean readerLockRemoved = this.readerRanges.remove(lockId);
            assert (readerLockRemoved) : "lock:" + lockId + "; this:" + this.toString();
            this.writesPossible.signal();
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWriterLock(long start, long end, BufferPositionParser parser) throws InterruptedException, TimeoutException {
        long startOffset = parser.address(start);
        long endOffset = parser.address(end);
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug((Object)("Acquiring writer lock from " + parser.toString(start) + " to " + parser.toString(end)));
        }
        this.mutex.lock();
        try {
            boolean timeout = false;
            while (!this.readerRanges.isEmpty() && Range.contains(startOffset, endOffset, parser.address(this.readerRanges.peek()._id.start))) {
                if (debug) {
                    LOG.debug((Object)("Entering wait because reader(s) exist: Writer Range: [" + parser.toString(start) + "(Address:" + parser.toString(startOffset) + ")-" + parser.toString(end) + "(Address:" + parser.toString(endOffset) + ")]. Nearest Reader Range :" + this.readerRanges.peek().toString(parser)));
                }
                if (timeout) {
                    LOG.error((Object)("timed out waiting for a write lock for [" + parser.toString(start) + "," + parser.toString(end) + "); this: " + this));
                    throw new TimeoutException();
                }
                for (LockToken token : this.readerRanges) {
                    LOG.info((Object)token.toString(parser));
                }
                this.writerWaiting = true;
                if (!this.writesPossible.await(60000L, TimeUnit.MILLISECONDS)) {
                    timeout = true;
                }
                if (!debug) continue;
                LOG.debug((Object)"Writer coming out of wait");
            }
            this.writerWaiting = false;
            this.writerIn = true;
            this.writerRange.start = start;
            this.writerRange.end = end;
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWriterLock(BufferPositionParser parser) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Releasing writer lock from " + parser.toString(this.writerRange.start) + " to " + parser.toString(this.writerRange.end)));
        }
        this.mutex.lock();
        try {
            this.writerIn = false;
            this.readsPossible.signalAll();
        }
        finally {
            this.mutex.unlock();
        }
    }

    public String toString(BufferPositionParser parser, boolean doSort) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[writerIn:" + this.writerIn).append(",WriterWaiting:");
        strBuilder.append(this.writerWaiting).append(",WriterRange:").append(this.writerRange.toString(parser));
        strBuilder.append("\nReader Ranges:\n");
        if (!doSort) {
            Iterator<LockToken> it = this.readerRanges.iterator();
            while (it.hasNext()) {
                strBuilder.append(it.next().toString(parser)).append("\n");
            }
        } else {
            Object[] ranges = new LockToken[this.readerRanges.size()];
            this.readerRanges.toArray(ranges);
            Arrays.sort(ranges);
            for (int i = 0; i < ranges.length; ++i) {
                strBuilder.append(((LockToken)ranges[i]).toString(parser)).append("\n");
            }
        }
        return strBuilder.toString();
    }

    PriorityQueue<LockToken> getReaderRanges() {
        return this.readerRanges;
    }

    public boolean isWriterIn() {
        return this.writerIn;
    }

    public boolean isWriterWaiting() {
        return this.writerWaiting;
    }

    public Range getWriterRange() {
        return this.writerRange;
    }

    public int getNumReaders() {
        return this.readerRanges.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.mutex.lock();
        try {
            String string = "{readerRanges:" + this.readerRanges + ", writerRange:" + this.writerRange + ", writerIn:" + this.writerIn + ", writerWaiting:" + this.writerWaiting + "}";
            return string;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public class LockToken
    implements Comparable<LockToken> {
        protected Range _id;
        private final String _ownerName;
        private final long _createTime;
        private long _lastUpdateTime;

        protected LockToken(Range id, String ownerName) {
            this._id = id;
            this._ownerName = ownerName;
            this._lastUpdateTime = this._createTime = System.currentTimeMillis();
        }

        public Range getRange() {
            return this._id;
        }

        public String getOwnerName() {
            return this._ownerName;
        }

        public void setRangeStart(long newStart) {
            this._id.start = newStart;
            this._lastUpdateTime = System.currentTimeMillis();
        }

        public String toString() {
            return "{ownerName:" + this._ownerName + ", range:" + this._id + ", created:" + this._createTime + ", lastUpdated:" + this._lastUpdateTime + "}";
        }

        public String toString(BufferPositionParser parser) {
            return "{ownerName:" + this._ownerName + ", range:" + this._id.toString(parser) + "}";
        }

        @Override
        public int compareTo(LockToken o) {
            return this._id.compareTo(o._id);
        }
    }
}

