/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import com.linkedin.databus.core.util.BufferPositionParser;

public class Range
implements Comparable<Range> {
    public long start;
    public long end;

    public Range(long startOffset, long endOffset) {
        this.start = startOffset;
        this.end = endOffset;
    }

    public Range() {
    }

    public boolean contains(long someOffset) {
        return Range.contains(this.start, this.end, someOffset);
    }

    public static boolean containsReaderPosition(long writerStart, long writerEnd, long readerPosition, BufferPositionParser parser) {
        if (readerPosition < 0L) {
            return false;
        }
        if (parser.bufferGenId(readerPosition) < parser.bufferGenId(writerStart)) {
            long fakeReaderPos = parser.setGenId(readerPosition, parser.bufferGenId(writerStart));
            return writerStart <= fakeReaderPos && fakeReaderPos < writerEnd;
        }
        return writerStart <= readerPosition && readerPosition < writerEnd;
    }

    public static boolean containsIgnoreGenId(long start, long end, long offset, BufferPositionParser parser) {
        return Range.contains(parser.address(start), parser.address(end), parser.address(offset));
    }

    public static boolean contains(long start, long end, long someOffset) {
        if (someOffset < 0L) {
            return false;
        }
        if (start < end) {
            if (start < someOffset && end <= someOffset) {
                return false;
            }
            return start <= someOffset || end <= someOffset;
        }
        if (start > end) {
            return start <= someOffset || end > someOffset;
        }
        return false;
    }

    public boolean intersects(Range intersectedRange) {
        return this.contains(intersectedRange.start) || intersectedRange.contains(this.start);
    }

    @Override
    public int compareTo(Range comparedRange) {
        if (this.start != comparedRange.start) {
            return this.start > comparedRange.start ? 1 : -1;
        }
        return this.end > comparedRange.end ? 1 : (this.end == comparedRange.end ? 0 : -1);
    }

    public String toString(BufferPositionParser parser) {
        StringBuilder sb = new StringBuilder();
        sb.append("{start:");
        sb.append(parser.toString(this.start));
        sb.append(" - end:");
        sb.append(parser.toString(this.end));
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return "Range [start=" + this.start + ", end=" + this.end + "]";
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        Range r = (Range)obj;
        return r.getStart() == this.start && r.getEnd() == this.end;
    }

    public int hashCode() {
        return (int)this.start;
    }
}

