/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesHelper {
    public static final String MODULE = PropertiesHelper.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public static int getOptionalIntParam(Properties props, String paramName, int defaultValue) {
        int result = defaultValue;
        String paramStr = props.getProperty(paramName);
        if (null != paramStr) {
            try {
                result = Integer.parseInt(paramStr);
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)("Invalid value for property " + paramName + ": " + paramStr));
            }
        }
        return result;
    }

    public static int getRequiredIntParam(Properties props, String name) throws IllegalArgumentException {
        if (props.containsKey(name)) {
            return PropertiesHelper.getRequiredIntParam(props, name, -1);
        }
        throw new IllegalArgumentException("Missing required property '" + name + "'");
    }

    public static int getRequiredIntParam(Properties props, String name, int defaultValue) {
        return PropertiesHelper.getRequiredIntParamInRange(props, name, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int getRequiredIntParamInRange(Properties props, String name, int defaultValue, int rangeMin, int rangeMax) throws IllegalArgumentException {
        int value = defaultValue;
        if (props.containsKey(name)) {
            value = Integer.parseInt(props.getProperty(name));
        }
        if (value < rangeMin || value > rangeMax) {
            throw new IllegalArgumentException(name + " has value " + value + " which is not in the range (" + rangeMin + "," + rangeMax + ").");
        }
        return value;
    }

    public static long getOptionalLongParam(Properties props, String paramName, long defaultValue) {
        long result = defaultValue;
        String paramStr = props.getProperty(paramName);
        if (null != paramStr) {
            try {
                result = Long.parseLong(paramStr);
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)("Invalid value for property " + paramName + ": " + paramStr));
            }
        }
        return result;
    }

    public static double getOptionalDoubleParam(Properties props, String paramName, double defaultValue) {
        double result = defaultValue;
        String paramStr = props.getProperty(paramName);
        if (null != paramStr) {
            try {
                result = Double.parseDouble(paramStr);
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)("Invalid value for property " + paramName + ": " + paramStr));
            }
        }
        return result;
    }

    public static boolean getOptionalBooleanParam(Properties props, String paramName, boolean defaultValue) {
        boolean result = defaultValue;
        String paramStr = props.getProperty(paramName);
        if (null != paramStr) {
            result = Boolean.parseBoolean(paramStr);
        }
        return result;
    }

    public static String getRequiredStringParam(Properties props, String name) throws IllegalArgumentException {
        if (props.containsKey(name)) {
            return props.getProperty(name);
        }
        throw new IllegalArgumentException("Missing required property '" + name + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProps(String filename) {
        FileInputStream propStream = null;
        try {
            propStream = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("unable to open properties stream: " + e.getMessage()), (Throwable)e);
            return null;
        }
        Properties props = null;
        try {
            props = new Properties();
            props.load(propStream);
        }
        catch (IOException e) {
            LOG.error((Object)("unable to load properties: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (null != propStream) {
                try {
                    propStream.close();
                }
                catch (Exception e) {
                    LOG.error((Object)("unable to close property file stream:" + e.getMessage()), (Throwable)e);
                }
            }
        }
        return props;
    }
}

