/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public class ObjectGenerationTracker<T> {
    private static final int DEFAULT_SIZE = 16;
    private final IdentityHashMap<T, AgedObject<T>> _objects;
    private final List<Set<AgedObject<T>>> _generations;
    private final int _maxAge;

    public ObjectGenerationTracker(int maxAge) {
        assert (maxAge >= 0) : "negative max age";
        this._maxAge = maxAge;
        this._objects = new IdentityHashMap(16);
        this._generations = new ArrayList<Set<AgedObject<T>>>(this._maxAge + 1);
        for (int i = 0; i <= this._maxAge; ++i) {
            this._generations.add(new HashSet(16));
        }
    }

    public void add(T o) {
        AgedObject<T> agedObj = this._objects.get(o);
        if (null == agedObj) {
            agedObj = new AgedObject<T>(o);
            this._objects.put(o, agedObj);
            this._generations.get(0).add(agedObj);
        }
    }

    public void addAll(T ... objs) {
        for (T o : objs) {
            this.add(o);
        }
    }

    public void addAll(Collection<T> objs) {
        for (T o : objs) {
            this.add(o);
        }
    }

    public int age(T o) {
        return this.age(o, 1);
    }

    public int age(T o, int delta) {
        assert (delta > 0) : "non-positive delta";
        AgedObject<T> agedObj = this._objects.get(o);
        if (null == agedObj) {
            return -1;
        }
        this._generations.get(agedObj.getAge()).remove(agedObj);
        int newAge = agedObj.age(delta);
        if (newAge <= this._maxAge) {
            this._generations.get(newAge).add(agedObj);
        }
        return newAge;
    }

    public int getMaxAge() {
        return this._maxAge;
    }

    public int size() {
        return this._objects.size();
    }

    private static class AgedObject<U> {
        private final U _object;
        private int _age = 0;

        public AgedObject(U o) {
            this._object = o;
        }

        public int getAge() {
            return this._age;
        }

        public int age(int delta) {
            this._age += delta;
            return this._age;
        }

        public boolean equals(Object o) {
            if (null == o || !(o instanceof AgedObject)) {
                return false;
            }
            return this._object == ((AgedObject)o)._object;
        }

        public int hashCode() {
            return this._object.hashCode();
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("{\"age\":");
            result.append(this._age);
            result.append(", \"object\":");
            result.append(this._object.toString());
            result.append('}');
            return result.toString();
        }
    }
}

