/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger _tCnt = new AtomicInteger(0);
    private final String _namePrefix;
    private final boolean _spawnDaemons;

    public NamedThreadFactory(String namePrefix, boolean spawnDaemons) {
        this._namePrefix = namePrefix + "-";
        this._spawnDaemons = spawnDaemons;
    }

    public NamedThreadFactory(String namePrefix) {
        this(namePrefix, false);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread result = new Thread(r, this._namePrefix + this._tCnt.incrementAndGet());
        result.setDaemon(this._spawnDaemons);
        return result;
    }
}

