/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonUtils {
    public static final String JSON_SERIALIZATION_FAILURE_STRING = "JSON serialization failed";

    public static <T> String toJsonString(T bean, boolean pretty) throws JsonGenerationException, JsonMappingException, IOException {
        JsonFactory jsonFactory = new JsonFactory((ObjectCodec)new ObjectMapper());
        StringWriter out = new StringWriter(1000);
        JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator((Writer)out);
        if (pretty) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        jsonGenerator.writeObject(bean);
        out.flush();
        return out.toString();
    }

    public static <T> String toJsonStringSilent(T bean, boolean pretty) {
        try {
            return JsonUtils.toJsonString(bean, pretty);
        }
        catch (IOException ioe) {
            return JSON_SERIALIZATION_FAILURE_STRING;
        }
    }
}

