/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import com.linkedin.databus.core.util.Fnv1aHashImpl;
import com.linkedin.databus.core.util.HashFunction;
import java.nio.ByteBuffer;

public class FnvHashFunction
implements HashFunction {
    @Override
    public long hash(ByteBuffer buf) {
        return this.hash(buf, 0, buf.limit());
    }

    @Override
    public long hash(ByteBuffer buf, int off, int len) {
        long hash = Fnv1aHashImpl.addByteBuffer32(Fnv1aHashImpl.init32(), buf, off, len);
        return hash;
    }

    public long hash(byte[] key) {
        long hash = Fnv1aHashImpl.addBytes32(Fnv1aHashImpl.init32(), key, 0, key.length);
        return hash;
    }

    @Override
    public long hash(byte[] key, int numBuckets) {
        return (this.hash(key) & Long.MAX_VALUE) % (long)numBuckets;
    }

    private long hash(long val) {
        long hashval = Fnv1aHashImpl.addLong32(Fnv1aHashImpl.init32(), val);
        return hashval;
    }

    @Override
    public long hash(long val, int numBuckets) {
        return (this.hash(val) & Long.MAX_VALUE) % (long)numBuckets;
    }
}

