/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import java.nio.ByteBuffer;

public class Fnv1aHashImpl {
    private static final long FNV_BASIS_32 = 2166136261L;
    private static final long FNV_PRIME_32 = 16777619L;

    public static final long init32() {
        return 2166136261L;
    }

    public static final long addByte32(long hashAccum, byte v) {
        hashAccum ^= 0xFFL & (long)v;
        return hashAccum *= 16777619L;
    }

    public static final long addShort32(long hashAccum, short v) {
        return Fnv1aHashImpl.addByte32(Fnv1aHashImpl.addByte32(hashAccum, (byte)(v >> 8 & 0xFF)), (byte)(v & 0xFF));
    }

    public static final long addInt32(long hashAccum, int v) {
        return Fnv1aHashImpl.addShort32(Fnv1aHashImpl.addShort32(hashAccum, (short)(v >> 16 & 0xFFFF)), (short)(v & 0xFFFF));
    }

    public static final long addLong32(long hashAccum, long v) {
        return Fnv1aHashImpl.addInt32(Fnv1aHashImpl.addInt32(hashAccum, (int)(v >> 32 & 0xFFFFFFFFFFFFFFFFL)), (int)(v & 0xFFFFFFFFFFFFFFFFL));
    }

    public static final long addBytes32(long hashAccum, byte[] a, int startIdx, int num) {
        int n = startIdx + num;
        for (int i = startIdx; i < n; ++i) {
            hashAccum = Fnv1aHashImpl.addByte32(hashAccum, a[i]);
        }
        return hashAccum;
    }

    public static final long addBytes32(long hashAccum, byte[] a) {
        return Fnv1aHashImpl.addBytes32(hashAccum, a, 0, a.length);
    }

    public static long addByteBuffer32(long hashAccum, ByteBuffer buf, int startIdx, int num) {
        if (buf.hasArray()) {
            return Fnv1aHashImpl.addBytes32(hashAccum, buf.array(), startIdx, num);
        }
        int last = Math.min(startIdx + num, buf.limit());
        for (int i = startIdx; i < last; ++i) {
            hashAccum = Fnv1aHashImpl.addByte32(hashAccum, buf.get(i));
        }
        return hashAccum;
    }

    public static long addByteBuffer32(long hashAccum, ByteBuffer buf) {
        return Fnv1aHashImpl.addByteBuffer32(hashAccum, buf, 0, buf.limit());
    }

    public static long addString32(long hashAccum, String s, int startIdx, int num) {
        int endIdx = startIdx + num;
        for (int i = startIdx; i < endIdx; ++i) {
            hashAccum = Fnv1aHashImpl.addByte32(hashAccum, (byte)(s.codePointAt(i) & 0xFF));
        }
        return hashAccum;
    }

    public static long addString32(long hashAccum, String s) {
        return Fnv1aHashImpl.addString32(hashAccum, s, 0, s.length());
    }

    public static final int getHash32(long hashAccum) {
        return (int)(hashAccum & 0xFFFFFFFFFFFFFFFFL);
    }

    public static final int getHash32(long hashAccum, int numBuckets) {
        assert (numBuckets > 0);
        return (int)((hashAccum & Long.MAX_VALUE) % (long)numBuckets);
    }
}

