/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

public class FileUtils {
    public static File createTempDir(String prefix) throws IOException {
        File dir = File.createTempFile(prefix, null);
        if (!dir.delete()) {
            throw new IOException("Unable to delete temp file " + dir.getAbsolutePath());
        }
        if (!dir.mkdir()) {
            throw new IOException("Unable to create tempDir :" + dir.getAbsolutePath());
        }
        dir.deleteOnExit();
        return dir;
    }

    public static void storeLinesToTempFile(String fileName, String[] lines) throws IOException {
        FileWriter w = new FileWriter(fileName);
        for (String l : lines) {
            w.append(l);
            w.append("\n");
        }
        w.close();
    }

    public static void compareTwoTextFiles(String file1, String file2) throws AssertionError, IOException {
        new FileComparator(file1, file2).compare();
    }

    private static class FileComparator {
        private final String _file1;
        private final String _file2;

        public FileComparator(String file1, String file2) {
            this._file1 = file1;
            this._file2 = file2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void compare() throws AssertionError, IOException {
            BufferedReader br1 = null;
            BufferedReader br2 = null;
            try {
                long line;
                String strLine2;
                String strLine1;
                block7: {
                    FileInputStream fstream1 = new FileInputStream(this._file1);
                    FileInputStream fstream2 = new FileInputStream(this._file2);
                    DataInputStream in1 = new DataInputStream(fstream1);
                    DataInputStream in2 = new DataInputStream(fstream2);
                    br1 = new BufferedReader(new InputStreamReader(in1));
                    br2 = new BufferedReader(new InputStreamReader(in2));
                    strLine1 = null;
                    strLine2 = null;
                    line = 0L;
                    do {
                        strLine1 = br1.readLine();
                        strLine2 = br2.readLine();
                        if (strLine1 == null || strLine2 == null) break block7;
                        ++line;
                    } while (strLine1.equals(strLine2));
                    throw new AssertionError((Object)("Unmatched : Line :" + line + ", Str 1: (" + strLine1 + "), Str 2: (" + strLine2 + ")"));
                }
                if (strLine1 != null || strLine2 != null) {
                    throw new AssertionError((Object)("Unmatched : Line :" + line + ", Str 1: (" + strLine1 + "), Str 2: (" + strLine2 + ")"));
                }
            }
            finally {
                if (null != br1) {
                    br1.close();
                }
                if (null != br2) {
                    br2.close();
                }
            }
        }
    }
}

