/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.DbusEventBufferMult;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.KeyTypeNotImplementedException;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.DatabusEventProducer;
import com.linkedin.databus.core.util.IdNamePair;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus.core.util.RateMonitor;
import com.linkedin.databus.core.util.RngUtils;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.avro.Schema;
import org.apache.log4j.Logger;

public class DatabusEventRandomProducer
extends Thread
implements DatabusEventProducer {
    public static final String MODULE = DatabusEventRandomProducer.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    protected static final int MILLISECONDS_IN_NANOS = 1000000;
    protected static final double NANOSECONDS_IN_A_SECOND = 1.0E9;
    protected final CountDownLatch _generationStopped;
    protected final DbusEventBufferMult _dbusEventBuffer;
    protected List<IdNamePair> _sources;
    protected List<Schema> _schemas = null;
    protected Map<Long, byte[]> _schemaIds = null;
    protected double _tickInNanos;
    protected long _duration;
    protected long _startScn;
    protected final AtomicBoolean _stopGeneration = new AtomicBoolean(true);
    protected DbusEventsStatisticsCollector _statsCollector = null;
    protected final AtomicBoolean _suspendGeneration = new AtomicBoolean(true);
    protected int _minLength;
    protected int _maxLength;
    protected int _maxEventsPerWindow;
    protected int _minEventsPerWindow;
    protected String _generationPattern;
    protected long _totalGenerationTime;
    protected long _numEventsGenerated;
    protected RateMonitor _rateMonitor;
    protected long _generateBaseTime = System.currentTimeMillis() * 1000000L;
    protected long _generateBaseNanoTime = System.nanoTime();
    protected final AtomicLong _numEventsToGenerate = new AtomicLong(Long.MAX_VALUE);
    protected final AtomicLong _keyMin = new AtomicLong(0L);
    protected final AtomicLong _keyMax = new AtomicLong(Long.MAX_VALUE);
    protected final StaticConfig _config;
    protected final AtomicInteger _percentOfBufferToGenerate = new AtomicInteger(Integer.MAX_VALUE);
    Map<Integer, Integer> genEventsPerSource = new HashMap<Integer, Integer>(100);
    protected final Random _realRng = new Random();

    public DatabusEventRandomProducer(DbusEventBufferMult dbuf, long startScn, int eventsPerSecond, long durationInMilliseconds, List<IdNamePair> sources, StaticConfig config) {
        this(dbuf, startScn, eventsPerSecond, durationInMilliseconds, sources, null, config);
    }

    public DatabusEventRandomProducer(DbusEventBufferMult dbuf, long startScn, int eventsPerSecond, long durationInMilliseconds, List<IdNamePair> sources, Map<Long, byte[]> schemaIds) {
        this(dbuf, startScn, eventsPerSecond, durationInMilliseconds, sources, schemaIds, null);
    }

    public DatabusEventRandomProducer(DbusEventBufferMult dbuf, StaticConfig config) {
        super("DatabusEventRandomProducer");
        if (null == config) {
            try {
                config = new Config().build();
            }
            catch (InvalidConfigException ice) {
                throw new RuntimeException(ice);
            }
        }
        this._config = config;
        this._statsCollector = new DbusEventsStatisticsCollector(1, "dummy", false, false, null);
        this._generationStopped = new CountDownLatch(1);
        this._dbusEventBuffer = dbuf;
        this._duration = config.getDuration();
        this._sources = config.getIdNameList();
        this._startScn = config.getStartScn();
        this.setDaemon(true);
        this._minLength = config.getMinLength();
        this._maxLength = config.geMaxLength();
        this._minEventsPerWindow = config.getMinEventsPerWindow();
        this._maxEventsPerWindow = config.getMaxEventsPerWindow();
        LOG.info((Object)("Sources: " + this._sources + ",duration:" + this._duration + ",tickInMS:" + this._tickInNanos + ",startScn" + this._startScn));
        LOG.info((Object)("minEventsPerWindow:" + this._minEventsPerWindow + ",maxEventsPerWindow:" + this._maxEventsPerWindow));
        this._tickInNanos = 1.0E9 / (double)config.getEventRate();
        LOG.info((Object)("Will wait for " + this._tickInNanos + " nanoseconds per event produced"));
        for (IdNamePair p : this._sources) {
            this.genEventsPerSource.put(p.getId().intValue(), 0);
        }
    }

    public DatabusEventRandomProducer(DbusEventBufferMult dbuf, long startScn, int eventsPerSecond, long durationInMilliseconds, List<IdNamePair> sources, Map<Long, byte[]> schemaIds, StaticConfig config) {
        super("DatabusEventRandomProducer");
        if (null == config) {
            try {
                config = new Config().build();
            }
            catch (InvalidConfigException ice) {
                throw new RuntimeException(ice);
            }
        }
        this._config = config;
        this._generationStopped = new CountDownLatch(1);
        this._dbusEventBuffer = dbuf;
        this._schemaIds = schemaIds;
        this._tickInNanos = 1.0E9 / (double)eventsPerSecond;
        this._duration = durationInMilliseconds;
        this._sources = sources;
        this._startScn = startScn;
        this.setDaemon(true);
        this._minLength = config.getMinLength();
        this._maxLength = config.geMaxLength();
        this._maxEventsPerWindow = config.getMaxEventsPerWindow();
        this._minEventsPerWindow = config.getMinEventsPerWindow();
        this._generationPattern = config.getGenerationPattern();
        LOG.info((Object)("Sources: " + sources + ",duration:" + this._duration + ",tickInMS:" + this._tickInNanos + ",startScn" + startScn));
        LOG.info((Object)("Will wait for " + this._tickInNanos + " nanoseconds per event produced"));
    }

    public long produceNRandomEvents(long startScn, long currentTime, int numberOfEvents, List<IdNamePair> sources, long keyMin, long keyMax, int minLength, int maxLength, List<Schema> schemas) throws KeyTypeNotImplementedException {
        long endScn = startScn + 1L + RngUtils.randomPositiveLong() % 100L;
        long scnDiff = endScn - startScn;
        long maxScn = startScn;
        int numSources = sources.size();
        int eventsPerSource = numberOfEvents / numSources + 1;
        if (eventsPerSource <= 0) {
            eventsPerSource = 1;
        }
        this._dbusEventBuffer.startAllEvents();
        assert (endScn > startScn);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("endScn = " + endScn + " startScn = " + startScn));
        }
        byte[] defaultSchemaId = "abcdefghijklmnop".getBytes(Charset.defaultCharset());
        boolean enableTracing = RngUtils.randomPositiveLong() % 100L <= 1L;
        for (int i = 0; i < numberOfEvents; ++i) {
            DbusEventKey key = new DbusEventKey(RngUtils.randomPositiveLong(keyMin, keyMax));
            long scn = startScn + (long)i / scnDiff;
            short srcId = sources.get(i / eventsPerSource).getId().shortValue();
            byte[] schemaId = this._schemaIds != null ? this._schemaIds.get(srcId) : defaultSchemaId;
            this.genEventsPerSource.put(Integer.valueOf(srcId), this.genEventsPerSource.get(srcId) + 1);
            String value = null;
            short rnd = RngUtils.randomPositiveShort();
            int length = minLength + rnd % (maxLength - minLength);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating random record with SCN =" + scn + " and length =" + length));
            }
            value = RngUtils.randomString(length);
            short lPartitionId = LogicalSourceConfig.DEFAULT_LOGICAL_SOURCE_PARTITION;
            short pPartitionId = this._dbusEventBuffer.getPhysicalPartition(srcId).getId().shortValue();
            DbusEventBufferAppendable buf = this._dbusEventBuffer.getDbusEventBufferAppendable(srcId);
            boolean appended = buf.appendEvent(key, pPartitionId, lPartitionId, currentTime, srcId, schemaId, value.getBytes(Charset.defaultCharset()), enableTracing, this._statsCollector);
            assert (appended);
            maxScn = Math.max(scn, maxScn);
            if (!LOG.isDebugEnabled() || i % 7 != 0) continue;
            LOG.debug((Object)("Produce: srcId=" + srcId + ";pSid=" + this._dbusEventBuffer.getPhysicalPartition(srcId) + ";scn=" + scn + "; buf(hc)=" + buf.hashCode()));
        }
        StringBuilder s = new StringBuilder(100);
        for (Map.Entry<Integer, Integer> e : this.genEventsPerSource.entrySet()) {
            s.append(e.getKey() + ":" + e.getValue() + ",");
        }
        LOG.info((Object)("generated sources/events = " + s.toString()));
        this._dbusEventBuffer.endAllEvents(maxScn, this.getCurrentNanoTime(), this._statsCollector);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Produce:window:" + maxScn));
        }
        assert (maxScn >= startScn);
        return maxScn;
    }

    public String getRateOfProduction() {
        if (this._totalGenerationTime <= 0L) {
            throw new IllegalStateException("Producer hasnt been started yet !!");
        }
        double rate = (double)this._numEventsGenerated * 1000.0 * 1000000.0 / (double)this._totalGenerationTime;
        String msg = "\"Rate\":" + rate + ",\"NumEvents\":" + this._numEventsGenerated + ",\"TotalTime\":" + this._totalGenerationTime;
        return msg;
    }

    public double getProductionRate() {
        if (this._totalGenerationTime <= 0L) {
            throw new IllegalStateException("Producer hasnt been started yet !!");
        }
        return this._rateMonitor.getRate();
    }

    @Override
    public boolean startGeneration(long startScn, int eventsPerSecond, long durationInMilliseconds, long numEventToGenerate, int percentOfBufferToGenerate, long keyMin, long keyMax, List<IdNamePair> sources, DbusEventsStatisticsCollector statsCollector) {
        if (!this._stopGeneration.getAndSet(false)) {
            return false;
        }
        for (IdNamePair p : sources) {
            this.genEventsPerSource.put(p.getId().intValue(), 0);
        }
        this._statsCollector = statsCollector;
        this._tickInNanos = 1.0E9 / (double)eventsPerSecond;
        this._duration = durationInMilliseconds;
        this._sources = sources;
        this._startScn = startScn;
        this._keyMin.set(keyMin);
        this._keyMax.set(keyMax);
        this._numEventsToGenerate.set(numEventToGenerate);
        this._percentOfBufferToGenerate.set(percentOfBufferToGenerate);
        LOG.info((Object)("Will wait for " + this._tickInNanos + " nanoseconds per event produced"));
        this.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGeneration() {
        DatabusEventRandomProducer databusEventRandomProducer = this;
        synchronized (databusEventRandomProducer) {
            this._stopGeneration.set(true);
            this.notifyAll();
        }
    }

    public void stopGenerationAndWait() {
        this.stopGeneration();
        while (true) {
            try {
                this._generationStopped.await();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public boolean checkRunning() {
        return !this._stopGeneration.get() && !this._suspendGeneration.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendGeneration() {
        DatabusEventRandomProducer databusEventRandomProducer = this;
        synchronized (databusEventRandomProducer) {
            this._suspendGeneration.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeGeneration(long numEventToGenerate, int percentOfBufferToGenerate, long keyMin, long keyMax) {
        DatabusEventRandomProducer databusEventRandomProducer = this;
        synchronized (databusEventRandomProducer) {
            this._suspendGeneration.set(false);
            this._numEventsToGenerate.set(numEventToGenerate);
            this._percentOfBufferToGenerate.set(percentOfBufferToGenerate);
            this._keyMin.set(keyMin);
            this._keyMax.set(keyMax);
            this.notifyAll();
        }
    }

    public void fillBuffer(int eventBatchSize) {
        long maxScn = 0L;
        long currTime = this.getCurrentNanoTime();
        try {
            maxScn = this.produceNRandomEvents(this._startScn, currTime, eventBatchSize, this._sources, this._keyMin.get(), this._keyMax.get(), this._minLength, this._maxLength, this._schemas);
            assert (maxScn >= this._startScn);
            this._startScn = maxScn + 1L;
        }
        catch (KeyTypeNotImplementedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime;
        this._stopGeneration.set(false);
        this._suspendGeneration.set(false);
        long startTime0 = startTime = System.nanoTime();
        long realStartTime = System.currentTimeMillis() * 1000000L;
        this._numEventsGenerated = 0L;
        int eventBatchSize = 10;
        long currTime = startTime;
        long sleepTimes = 0L;
        long sleepTime = 0L;
        long firstScn = this._startScn;
        long numEventsGeneratedAfterResume = 0L;
        long eventBufferSize = 0L;
        long sizeDataEventsBeforeResume = 0L;
        long currSizeDataEvents = this._statsCollector.getTotalStats().getSizeDataEvents() * this._statsCollector.getTotalStats().getNumDataEvents();
        long maxScn = firstScn;
        long minSpace = Long.MAX_VALUE;
        for (DbusEventBuffer buf : this._dbusEventBuffer.bufIterable()) {
            long tmpMinSpace;
            if (buf.getMinScn() < 0L) {
                buf.start(firstScn - 1L);
            }
            if ((tmpMinSpace = buf.getBufferFreeSpace()) >= minSpace) continue;
            minSpace = tmpMinSpace;
        }
        if (this._dbusEventBuffer.bufsNum() > 0) {
            eventBufferSize = minSpace;
        }
        try {
            this._rateMonitor = new RateMonitor("RandomProducer");
            this._rateMonitor.start();
            while (!this._stopGeneration.get()) {
                LOG.info((Object)("Resume. currTime (ms) = " + currTime / 1000000L + ", startTime (ms) = " + startTime / 1000000L + ", elapseTime = " + (currTime - startTime) / 1000000L + ", _duration=" + this._duration + ", numEventsToGenerate = " + this._numEventsToGenerate.get() + ", StartScn = " + firstScn + ", _minEventsPerWindow=" + this._minEventsPerWindow + ", _maxEventsPerWindow =" + this._maxEventsPerWindow + ", _keyMin =" + this._keyMin + ", _keyMax =" + this._keyMax + ", _minLength=" + this._minLength + ", _maxLength=" + this._maxLength + ", numEvents = " + numEventsGeneratedAfterResume + ", eventBufferSize = " + eventBufferSize + ", sources = " + this._sources.size()));
                while (!this._stopGeneration.get() && !this._suspendGeneration.get() && currTime - startTime < this._duration * 1000000L && numEventsGeneratedAfterResume < this._numEventsToGenerate.get() && (double)(currSizeDataEvents - sizeDataEventsBeforeResume) < (double)this._percentOfBufferToGenerate.get() / 100.0 * (double)eventBufferSize) {
                    eventBatchSize = this._minEventsPerWindow + RngUtils.randomPositiveShort(this._realRng) % (this._maxEventsPerWindow - this._minEventsPerWindow);
                    long before = System.nanoTime();
                    this._rateMonitor.resume();
                    maxScn = this.produceNRandomEvents(firstScn, realStartTime + (currTime - startTime0), eventBatchSize, this._sources, this._keyMin.get(), this._keyMax.get(), this._minLength, this._maxLength, this._schemas);
                    assert (maxScn >= firstScn);
                    this._rateMonitor.ticks(eventBatchSize + 1);
                    this._rateMonitor.suspend();
                    currTime = System.nanoTime();
                    currSizeDataEvents = this._statsCollector.getTotalStats().getSizeDataEvents() * this._statsCollector.getTotalStats().getNumDataEvents();
                    firstScn = maxScn + 1L;
                    this._numEventsGenerated += (long)eventBatchSize;
                    this._totalGenerationTime += currTime - before;
                    long nextTime = (long)((double)startTime + (double)(numEventsGeneratedAfterResume += (long)eventBatchSize) * this._tickInNanos);
                    if (nextTime <= currTime) continue;
                    try {
                        ++sleepTimes;
                        sleepTime += nextTime - currTime;
                        long milliseconds = (nextTime - currTime) / 1000000L;
                        int nanoseconds = (int)(nextTime - currTime - milliseconds * 1000000L);
                        Thread.sleep(milliseconds, nanoseconds);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        LOG.info((Object)("Produced " + this._numEventsGenerated + " events in " + (currTime - startTime) + " nanoseconds."));
                        LOG.info((Object)("Slept a total of " + sleepTimes + " times for a duration of " + sleepTime + " nanoseconds."));
                        LOG.info((Object)("Busy time = " + (currTime - startTime - sleepTime) + " nanoseconds."));
                        this._rateMonitor.stop();
                        this._generationStopped.countDown();
                        return;
                    }
                    currTime = System.nanoTime();
                }
                LOG.info((Object)("Suspended. currTime (ms) = " + currTime / 1000000L + ", startTime (ms) = " + startTime / 1000000L + ", elapseTime = " + (currTime - startTime) / 1000000L + ", numEvents = " + numEventsGeneratedAfterResume + ", eventBufferSize = " + eventBufferSize + ", currEventSize = " + currSizeDataEvents + ", startEventSize = " + sizeDataEventsBeforeResume + ", EventSizeDelta = " + (currSizeDataEvents - sizeDataEventsBeforeResume)));
                LOG.info((Object)this.getRateOfProduction());
                DatabusEventRandomProducer before = this;
                synchronized (before) {
                    if (!this._stopGeneration.get()) {
                        boolean doWait = false;
                        if (!this._suspendGeneration.get()) {
                            if (currTime - startTime >= this._duration * 1000000L || numEventsGeneratedAfterResume >= this._numEventsToGenerate.get() || (double)(currSizeDataEvents - sizeDataEventsBeforeResume) >= (double)this._percentOfBufferToGenerate.get() / 100.0 * (double)eventBufferSize) {
                                doWait = true;
                                this._suspendGeneration.set(true);
                            } else {
                                doWait = false;
                            }
                        } else {
                            doWait = true;
                        }
                        while (doWait && !this._stopGeneration.get() && this._suspendGeneration.get()) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ie) {
                                LOG.info((Object)("Got Interrupted during suspension: " + ie.getMessage()));
                            }
                        }
                        currTime = startTime = System.nanoTime();
                        numEventsGeneratedAfterResume = 0L;
                        sizeDataEventsBeforeResume = currSizeDataEvents;
                    }
                }
            }
            this._stopGeneration.set(true);
        }
        catch (RuntimeException e) {
            LOG.error((Object)("event generation error:" + e.getMessage()), (Throwable)e);
        }
        catch (KeyTypeNotImplementedException e) {
            LOG.error((Object)("event generation error:" + e.getMessage()), (Throwable)e);
        }
        finally {
            LOG.info((Object)("Produced " + this._numEventsGenerated + " events in " + (currTime - startTime) + " nanoseconds."));
            LOG.info((Object)("Slept a total of " + sleepTimes + " times for a duration of " + sleepTime + " nanoseconds."));
            LOG.info((Object)("Busy time = " + (currTime - startTime - sleepTime) + " nanoseconds."));
            this._rateMonitor.stop();
            this._generationStopped.countDown();
        }
    }

    public void setStatsCollector(DbusEventsStatisticsCollector statsCollector) {
        this._statsCollector = statsCollector;
    }

    public long getCurrentNanoTime() {
        return this._generateBaseTime + (System.nanoTime() - this._generateBaseNanoTime);
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        protected long startScn;
        protected int eventRate;
        protected long duration;
        protected String sourceIdMapStr;
        protected int minLength = 1000;
        protected int maxLength = 1001;
        protected int minEventsPerWindow = 10;
        protected int maxEventsPerWindow = 11;
        protected String generationPattern = "RandomOnly";
        private long _eventRngSeed = -1L;

        public int getMinLength() {
            return this.minLength;
        }

        public void setMinLength(int minLength) {
            this.minLength = minLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public void setMaxLength(int maxLength) {
            LOG.info((Object)("maxLength:" + maxLength));
            this.maxLength = maxLength;
        }

        public int getMinEventsPerWindow() {
            return this.minEventsPerWindow;
        }

        public void setMinEventsPerWindow(int minEventsPerWindow) {
            LOG.info((Object)("minEventsPerWindow:" + minEventsPerWindow));
            this.minEventsPerWindow = minEventsPerWindow;
        }

        public int getMaxEventsPerWindow() {
            return this.maxEventsPerWindow;
        }

        public void setMaxEventsPerWindow(int maxEventsPerWindow) {
            LOG.info((Object)("maxEventsPerWindow:" + maxEventsPerWindow));
            this.maxEventsPerWindow = maxEventsPerWindow;
        }

        public String getGenerationPattern() {
            return this.generationPattern;
        }

        public void setGenerationPattern(String generationPattern) {
            LOG.info((Object)("GenerationPattern:" + generationPattern));
            this.generationPattern = generationPattern;
        }

        @Override
        public StaticConfig build() throws InvalidConfigException {
            ArrayList<IdNamePair> idNameList = new ArrayList<IdNamePair>();
            if (this.sourceIdMapStr != null) {
                String[] tokens = this.sourceIdMapStr.split("[,]");
                for (int i = 0; i < tokens.length; ++i) {
                    String[] items = tokens[i].split("[:]");
                    if (items.length != 2) {
                        throw new InvalidConfigException("SourceIdMap Config (" + this.sourceIdMapStr + ") invalid !!");
                    }
                    IdNamePair pair = new IdNamePair();
                    pair.setId(Long.parseLong(items[0].trim()));
                    pair.setName(items[1].trim());
                    LOG.debug((Object)("SrcId Entry:" + items[0] + "," + items[1]));
                    idNameList.add(pair);
                }
            }
            return new StaticConfig(this.startScn, this.eventRate, this.duration, idNameList, this.minLength, this.maxLength, this.minEventsPerWindow, this.maxEventsPerWindow, this.generationPattern, this._eventRngSeed);
        }

        public long getStartScn() {
            return this.startScn;
        }

        public void setStartScn(long startScn) {
            LOG.info((Object)("startScn:" + startScn));
            this.startScn = startScn;
        }

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            LOG.info((Object)("Duration:" + duration));
            this.duration = duration;
        }

        public int getEventRate() {
            return this.eventRate;
        }

        public void setEventRate(int eventRate) {
            LOG.info((Object)("EventRate:" + eventRate));
            this.eventRate = eventRate;
        }

        public String getSourceIdMap() {
            return this.sourceIdMapStr;
        }

        public void setSourceIdMap(String sourceIdMapStr) {
            LOG.info((Object)("sourceIdMapStr:" + sourceIdMapStr));
            this.sourceIdMapStr = sourceIdMapStr;
        }

        public long getEventRngSeed() {
            return this._eventRngSeed;
        }

        public void setEventRngSeed(long eventRngSeed) {
            this._eventRngSeed = eventRngSeed;
        }
    }

    public static class StaticConfig {
        protected long _startScn;
        protected int _eventRate;
        protected long _duration;
        protected List<IdNamePair> _idNameList;
        protected int _minLength;
        protected int _maxLength;
        protected int _minEventsPerWindow;
        protected int _maxEventsPerWindow;
        protected String _generationPattern;
        private final long _eventRngSeed;

        public int getMinLength() {
            return this._minLength;
        }

        public int geMaxLength() {
            return this._maxLength;
        }

        public int getMaxEventsPerWindow() {
            return this._maxEventsPerWindow;
        }

        public int getMinEventsPerWindow() {
            return this._minEventsPerWindow;
        }

        public String getGenerationPattern() {
            return this._generationPattern;
        }

        public long getStartScn() {
            return this._startScn;
        }

        public int getEventRate() {
            return this._eventRate;
        }

        public long getDuration() {
            return this._duration;
        }

        public StaticConfig(long startScn, int eventRate, long duration, List<IdNamePair> idNameList, int minLength, int maxLength, int minEventsPerWindow, int maxEventsPerWindow, String generationPattern, long eventRngSeed) {
            this._startScn = startScn;
            this._eventRate = eventRate;
            this._duration = duration;
            this._idNameList = idNameList;
            this._minLength = minLength;
            this._maxLength = maxLength;
            this._minEventsPerWindow = minEventsPerWindow;
            this._maxEventsPerWindow = maxEventsPerWindow;
            this._generationPattern = generationPattern;
            this._eventRngSeed = eventRngSeed;
            LOG.debug((Object)("Constructor: IDNameList:" + idNameList));
        }

        public List<IdNamePair> getIdNameList() {
            return this._idNameList;
        }

        public long getEventRngSeed() {
            return this._eventRngSeed;
        }
    }
}

