/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import com.linkedin.databus.core.util.ConfigApplier;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus.core.util.InvalidConfigException;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class ConfigManager<D extends ConfigApplier<D>>
extends ConfigLoader<D> {
    public static final String MODULE = ConfigManager.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private D _readonlyConfig;

    public ConfigManager(String propPrefix, ConfigBuilder<D> dynConfigBuilder) throws InvalidConfigException {
        super(propPrefix, dynConfigBuilder);
        this.setNewConfig((ConfigApplier)this._configBuilder.build());
    }

    @Override
    public D loadConfig(Map<?, ?> props) throws InvalidConfigException {
        ConfigApplier newConfig = (ConfigApplier)super.loadConfig(props);
        return (D)this.setNewConfig(newConfig);
    }

    @Override
    public D setSetting(String settingName, Object value) throws InvalidConfigException {
        ConfigApplier newConfig = (ConfigApplier)super.setSetting(settingName, value);
        return (D)this.setNewConfig(newConfig);
    }

    @Override
    public D loadConfigFromJson(Reader jsonReader) throws InvalidConfigException {
        ConfigApplier newConfig = (ConfigApplier)super.loadConfigFromJson(jsonReader);
        return (D)this.setNewConfig(newConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D getReadOnlyConfig() {
        Lock readLock = this.acquireReadLock();
        try {
            D d = this._readonlyConfig;
            return d;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D setNewConfig(D newConfig) {
        Object oldConfig = null;
        Lock writeLock = this.acquireWriteLock();
        try {
            oldConfig = this._readonlyConfig;
            this._readonlyConfig = newConfig;
            try {
                this._readonlyConfig.applyNewConfig(oldConfig);
            }
            catch (Exception e) {
                LOG.error((Object)"Error updating config", (Throwable)e);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
        return newConfig;
    }
}

