/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus.core.util.ReadWriteSyncedObject;
import java.beans.PropertyDescriptor;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class ConfigLoader<D>
extends ReadWriteSyncedObject {
    public static final String MODULE = ConfigLoader.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    protected final String _propPrefix;
    protected final ConfigBuilder<D> _configBuilder;
    private BeanUtilsBean _beanUtilsBean;

    public ConfigLoader(String propPrefix, ConfigBuilder<D> dynConfigBuilder) throws InvalidConfigException {
        super(true);
        this._propPrefix = propPrefix;
        this._configBuilder = dynConfigBuilder;
        this._beanUtilsBean = new BeanUtilsBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D loadConfig(Map<?, ?> props) throws InvalidConfigException {
        HashMap realProps = new HashMap();
        D result = null;
        if (this._propPrefix != null && this._propPrefix.length() > 0) {
            int prefixLen = this._propPrefix.length();
            for (Map.Entry<?, ?> entry : props.entrySet()) {
                String keyStr = entry.getKey().toString();
                if (!keyStr.startsWith(this._propPrefix)) continue;
                String realKey = keyStr.substring(prefixLen);
                realProps.put(realKey, entry.getValue());
            }
        } else {
            for (Map.Entry<?, ?> entry : props.entrySet()) {
                realProps.put(entry.getKey().toString(), entry.getValue());
            }
        }
        ConfigBuilder<D> configBuilder = this._configBuilder;
        synchronized (configBuilder) {
            for (Map.Entry<Object, Object> entry : realProps.entrySet()) {
                this.setBareSetting((String)entry.getKey(), entry.getValue());
            }
            result = this._configBuilder.build();
        }
        return result;
    }

    private void setBareSetting(String settingName, Object value) throws InvalidConfigException {
        PropertyDescriptor propDesc = null;
        try {
            propDesc = this._beanUtilsBean.getPropertyUtils().getPropertyDescriptor(this._configBuilder, settingName);
        }
        catch (Exception e) {
            throw new InvalidConfigException("Error obtaining configuration property. settingName=" + settingName, e);
        }
        if (null == propDesc) {
            throw new InvalidConfigException("Unknown configuration property:" + settingName);
        }
        try {
            if (value instanceof String) {
                value = ((String)value).trim();
            }
            this._beanUtilsBean.setProperty(this._configBuilder, settingName, value);
        }
        catch (Exception e) {
            throw new InvalidConfigException("setting failed: " + settingName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D setSetting(String settingName, Object value) throws InvalidConfigException {
        ConfigBuilder<D> configBuilder = this._configBuilder;
        synchronized (configBuilder) {
            if (settingName.startsWith(this._propPrefix)) {
                String realKey = settingName.substring(this._propPrefix.length());
                this.setBareSetting(realKey, value);
            }
            D newConfig = this._configBuilder.build();
            return newConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D loadConfigFromJson(Reader jsonReader) throws InvalidConfigException {
        D newConfig = null;
        try {
            ObjectMapper _jsonMapper = new ObjectMapper();
            Map jsonMap = (Map)_jsonMapper.readValue(jsonReader, new TypeReference<Map<?, ?>>(){});
            ConfigBuilder<D> configBuilder = this._configBuilder;
            synchronized (configBuilder) {
                this.fillBeanFromMap(this._configBuilder, jsonMap);
            }
            newConfig = this._configBuilder.build();
        }
        catch (Exception e) {
            throw new InvalidConfigException("Load from JSON failed", e);
        }
        return newConfig;
    }

    private void fillBeanFromMap(Object bean, Map<?, ?> map) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyUtilsBean propUtils = this._beanUtilsBean.getPropertyUtils();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String keyStr = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Object subBean = propUtils.getProperty(bean, keyStr);
                if (null == subBean) continue;
                this.fillBeanFromMap(subBean, (Map)value);
                continue;
            }
            if (value instanceof List) {
                this.fillPropertyFromList(bean, keyStr, (List)value);
                continue;
            }
            propUtils.setProperty(bean, keyStr, value);
        }
    }

    private void fillPropertyFromList(Object bean, String propName, List<?> values) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyUtilsBean propUtils = this._beanUtilsBean.getPropertyUtils();
        int idx = 0;
        for (Object elem : values) {
            if (elem instanceof Map) {
                Object subBean = propUtils.getIndexedProperty(bean, propName, idx);
                this.fillBeanFromMap(subBean, (Map)elem);
            } else {
                propUtils.setIndexedProperty(bean, propName, idx, elem);
            }
            ++idx;
        }
    }

    public ConfigBuilder<D> getConfigBuilder() {
        return this._configBuilder;
    }

    public String getPropPrefix() {
        return this._propPrefix;
    }
}

