/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import com.linkedin.databus.core.util.InvalidConfigException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigHelper {
    public static final Pattern DURATION_PATTERN = Pattern.compile("\\s*(\\d+)\\s*(ns|nanos|nanosecond|nanoseconds|us|micros|microsecond|microseconds|ms|millis|millisecond|milliseconds|s|sec|second|seconds|min|minute|minutes|h|hr|hour|hours|d|day|days)?\\s*", 2);
    public static final Pattern BYTE_SIZE_PATTERN = Pattern.compile("\\s*(\\d+)\\s*(k|K|m|M|g|G|t|T|p|P|e|E)?\\s*");

    public static long parseDuration(String durationStr, TimeUnit defaultUnit) throws InvalidConfigException {
        if (null == durationStr) {
            return 0L;
        }
        TimeUnit unit = defaultUnit;
        Matcher m = DURATION_PATTERN.matcher(durationStr);
        if (!m.matches()) {
            throw new InvalidConfigException("invalid duration string: " + durationStr);
        }
        if (1 < m.groupCount() && null != m.group(2) && 0 < m.group(2).length()) {
            char unitChar1 = m.group(2).charAt(0);
            switch (unitChar1) {
                case 'N': 
                case 'n': {
                    unit = TimeUnit.NANOSECONDS;
                    break;
                }
                case 'U': 
                case 'u': {
                    unit = TimeUnit.MICROSECONDS;
                    break;
                }
                case 'M': 
                case 'm': {
                    int unitChar3 = m.group(2).length() >= 3 ? (int)m.group(2).charAt(2) : 32;
                    unit = 110 == unitChar3 || 78 == unitChar3 ? TimeUnit.MINUTES : TimeUnit.MILLISECONDS;
                    break;
                }
                case 'S': 
                case 's': {
                    unit = TimeUnit.SECONDS;
                    break;
                }
                case 'H': 
                case 'h': {
                    unit = TimeUnit.HOURS;
                    break;
                }
                case 'D': 
                case 'd': {
                    unit = TimeUnit.DAYS;
                }
            }
        }
        long value = Long.parseLong(m.group(1));
        return defaultUnit.convert(value, unit);
    }

    public static long parseByteSize(String sizeString) throws InvalidConfigException {
        if (null == sizeString) {
            return 0L;
        }
        long unit = 1L;
        Matcher m = BYTE_SIZE_PATTERN.matcher(sizeString);
        if (!m.matches()) {
            throw new InvalidConfigException("invalid byte-size string: " + sizeString);
        }
        if (1 < m.groupCount() && null != m.group(2) && 0 < m.group(2).length()) {
            char unitChar1 = m.group(2).charAt(0);
            switch (unitChar1) {
                case 'k': {
                    unit = 1000L;
                    break;
                }
                case 'K': {
                    unit = 1024L;
                    break;
                }
                case 'm': {
                    unit = 1000000L;
                    break;
                }
                case 'M': {
                    unit = 0x100000L;
                    break;
                }
                case 'g': {
                    unit = 1000000000L;
                    break;
                }
                case 'G': {
                    unit = 0x40000000L;
                    break;
                }
                case 't': {
                    unit = 1000000000000L;
                    break;
                }
                case 'T': {
                    unit = 0x10000000000L;
                    break;
                }
                case 'p': {
                    unit = 1000000000000000L;
                    break;
                }
                case 'P': {
                    unit = 0x4000000000000L;
                    break;
                }
                case 'e': {
                    unit = 1000000000000000000L;
                    break;
                }
                case 'E': {
                    unit = 0x1000000000000000L;
                }
            }
        }
        long value = Long.parseLong(m.group(1));
        return unit * value;
    }
}

