/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import com.linkedin.databus.core.DatabusRuntimeException;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class BufferPositionParser {
    public static final String MODULE = BufferPositionParser.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final int NUM_BITS_IN_LONG = 64;
    private final long _offsetMask;
    private final long _indexMask;
    private final long _genIdMask;
    private final int _offsetShift;
    private final int _indexShift;
    private final int _genIdShift;
    private final long _totalBufferSize;

    public BufferPositionParser(int individualBufferSize, int numIndices) {
        assert (individualBufferSize > 0);
        assert (numIndices > 0);
        LOG.info((Object)("Individual Buffer Size: " + Long.toHexString(individualBufferSize)));
        LOG.info((Object)("Num Buffers: " + numIndices));
        int offsetLength = Long.toBinaryString(individualBufferSize - 1).length();
        int indexLength = Long.toBinaryString(numIndices - 1).length();
        this._offsetShift = 0;
        this._indexShift = offsetLength;
        this._genIdShift = offsetLength + indexLength;
        long signedBitMask = Long.MAX_VALUE;
        long signMask = signedBitMask ^ 0xFFFFFFFFFFFFFFFFL;
        LOG.info((Object)("Offset Length: " + offsetLength));
        this._offsetMask = signMask >> 64 - offsetLength - 1 ^ 0xFFFFFFFFFFFFFFFFL;
        this._indexMask = signMask >> 64 - offsetLength - indexLength - 1 ^ 0xFFFFFFFFFFFFFFFFL ^ this._offsetMask;
        this._genIdMask = Long.MAX_VALUE ^ this._indexMask ^ this._offsetMask;
        this._totalBufferSize = individualBufferSize * numIndices;
        LOG.info((Object)("buffer position for the EventBuffer: " + this.toString()));
    }

    public long getOffsetMask() {
        return this._offsetMask;
    }

    public long getIndexMask() {
        return this._indexMask;
    }

    public long getGenIdMask() {
        return this._genIdMask;
    }

    public int getOffsetShift() {
        return this._offsetShift;
    }

    public int getIndexShift() {
        return this._indexShift;
    }

    public int getGenIdShift() {
        return this._genIdShift;
    }

    public boolean init(long position) {
        return position < 0L;
    }

    public long encode(long genId, int index, int offset) {
        long shiftedOffset = (long)offset << this._offsetShift;
        if (offset < 0 || shiftedOffset > this._offsetMask) {
            throw new DatabusRuntimeException("invalid position offset: " + offset);
        }
        long shiftedIndex = (long)index << this._indexShift;
        if (index < 0 || shiftedIndex > this._indexMask) {
            throw new DatabusRuntimeException("invalid position index: " + index);
        }
        long shiftedGenId = genId << this._genIdShift;
        if (genId < 0L || shiftedGenId > this._genIdMask) {
            throw new DatabusRuntimeException("invalid position gen-id: " + genId);
        }
        long pos = shiftedGenId | shiftedIndex | shiftedOffset;
        return pos;
    }

    public long setOffset(long position, int offset) {
        return this.encode(this.bufferGenId(position), this.bufferIndex(position), offset);
    }

    public long setIndex(long position, int index) {
        return this.encode(this.bufferGenId(position), index, this.bufferOffset(position));
    }

    public long setGenId(long position, long genId) {
        return this.encode(genId, this.bufferIndex(position), this.bufferOffset(position));
    }

    public long address(long position) {
        return this.setGenId(position, 0L);
    }

    public int bufferIndex(long position) {
        long index = (position & this._indexMask) >> this._indexShift;
        return (int)index;
    }

    public int bufferOffset(long position) {
        int offset = (int)((position & this._offsetMask) >> this._offsetShift);
        return offset;
    }

    public long bufferGenId(long position) {
        long genId = (position & this._genIdMask) >> this._genIdShift;
        return genId;
    }

    public long incrementGenId(long currentPosition) {
        return this.encode(this.bufferGenId(currentPosition) + 1L, 0, 0);
    }

    public long incrementIndex(long currentPosition, ByteBuffer[] buffers) {
        int bufferIndex = this.bufferIndex(currentPosition);
        int nextIndex = (bufferIndex + 1) % buffers.length;
        long nextGenId = 0 == nextIndex ? this.bufferGenId(currentPosition) + 1L : this.bufferGenId(currentPosition);
        return this.encode(nextGenId, nextIndex, 0);
    }

    public long incrementOffset(long currentPosition, int increment, ByteBuffer[] buffers) {
        return this.incrementOffset(currentPosition, increment, buffers, false, false);
    }

    public long incrementOffset(long currentPosition, int increment, ByteBuffer[] buffers, boolean noLimit) {
        return this.incrementOffset(currentPosition, increment, buffers, false, noLimit);
    }

    private long incrementOffset(long currentPosition, int increment, ByteBuffer[] buffers, boolean okToRegress, boolean noLimit) {
        int proposedOffset;
        int offset = this.bufferOffset(currentPosition);
        int bufferIndex = this.bufferIndex(currentPosition);
        int currentBufferLimit = buffers[bufferIndex].limit();
        int currentBufferCapacity = buffers[bufferIndex].capacity();
        if (noLimit) {
            currentBufferLimit = currentBufferCapacity;
        }
        if ((proposedOffset = offset + increment) < currentBufferLimit) {
            return currentPosition + (long)increment;
        }
        if (proposedOffset == currentBufferLimit) {
            return this.incrementIndex(currentPosition, buffers);
        }
        if (okToRegress) {
            return this.incrementIndex(currentPosition, buffers);
        }
        LOG.error((Object)("proposedOffset " + proposedOffset + " is greater than " + currentBufferLimit + " capacity = " + currentBufferCapacity));
        LOG.error((Object)("currentPosition = " + this.toString(currentPosition) + " increment = " + increment));
        throw new DatabusRuntimeException("Error in _bufferOffset");
    }

    public long sanitize(long currentPosition, ByteBuffer[] buffers) {
        return this.incrementOffset(currentPosition, 0, buffers, false, false);
    }

    public long sanitize(long currentPosition, ByteBuffer[] buffers, boolean okToRegress) {
        return this.incrementOffset(currentPosition, 0, buffers, okToRegress, false);
    }

    public String toString(long position) {
        return this.toString(position, null);
    }

    public String toString(long position, ByteBuffer[] buffers) {
        if (position < 0L) {
            return "[" + position + "]";
        }
        int index = this.bufferIndex(position);
        StringBuilder sb = new StringBuilder();
        sb.append(position).append(":[GenId=").append(this.bufferGenId(position)).append(";Index=").append(index);
        if (buffers != null && index >= 0 && index < buffers.length) {
            sb.append("(lim=").append(buffers[index].limit()).append(",cap=").append(buffers[index].capacity()).append(")");
        }
        sb.append(";Offset=").append(this.bufferOffset(position)).append("]");
        if (buffers != null && (index < 0 || index >= buffers.length)) {
            throw new DatabusRuntimeException("invalid position index: " + sb.toString());
        }
        return sb.toString();
    }

    public String toString() {
        return "BufferPositionParser [_offsetMask=" + this._offsetMask + ", _indexMask=" + this._indexMask + ", _genIdMask=" + this._genIdMask + ", _offsetShift=" + this._offsetShift + ", _indexShift=" + this._indexShift + ", _genIdShift=" + this._genIdShift + ", _totalBufferSize=" + this._totalBufferSize + "]";
    }

    public void assertSpan(long start, long end, boolean isDebugEnabled) {
        long diff = end - start;
        double maxSpan = Math.pow(2.0, this._genIdShift);
        StringBuilder msg = null;
        if (diff < 0L || (double)diff > maxSpan || isDebugEnabled) {
            msg = new StringBuilder();
            msg.append("Assert Span: Start is: " + this.toString(start) + ", End: " + this.toString(end));
            msg.append(", Diff: " + diff + ", MaxSpan: " + maxSpan + ", totalBufferSize: " + this._totalBufferSize);
            if (diff < 0L || (double)diff > maxSpan) {
                LOG.fatal((Object)("Span Assertion failed: " + msg.toString()));
                throw new RuntimeException(msg.toString());
            }
            LOG.debug((Object)msg.toString());
        }
    }
}

