/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import com.linkedin.databus.core.util.BufferPositionParser;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class BufferPosition {
    public static final String MODULE = BufferPosition.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private volatile long _address;
    private final BufferPositionParser _parser;
    private final ByteBuffer[] _buffers;

    public boolean init() {
        return this._parser.init(this._address);
    }

    public void copy(BufferPosition rhs) {
        this._address = rhs.getPosition();
    }

    public long getRealPosition() {
        return this._parser.address(this._address);
    }

    public int bufferIndex() {
        return this._parser.bufferIndex(this._address);
    }

    public int bufferOffset() {
        return this._parser.bufferOffset(this._address);
    }

    public long bufferGenId() {
        return 0L <= this._address ? this._parser.bufferGenId(this._address) : 0L;
    }

    public void setPosition(long address) {
        this._address = address;
    }

    public void setPosition(long genId, int index, int offset) {
        this._address = this._parser.encode(genId, index, offset);
    }

    public long getPosition() {
        return this._address;
    }

    public BufferPosition(BufferPositionParser parser, ByteBuffer[] buffers) {
        this._parser = parser;
        this._buffers = buffers;
    }

    public BufferPosition(long pos, BufferPositionParser parser, ByteBuffer[] buffers) {
        this._parser = parser;
        this._buffers = buffers;
        this.setPosition(pos);
    }

    public String toString() {
        return this._parser.toString(this._address, this._buffers);
    }

    public long incrementGenId() {
        this._address = this._parser.incrementGenId(this._address);
        return this._address;
    }

    public long incrementIndex() {
        this._address = this._parser.incrementIndex(this._address, this._buffers);
        return this._address;
    }

    public long incrementOffset(int increment) {
        this._address = this._parser.incrementOffset(this._address, increment, this._buffers);
        return this._address;
    }

    public long sanitize() {
        this._address = this._parser.sanitize(this._address, this._buffers);
        return this._address;
    }

    public long sanitize(boolean okToRegress) {
        this._address = this._parser.sanitize(this._address, this._buffers, okToRegress);
        return this._address;
    }

    public int hashCode() {
        return (int)this._address;
    }

    public boolean equals(Object obj) {
        return obj instanceof BufferPosition && this._address == ((BufferPosition)obj).getPosition();
    }

    public boolean equals(BufferPosition position) {
        return this._address == position.getPosition();
    }

    public boolean equalsIgnoreGenId(BufferPosition position) {
        return this.getRealPosition() == position.getRealPosition();
    }

    public void skipOverFreeSpace() {
        ByteBuffer curBuf = this._buffers[this.bufferIndex()];
        for (int iterNum = 0; iterNum < this._buffers.length && this.bufferOffset() >= curBuf.limit(); ++iterNum) {
            this.incrementIndex();
            curBuf = this._buffers[this.bufferIndex()];
        }
    }
}

