/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.test;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventInfo;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.DbusEventV1Factory;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus.core.KeyTypeNotImplementedException;
import com.linkedin.databus.core.test.DbusEventFactoryForTesting;
import com.linkedin.databus.core.util.RngUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Vector;

public class DbusEventGenerator {
    private final long _startScn;
    private final DbusEventFactory _eventFactory;
    private Vector<Short> _srcIdList = null;

    public DbusEventGenerator() {
        this(0L, null);
    }

    public DbusEventGenerator(long startScn) {
        this(startScn, null);
    }

    public DbusEventGenerator(long startScn, Vector<Short> srcIdList) {
        this._startScn = startScn;
        this._srcIdList = srcIdList;
        this._eventFactory = new DbusEventV1Factory();
    }

    public long generateEvents(int numEvents, int windowSize, int maxEventSize, int payloadSize, boolean useLastEventAsScn, Vector<DbusEvent> eventVector) {
        long lastScn = 0L;
        try {
            long beginningOfTime = System.currentTimeMillis() / 1000L;
            beginningOfTime *= 1000L;
            short srcId = 1;
            for (int i = 0; i < numEvents; ++i) {
                if (this._srcIdList != null && this._srcIdList.size() > 0) {
                    int srcIdIndex = RngUtils.randomPositiveInt() % this._srcIdList.size();
                    srcId = this._srcIdList.get(srcIdIndex);
                } else {
                    srcId = RngUtils.randomPositiveShort();
                }
                if (srcId == 0) {
                    srcId = 1;
                }
                ByteBuffer buf = ByteBuffer.allocate(maxEventSize).order(this._eventFactory.getByteOrder());
                DbusEventInfo eventInfo = new DbusEventInfo(DbusOpcode.UPSERT, 0L, 0, RngUtils.randomPositiveShort(), (beginningOfTime - (long)((numEvents - i) * 1000)) * 1000L * 1000L, srcId, RngUtils.schemaMd5, RngUtils.randomString(payloadSize).getBytes(Charset.defaultCharset()), false, false);
                eventInfo.setEventSerializationVersion((byte)0);
                DbusEventFactory.serializeEvent(new DbusEventKey(RngUtils.randomLong()), buf, eventInfo);
                lastScn = useLastEventAsScn ? this._startScn + (long)(i / windowSize + 1) * (long)windowSize : this._startScn + (long)(i / windowSize) + 1L;
                eventVector.add(DbusEventFactoryForTesting.createReadOnlyDbusEventFromBuffer(buf, 0, lastScn, (byte)0));
            }
        }
        catch (KeyTypeNotImplementedException e) {
            // empty catch block
        }
        return lastScn;
    }

    public long generateEvents(int numEvents, int windowSize, int maxEventSize, int payloadSize, Vector<DbusEvent> eventVector) {
        return this.generateEvents(numEvents, windowSize, maxEventSize, payloadSize, false, eventVector);
    }
}

