/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.test;

import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventInternalWritable;
import com.linkedin.databus.core.DbusEventV1Factory;
import com.linkedin.databus.core.DbusEventV2Factory;
import com.linkedin.databus.core.UnsupportedDbusEventVersionRuntimeException;
import java.nio.ByteBuffer;

public class DbusEventFactoryForTesting {
    public static DbusEventInternalReadable createReadOnlyDbusEventFromBuffer(ByteBuffer buf, int position, long seq, byte version) {
        DbusEventFactory eventFactory;
        if (version == 0) {
            eventFactory = new DbusEventV1Factory();
        } else if (version == 2) {
            eventFactory = new DbusEventV2Factory();
        } else {
            throw new UnsupportedDbusEventVersionRuntimeException(version);
        }
        DbusEventInternalWritable event = eventFactory.createWritableDbusEventFromBuffer(buf, position);
        event.setSequence(seq);
        event.applyCrc();
        return event;
    }
}

