/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.test;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInternalWritable;
import com.linkedin.databus.core.DbusEventSerializable;
import com.linkedin.databus.core.DbusEventV1;
import com.linkedin.databus.core.DbusEventV2;
import com.linkedin.databus.core.InvalidEventException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class DbusEventCorrupter {
    private static final byte CORRUPTION_PATTERN = 85;

    public static DbusEventInternalWritable makeWritable(DbusEvent event) throws InvalidEventException {
        int pos;
        ByteBuffer buf;
        byte version = event.getRawBytes().get(0);
        try {
            Field reflectedBuf = DbusEventSerializable.class.getDeclaredField("_buf");
            Field reflectedPosition = DbusEventSerializable.class.getDeclaredField("_position");
            reflectedBuf.setAccessible(true);
            reflectedPosition.setAccessible(true);
            buf = (ByteBuffer)reflectedBuf.get(event);
            pos = reflectedPosition.getInt(event);
        }
        catch (Exception e) {
            throw new InvalidEventException(e);
        }
        return version == 0 ? new DbusEventV1(buf, pos) : new DbusEventV2(buf, pos);
    }

    public static void toggleEventCorruption(EventCorruptionType type, DbusEvent event) throws InvalidEventException {
        DbusEventInternalWritable writableEvent = DbusEventCorrupter.makeWritable(event);
        switch (type) {
            case LENGTH: {
                int newSize = writableEvent.size() ^ 0x55;
                writableEvent.setSize(newSize);
                break;
            }
            case HEADERCRC: {
                long headerCrc = writableEvent.headerCrc() ^ 0x55L;
                writableEvent.setHeaderCrc(headerCrc);
                break;
            }
            case PAYLOAD: {
                if (writableEvent.payloadLength() <= 0) break;
                byte[] payload = new byte[writableEvent.payloadLength()];
                writableEvent.value().get(payload);
                payload[0] = (byte)(payload[0] ^ 0x55);
                writableEvent.setValue(payload);
                break;
            }
            case PAYLOADCRC: {
                long payloadCrc = writableEvent.bodyCrc() ^ 0x55L;
                writableEvent.setValueCrc(payloadCrc);
            }
        }
    }

    public static enum EventCorruptionType {
        LENGTH,
        HEADERCRC,
        PAYLOAD,
        PAYLOADCRC,
        NONE;

    }
}

