/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.test;

import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.util.BufferPosition;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;

public class DbusEventBufferReflector {
    private final DbusEventBuffer _evb;
    private final BufferPosition _cwp;
    private final BufferPosition _tail;
    private final BufferPosition _head;
    private final ByteBuffer[] _buffers;
    private final DbusEventFactory _eventFactory;

    public DbusEventBufferReflector(DbusEventBuffer evb) throws NoSuchFieldException, IllegalAccessException {
        this._evb = evb;
        this._cwp = this.setBufferPositionField("_currentWritePosition");
        this._tail = this.setBufferPositionField("_tail");
        this._head = this.setBufferPositionField("_head");
        this._buffers = this.setBuffers();
        this._eventFactory = this.setEventFactory();
        this.validateStaticIdGenerator();
    }

    public DbusEventBuffer getDbusEventBuffer() {
        return this._evb;
    }

    private void validateStaticIdGenerator() throws NoSuchFieldException {
        Field field = DbusEventBuffer.class.getDeclaredField("_sessionIdGenerator");
        int modifier = field.getModifiers();
        if (!Modifier.isStatic(modifier)) {
            throw new RuntimeException("Session Id Generator in DbusEventBuffer must be static");
        }
    }

    public BufferPosition getCurrentWritePosition() {
        return this._cwp;
    }

    public BufferPosition getHead() {
        return this._head;
    }

    public BufferPosition getTail() {
        return this._tail;
    }

    public ByteBuffer getBuffer(int idx) {
        return this._buffers[idx].asReadOnlyBuffer();
    }

    public DbusEventFactory getEventFactory() {
        return this._eventFactory;
    }

    public boolean validateBuffer() {
        int cwpIndex = this._cwp.bufferIndex();
        if (this._head.bufferIndex() != cwpIndex && this._buffers[cwpIndex].capacity() != this._buffers[cwpIndex].limit()) {
            return false;
        }
        if (this._cwp.getPosition() < this._tail.getPosition()) {
            return false;
        }
        if (this._tail.getPosition() < this._head.getPosition()) {
            return false;
        }
        if (this._tail.getPosition() == this._head.getPosition() && !this._evb.empty()) {
            return false;
        }
        if (this._cwp.bufferGenId() - this._tail.bufferGenId() > 1L) {
            return false;
        }
        return this._tail.bufferGenId() - this._head.bufferGenId() <= 1L;
    }

    private ByteBuffer[] setBuffers() throws NoSuchFieldException, IllegalAccessException {
        Field field = DbusEventBuffer.class.getDeclaredField("_buffers");
        field.setAccessible(true);
        return (ByteBuffer[])field.get(this._evb);
    }

    private BufferPosition setBufferPositionField(String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = DbusEventBuffer.class.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (BufferPosition)field.get(this._evb);
    }

    private DbusEventFactory setEventFactory() throws NoSuchFieldException, IllegalAccessException {
        Field field = DbusEventBuffer.class.getDeclaredField("_eventFactory");
        field.setAccessible(true);
        return (DbusEventFactory)field.get(this._evb);
    }
}

