/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.test;

import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.InvalidEventException;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.util.EventBufferConsumer;
import java.nio.channels.ReadableByteChannel;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DbusEventBufferReader
implements Runnable {
    public static final Logger LOG = Logger.getLogger((String)DbusEventBufferReader.class.getName());
    private final ReadableByteChannel _channel;
    private final DbusEventBuffer _buffer;
    private boolean _stop;
    private long _eventsRead;
    private final Vector<EventBufferConsumer> _consumers;
    private final DbusEventsStatisticsCollector _stats;

    public DbusEventBufferReader(DbusEventBuffer buffer, ReadableByteChannel channel, Vector<EventBufferConsumer> consumers, DbusEventsStatisticsCollector stats) {
        this._buffer = buffer;
        this._channel = channel;
        this._stop = false;
        this._eventsRead = 0L;
        this._consumers = consumers;
        this._stats = stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._stop = false;
        try {
            do {
                int numEvents = 0;
                while ((numEvents = this._buffer.readEvents(this._channel, null, this._stats)) > 0) {
                    LOG.info((Object)("run():  readEvents() returned " + numEvents + " events written to client event buffer from channel"));
                    this._eventsRead += (long)numEvents;
                }
            } while (!this._stop);
        }
        catch (InvalidEventException e) {
            for (EventBufferConsumer cons : this._consumers) {
                cons.onInvalidEvent(this.eventsRead());
            }
            LOG.error((Object)("Invalid event! " + e));
            return;
        }
        finally {
            this._stop = false;
        }
    }

    public void stop() {
        this._stop = true;
    }

    public long eventsRead() {
        return this._eventsRead;
    }
}

