/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.monitoring.mbean;

import com.linkedin.databus.core.monitoring.StatsCollectorCallback;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectorMergeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StatsCollectors<T extends StatsCollectorMergeable<T>> {
    public static final long OLD_MERGE_THRESHOLD_MS = 10L;
    private final HashMap<String, T> _statsCollectors = new HashMap(16);
    private T _statsCollector;
    volatile long _lastMergeTstamp = 0L;
    private final Logger _log;
    private StatsCollectorCallback<T> _statsCallback;

    public StatsCollectors() {
        this(null);
    }

    public StatsCollectors(T statsCollector) {
        this._statsCollector = statsCollector;
        this._log = Logger.getLogger((String)(StatsCollectors.class.getName() + "-" + (null != statsCollector ? statsCollector.getClass().getSimpleName() : "unknown")));
    }

    public synchronized void addStatsCollector(String name, T coll) {
        this._log.info((Object)("adding stats collector: " + name + " -> " + coll));
        this._statsCollectors.put(name, coll);
        if (this._statsCallback != null) {
            this._statsCallback.addedStats(coll);
        }
    }

    public synchronized T getStatsCollector(String name) {
        return (T)((StatsCollectorMergeable)this._statsCollectors.get(name));
    }

    public T getStatsCollector() {
        if (System.currentTimeMillis() - this._lastMergeTstamp > 10L) {
            this.mergeStatsCollectors();
        }
        return this._statsCollector;
    }

    public synchronized T removeStatsCollector(String name) {
        this._log.info((Object)("removing stats collector: " + name));
        StatsCollectorMergeable c = (StatsCollectorMergeable)this._statsCollectors.remove(name);
        if (this._statsCallback != null) {
            this._statsCallback.removedStats(c);
        }
        return (T)c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getStatsCollectorKeys() {
        ArrayList<String> l = new ArrayList<String>();
        StatsCollectors statsCollectors = this;
        synchronized (statsCollectors) {
            Set<String> set = this._statsCollectors.keySet();
            for (String s : set) {
                l.add(s);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<T> getStatsCollectors() {
        ArrayList<T> l = new ArrayList<T>();
        StatsCollectors statsCollectors = this;
        synchronized (statsCollectors) {
            for (Map.Entry<String, T> entry : this._statsCollectors.entrySet()) {
                l.add(entry.getValue());
            }
        }
        return l;
    }

    public void mergeStatsCollectors() {
        if (this._statsCollector != null) {
            ArrayList<T> stats = this.getStatsCollectors();
            this._lastMergeTstamp = System.currentTimeMillis();
            if (stats != null) {
                this._statsCollector.resetAndMerge(stats);
            }
        }
    }

    public synchronized StatsCollectorCallback<T> getStatsCollectorCallback() {
        return this._statsCallback;
    }

    public synchronized void setStatsCollectorCallback(StatsCollectorCallback<T> c) {
        this._statsCallback = c;
        if (this._statsCallback != null) {
            for (Map.Entry<String, T> entry : this._statsCollectors.entrySet()) {
                this._statsCallback.addedStats(entry.getValue());
            }
        }
    }
}

