/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.monitoring.mbean;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.monitoring.events.DbusEventsTotalStatsEvent;
import com.linkedin.databus.core.monitoring.mbean.AbstractMonitoringMBean;
import com.linkedin.databus.core.monitoring.mbean.AggregatedDbusEventsTotalStats;
import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsTotalStatsMBean;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.log4j.Logger;

public class DbusEventsTotalStats
extends AbstractMonitoringMBean<DbusEventsTotalStatsEvent>
implements DbusEventsTotalStatsMBean {
    public static final String MODULE = DbusEventsTotalStats.class.getName();
    private final HashSet<Object> _peers;
    protected final String _dimension;
    private final Logger _log;

    public DbusEventsTotalStats(int ownerId, String dimension, boolean enabled, boolean threadSafe, DbusEventsTotalStatsEvent initData) {
        super(enabled, threadSafe, initData);
        this._dimension = AbstractMonitoringMBean.sanitizeString(dimension);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).ownerId = ownerId;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).dimension = this._dimension;
        this._peers = new HashSet(1000);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampCreated = System.currentTimeMillis();
        this._log = Logger.getLogger((String)(MODULE + "." + dimension));
        this.reset();
    }

    private void resetBufferStats() {
        ((DbusEventsTotalStatsEvent)((Object)this._event)).minWinScn = Long.MAX_VALUE;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxWinScn = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sinceWinScn = Long.MAX_VALUE;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numFreeBytes = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMinScnEvent = -1L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent = -1L;
    }

    public DbusEventsTotalStats clone(boolean threadSafe) {
        return new DbusEventsTotalStats(((DbusEventsTotalStatsEvent)((Object)this._event)).ownerId, this._dimension, this._enabled.get(), threadSafe, this.getStatistics(null));
    }

    public long getTimestampMaxScnEvent() {
        return ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumPeers() {
        Lock readLock = this.acquireReadLock();
        int result = 0;
        try {
            result = ((DbusEventsTotalStatsEvent)((Object)this._event)).numPeers;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumDataEvents() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEvents;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumDataEventsFiltered() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEventsFiltered;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeSinceLastResetMs() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = System.currentTimeMillis() - ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimestampLastResetMs() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxSeenWinScn() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxSeenWinScn;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxFilteredWinScn() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxFilteredWinScn;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinSeenWinScn() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).minSeenWinScn;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSizeDataEvents() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            long num = ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEvents;
            result = 0L == num ? 0L : ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEvents / num;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSizeDataEventsPayload() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            long num = ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEvents;
            result = 0L == num ? 0L : ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsPayload / num;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSizeDataEventsFiltered() {
        Lock readLock = this.acquireReadLock();
        try {
            long num = ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEventsFiltered;
            long l = 0L == num ? 0L : ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsFiltered / num;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSizeDataEventsPayloadFiltered() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsPayloadFiltered;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumSysEvents() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).numSysEvents;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSizeSysEvents() {
        Lock readLock = this.acquireReadLock();
        try {
            long num = ((DbusEventsTotalStatsEvent)((Object)this._event)).numSysEvents;
            long l = 0L == num ? 0L : ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeSysEvents / num;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataEvent(DbusEventInternalReadable e) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            long eventTsInMs = e.timestampInNanos() / 1000000L;
            long now = System.currentTimeMillis();
            ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent = Math.max(((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent, eventTsInMs);
            ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampAccessed = now;
            ((DbusEventsTotalStatsEvent)((Object)this._event)).latencyEvent = ((DbusEventsTotalStatsEvent)((Object)this._event)).latencyEvent + (((DbusEventsTotalStatsEvent)((Object)this._event)).timestampAccessed > eventTsInMs ? ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampAccessed - eventTsInMs : 0L);
            ++((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEvents;
            ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEvents += (long)e.size();
            ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsPayload += (long)e.payloadLength();
            if (e.sequence() > ((DbusEventsTotalStatsEvent)((Object)this._event)).maxSeenWinScn) {
                ((DbusEventsTotalStatsEvent)((Object)this._event)).maxSeenWinScn = e.sequence();
                ((DbusEventsTotalStatsEvent)((Object)this._event)).timeLag = now > eventTsInMs ? now - eventTsInMs : 0L;
            }
            ((DbusEventsTotalStatsEvent)((Object)this._event)).minSeenWinScn = this.minValue(((DbusEventsTotalStatsEvent)((Object)this._event)).minSeenWinScn, e.sequence());
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataEventFiltered(DbusEventInternalReadable e) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEventsFiltered;
            ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsFiltered += (long)e.size();
            ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsPayloadFiltered += (long)e.payloadLength();
            ((DbusEventsTotalStatsEvent)((Object)this._event)).maxFilteredWinScn = Math.max(((DbusEventsTotalStatsEvent)((Object)this._event)).maxFilteredWinScn, e.sequence());
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSysEvent(DbusEvent e) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusEventsTotalStatsEvent)((Object)this._event)).numSysEvents;
            ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeSysEvents += (long)e.size();
            long now = System.currentTimeMillis();
            if (e.isEndOfPeriodMarker()) {
                ((DbusEventsTotalStatsEvent)((Object)this._event)).minSeenWinScn = this.minValue(((DbusEventsTotalStatsEvent)((Object)this._event)).minSeenWinScn, e.sequence());
                long eventTsInMs = e.timestampInNanos() / 1000000L;
                ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent = Math.max(((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent, eventTsInMs);
                if (e.sequence() > ((DbusEventsTotalStatsEvent)((Object)this._event)).maxSeenWinScn) {
                    ((DbusEventsTotalStatsEvent)((Object)this._event)).maxSeenWinScn = e.sequence();
                    ((DbusEventsTotalStatsEvent)((Object)this._event)).timeLag = now > eventTsInMs ? now - eventTsInMs : 0L;
                }
            }
            ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampAccessed = now;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    @Override
    protected void resetData() {
        ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampLastResetMs = System.currentTimeMillis();
        ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampAccessed = -1L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).timeSinceLastResetMs = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numPeers = 0;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEvents = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEvents = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsPayload = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEventsFiltered = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsFiltered = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsPayloadFiltered = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxSeenWinScn = -1L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).minSeenWinScn = -1L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numSysEvents = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeSysEvents = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numErrHeader = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numErrPayload = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numInvalidEvents = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxFilteredWinScn = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).latencyEvent = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimeSpan = -1L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimeSpan = -1L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampAccessed = -1L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampAccessed = -1L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampMaxScnEvent = -1L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampMaxScnEvent = -1L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).timeLag = 0L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimeLag = -1L;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimeLag = -1L;
        this.resetBufferStats();
        this._peers.clear();
    }

    @Override
    public JsonEncoder createJsonEncoder(OutputStream out) throws IOException {
        return new JsonEncoder(((DbusEventsTotalStatsEvent)((Object)this._event)).getSchema(), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloneData(DbusEventsTotalStats otherEvent) {
        Lock writeLock = this.acquireWriteLock();
        try {
            otherEvent.cloneData((DbusEventsTotalStatsEvent)((Object)this._event));
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    @Override
    protected void cloneData(DbusEventsTotalStatsEvent event) {
        event.ownerId = ((DbusEventsTotalStatsEvent)((Object)this._event)).ownerId;
        event.dimension = ((DbusEventsTotalStatsEvent)((Object)this._event)).dimension;
        event.timestampLastResetMs = ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
        event.timeSinceLastResetMs = System.currentTimeMillis() - ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
        event.numPeers = ((DbusEventsTotalStatsEvent)((Object)this._event)).numPeers;
        event.numDataEvents = ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEvents;
        event.sizeDataEvents = ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEvents;
        event.sizeDataEventsPayload = ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsPayload;
        event.numDataEventsFiltered = ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEventsFiltered;
        event.sizeDataEventsFiltered = ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsFiltered;
        event.sizeDataEventsPayloadFiltered = ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsPayloadFiltered;
        event.maxSeenWinScn = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxSeenWinScn;
        event.minSeenWinScn = ((DbusEventsTotalStatsEvent)((Object)this._event)).minSeenWinScn;
        event.numSysEvents = ((DbusEventsTotalStatsEvent)((Object)this._event)).numSysEvents;
        event.sizeSysEvents = ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeSysEvents;
        event.minWinScn = ((DbusEventsTotalStatsEvent)((Object)this._event)).minWinScn;
        event.maxWinScn = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxWinScn;
        event.numErrHeader = ((DbusEventsTotalStatsEvent)((Object)this._event)).numErrHeader;
        event.numInvalidEvents = ((DbusEventsTotalStatsEvent)((Object)this._event)).numInvalidEvents;
        event.numErrPayload = ((DbusEventsTotalStatsEvent)((Object)this._event)).numErrPayload;
        event.timestampCreated = ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampCreated;
        event.timestampAccessed = ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampAccessed;
        event.sinceWinScn = ((DbusEventsTotalStatsEvent)((Object)this._event)).sinceWinScn;
        event.timestampMaxScnEvent = ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent;
        event.timestampMinScnEvent = ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMinScnEvent;
        event.maxFilteredWinScn = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxFilteredWinScn;
        event.latencyEvent = ((DbusEventsTotalStatsEvent)((Object)this._event)).latencyEvent;
        event.timeLag = ((DbusEventsTotalStatsEvent)((Object)this._event)).timeLag;
        event.minTimeLag = ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimeLag;
        event.maxTimeLag = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimeLag;
        event.maxTimeSpan = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimeSpan;
        event.minTimeSpan = ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimeSpan;
        event.maxTimestampAccessed = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampAccessed;
        event.minTimestampAccessed = ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampAccessed;
        event.maxTimestampMaxScnEvent = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampMaxScnEvent;
        event.minTimestampMaxScnEvent = ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampMaxScnEvent;
    }

    @Override
    protected DbusEventsTotalStatsEvent newDataEvent() {
        return new DbusEventsTotalStatsEvent();
    }

    @Override
    protected SpecificDatumWriter<DbusEventsTotalStatsEvent> getAvroWriter() {
        return new SpecificDatumWriter(DbusEventsTotalStatsEvent.class);
    }

    @Override
    public void mergeStats(DatabusMonitoringMBean<DbusEventsTotalStatsEvent> other) {
        if (!(this instanceof AggregatedDbusEventsTotalStats)) {
            this._log.error((Object)"Can use mergeStats only on AggregatedDbusEventsTotalStats");
            throw new RuntimeException("Can use mergeStats only on AggregatedDbusEventsTotalStats");
        }
        super.mergeStats(other);
        if (other instanceof DbusEventsTotalStats) {
            this.mergeClients((DbusEventsTotalStats)other);
        }
    }

    @Override
    protected void doMergeStats(Object eventData) {
        this._log.error((Object)"Merging statistics into DbusEventsTotalStats not supported. Use AggregatedDbusEventsTotalStats");
        throw new RuntimeException("Merging statistics into DbusEventsTotalStats not supported. Use AggregatedDbusEventsTotalStats");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeClients(DbusEventsTotalStats other) {
        Lock otherReadLock = other.acquireReadLock();
        Lock writeLock = this.acquireWriteLock(otherReadLock);
        try {
            this._peers.addAll(other._peers);
            ((DbusEventsTotalStatsEvent)((Object)this._event)).numPeers = this._peers.size();
        }
        finally {
            this.releaseLock(writeLock);
            this.releaseLock(otherReadLock);
        }
    }

    @Override
    public ObjectName generateObjectName() throws MalformedObjectNameException {
        Hashtable<String, String> mbeanProps = this.generateBaseMBeanProps();
        mbeanProps.put("ownerId", Integer.toString(((DbusEventsTotalStatsEvent)((Object)this._event)).ownerId));
        mbeanProps.put("dimension", this._dimension);
        return new ObjectName("com.linkedin.databus2", mbeanProps);
    }

    public String getDimension() {
        return this._dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPeer(String peerId) {
        Lock writeLock = this.acquireWriteLock();
        try {
            this._peers.add(peerId);
            ((DbusEventsTotalStatsEvent)((Object)this._event)).numPeers = this._peers.size();
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerEventError(DbusEventInternalReadable.EventScanStatus writingEventStatus) {
        if (writingEventStatus == DbusEventInternalReadable.EventScanStatus.OK) return;
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusEventsTotalStatsEvent)((Object)this._event)).numInvalidEvents;
            switch (writingEventStatus) {
                case PARTIAL: {
                    ++((DbusEventsTotalStatsEvent)((Object)this._event)).numErrHeader;
                    return;
                }
                case ERR: {
                    ++((DbusEventsTotalStatsEvent)((Object)this._event)).numErrPayload;
                    return;
                }
            }
            return;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerScnRange(long min, long max) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ((DbusEventsTotalStatsEvent)((Object)this._event)).minWinScn = min;
            ((DbusEventsTotalStatsEvent)((Object)this._event)).maxWinScn = max;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumInvalidEvents() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).numInvalidEvents;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumHeaderErrEvents() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).numErrHeader;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumPayloadErrEvents() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).numErrPayload;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinScn() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).minWinScn;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxScn() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxWinScn;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeSinceLastAccess() {
        Lock readLock = this.acquireReadLock();
        try {
            if (((DbusEventsTotalStatsEvent)((Object)this._event)).timestampAccessed <= 0L) {
                long l = -1L;
                return l;
            }
            long l = System.currentTimeMillis() - ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampAccessed;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeSinceCreation() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = System.currentTimeMillis() - ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampCreated;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCreationTime(long s) {
        Lock writeLock = this.acquireWriteLock();
        try {
            ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampCreated = s;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFreeSpace() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).numFreeBytes;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBufferMetrics(long min, long max, long since, long freeSpace) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ((DbusEventsTotalStatsEvent)((Object)this._event)).minWinScn = min;
            ((DbusEventsTotalStatsEvent)((Object)this._event)).maxWinScn = max;
            ((DbusEventsTotalStatsEvent)((Object)this._event)).sinceWinScn = since;
            ((DbusEventsTotalStatsEvent)((Object)this._event)).numFreeBytes = freeSpace;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTimestampOfFirstEvent(long ts) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMinScnEvent = ts;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    @Override
    public long getPrevScn() {
        return ((DbusEventsTotalStatsEvent)((Object)this._event)).sinceWinScn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeLag() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).timeLag;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    @Override
    public long getMinTimeLag() {
        return this.getTimeLag();
    }

    @Override
    public long getMaxTimeLag() {
        return this.getTimeLag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeSpan() {
        Lock readLock = this.acquireReadLock();
        try {
            if (((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent <= 0L || ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMinScnEvent <= 0L) {
                long l = -1L;
                return l;
            }
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent - ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMinScnEvent;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeSinceLastEvent() {
        Lock readLock = this.acquireReadLock();
        try {
            if (((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent <= 0L) {
                long l = -1L;
                return l;
            }
            long l = System.currentTimeMillis() - ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    public long getTimestampMinScnEvent() {
        return ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMinScnEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyEvent() {
        Lock readLock = this.acquireReadLock();
        try {
            long num = ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEvents;
            long l = num == 0L ? 0L : ((DbusEventsTotalStatsEvent)((Object)this._event)).latencyEvent / num;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    @Override
    public long getMinTimeSinceLastAccess() {
        return 0L;
    }

    @Override
    public long getMaxTimeSinceLastAccess() {
        return 0L;
    }

    @Override
    public long getMinTimeSinceLastEvent() {
        return 0L;
    }

    @Override
    public long getMaxTimeSinceLastEvent() {
        return 0L;
    }

    @Override
    public long getMinTimeSpan() {
        return 0L;
    }

    @Override
    public long getMaxTimeSpan() {
        return 0L;
    }
}

