/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.monitoring.mbean;

import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventUtils;
import com.linkedin.databus.core.monitoring.events.DbusEventsTotalStatsEvent;
import com.linkedin.databus.core.monitoring.mbean.AbstractMonitoringMBean;
import com.linkedin.databus.core.monitoring.mbean.AggregatedDbusEventsTotalStats;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollectorMBean;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsTotalStats;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectorMergeable;
import com.linkedin.databus.core.util.ConfigApplier;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus.core.util.JmxUtil;
import com.linkedin.databus.core.util.ReadWriteSyncedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class DbusEventsStatisticsCollector
extends ReadWriteSyncedObject
implements DbusEventsStatisticsCollectorMBean,
StatsCollectorMergeable<DbusEventsStatisticsCollector> {
    public static final String MODULE = DbusEventsStatisticsCollector.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String NO_PEER = "none";
    private final DbusEventsTotalStats _totalStats;
    private final HashMap<Integer, DbusEventsTotalStats> _perSourceStats;
    private final HashMap<String, DbusEventsTotalStats> _perPeerStats;
    private final MBeanServer _mbeanServer;
    private final ObjectName _collectorObjName;
    private final int _id;
    private final String _name;
    private final String _sanitizedName;
    private final String _curPeer;
    private final String _perSourceNamePrefix;
    private final String _perPeerNamePrefix;
    private final AtomicBoolean _enabled;
    private Integer _lastUsedSrcIdx = 1;

    public DbusEventsStatisticsCollector(int relayId, String name, boolean enabled, boolean threadSafe, MBeanServer mbeanServer) {
        this(relayId, name, enabled, threadSafe, NO_PEER, mbeanServer);
    }

    protected DbusEventsTotalStats makeDbusEventsTotalStats(int ownerId, String dimension, boolean enabled, boolean threadSafe, DbusEventsTotalStatsEvent initData) {
        return new DbusEventsTotalStats(ownerId, dimension, enabled, threadSafe, initData);
    }

    private DbusEventsStatisticsCollector(int relayId, String name, boolean enabled, boolean threadSafe, String client, MBeanServer mbeanServer) {
        super(threadSafe);
        this._id = relayId;
        this._name = name;
        this._sanitizedName = AbstractMonitoringMBean.sanitizeString(this._name);
        this._mbeanServer = mbeanServer;
        this._curPeer = client;
        this._enabled = new AtomicBoolean(enabled);
        this._perSourceNamePrefix = this._sanitizedName + ".source.";
        this._perPeerNamePrefix = this._sanitizedName + ".peer.";
        this._totalStats = this.makeDbusEventsTotalStats(this._id, this._sanitizedName + ".total", enabled, false, null);
        this._perSourceStats = new HashMap(100);
        this._perPeerStats = new HashMap(1000);
        ObjectName jmxName = null;
        try {
            Hashtable<String, String> mbeanProps = new Hashtable<String, String>(5);
            mbeanProps.put("name", this._sanitizedName);
            mbeanProps.put("type", DbusEventsStatisticsCollector.class.getSimpleName());
            mbeanProps.put("relay", Integer.toString(relayId));
            jmxName = new ObjectName("com.linkedin.databus2", mbeanProps);
        }
        catch (Exception e) {
            LOG.error((Object)"Error creating JMX object name", (Throwable)e);
        }
        this._collectorObjName = jmxName;
        this.registerAsMBeans();
    }

    protected void registerAsMBeans() {
        if (null != this._mbeanServer && null != this._collectorObjName) {
            try {
                if (this._mbeanServer.isRegistered(this._collectorObjName)) {
                    LOG.warn((Object)("unregistering stale mbean: " + this._collectorObjName));
                    this._mbeanServer.unregisterMBean(this._collectorObjName);
                }
                this._mbeanServer.registerMBean(this, this._collectorObjName);
                this._totalStats.registerAsMbean(this._mbeanServer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean registered " + this._collectorObjName));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"JMX registration failed", (Throwable)e);
            }
        }
    }

    public void unregisterMBeans() {
        if (null != this._mbeanServer && null != this._collectorObjName) {
            try {
                JmxUtil.unregisterMBeanSafely(this._mbeanServer, this._collectorObjName, LOG);
                this._totalStats.unregisterMbean(this._mbeanServer);
                for (String clientName : this._perPeerStats.keySet()) {
                    this._perPeerStats.get(clientName).unregisterMbean(this._mbeanServer);
                }
                for (Integer srcId : this._perSourceStats.keySet()) {
                    this._perSourceStats.get(srcId).unregisterMbean(this._mbeanServer);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean unregistered " + this._collectorObjName));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"JMX deregistration failed", (Throwable)e);
            }
        }
    }

    public DbusEventsStatisticsCollector createForPeerConnection(String client) {
        return new DbusEventsStatisticsCollector(this._id, client, true, false, client, null);
    }

    @Override
    public DbusEventsTotalStats getTotalStats() {
        return this._totalStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getSources() {
        Lock readLock = this.acquireReadLock();
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this._perSourceStats.keySet());
            return arrayList;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbusEventsTotalStats getSourceStats(int srcId) {
        Lock readLock = this.acquireReadLock();
        try {
            DbusEventsTotalStats result;
            if (srcId != this._lastUsedSrcIdx) {
                this._lastUsedSrcIdx = srcId;
            }
            DbusEventsTotalStats dbusEventsTotalStats = result = this._perSourceStats.get(this._lastUsedSrcIdx);
            return dbusEventsTotalStats;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getPeers() {
        Lock readLock = this.acquireReadLock();
        try {
            ArrayList<String> result;
            ArrayList<String> arrayList = result = new ArrayList<String>(this._perPeerStats.keySet());
            return arrayList;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbusEventsTotalStats getPeerStats(String peer) {
        Lock readLock = this.acquireReadLock();
        try {
            DbusEventsTotalStats result;
            DbusEventsTotalStats dbusEventsTotalStats = result = this._perPeerStats.get(peer);
            return dbusEventsTotalStats;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    public void registerDataEvent(DbusEventInternalReadable e) {
        if (!this._enabled.get()) {
            return;
        }
        short srcId = e.srcId();
        if (!DbusEventUtils.isControlSrcId(srcId)) {
            this._totalStats.registerDataEvent(e);
            DbusEventsTotalStats data = this.getOrAddPerSourceCollector(srcId, null);
            data.registerDataEvent(e);
        } else {
            this._totalStats.registerSysEvent(e);
        }
        if (NO_PEER != this._curPeer) {
            DbusEventsTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, null);
            if (!DbusEventUtils.isControlSrcId(srcId)) {
                clientStats.registerDataEvent(e);
            } else {
                clientStats.registerSysEvent(e);
            }
        }
    }

    public void registerDataEventFiltered(DbusEventInternalReadable e) {
        if (!this._enabled.get()) {
            return;
        }
        short srcId = e.srcId();
        if (!DbusEventUtils.isControlSrcId(srcId)) {
            this._totalStats.registerDataEventFiltered(e);
            DbusEventsTotalStats data = this.getOrAddPerSourceCollector(srcId, null);
            data.registerDataEventFiltered(e);
            if (NO_PEER != this._curPeer) {
                DbusEventsTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, null);
                clientStats.registerDataEventFiltered(e);
            }
        }
    }

    @Override
    public void merge(DbusEventsStatisticsCollector other) {
        this._totalStats.mergeStats(other._totalStats);
        this.mergeInternalStats(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeInternalStats(DbusEventsStatisticsCollector other) {
        Lock otherReadLock = other.acquireReadLock();
        Lock writeLock = this.acquireWriteLock(otherReadLock);
        try {
            for (Map.Entry<Integer, DbusEventsTotalStats> entry : other._perSourceStats.entrySet()) {
                this.mergePerSource(entry.getKey(), entry.getValue(), writeLock);
            }
            for (Map.Entry<Object, DbusEventsTotalStats> entry : other._perPeerStats.entrySet()) {
                this.mergePerPeer((String)entry.getKey(), entry.getValue(), writeLock);
            }
        }
        catch (RuntimeException r) {
            LOG.error((Object)"Received an error during merging internal stats", (Throwable)r);
        }
        finally {
            this.releaseLock(writeLock);
            this.releaseLock(otherReadLock);
        }
    }

    @Override
    public void reset() {
        this._totalStats.reset();
        this.resetInternalStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetInternalStats() {
        Lock writeLock = this.acquireWriteLock();
        try {
            for (Map.Entry<Integer, DbusEventsTotalStats> entry : this._perSourceStats.entrySet()) {
                entry.getValue().reset();
            }
            for (Map.Entry<Object, DbusEventsTotalStats> entry : this._perPeerStats.entrySet()) {
                entry.getValue().reset();
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAndMerge(List<DbusEventsStatisticsCollector> objList) {
        DbusEventsTotalStats t = this._totalStats.clone(true);
        t.reset();
        for (DbusEventsStatisticsCollector o : objList) {
            t.mergeStats(o.getTotalStats());
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            this._totalStats.cloneData(t);
            this.resetInternalStats();
            for (DbusEventsStatisticsCollector o : objList) {
                this.mergeInternalStats(o);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled.get();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled.set(enabled);
    }

    public String getSanitizedName() {
        return this._sanitizedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbusEventsTotalStats getOrAddPerSourceCollector(int srcId, Lock writeLock) {
        Lock myWriteLock = null;
        if (null == writeLock) {
            myWriteLock = this.acquireWriteLock();
        }
        try {
            DbusEventsTotalStats data;
            if (srcId != this._lastUsedSrcIdx) {
                this._lastUsedSrcIdx = srcId;
            }
            if (null == (data = this._perSourceStats.get(this._lastUsedSrcIdx))) {
                data = new AggregatedDbusEventsTotalStats(this._id, this._perSourceNamePrefix + srcId, true, this.isThreadSafe(), null);
                this._perSourceStats.put(this._lastUsedSrcIdx, data);
                if (null != this._mbeanServer) {
                    data.registerAsMbean(this._mbeanServer);
                }
            }
            DbusEventsTotalStats dbusEventsTotalStats = data;
            return dbusEventsTotalStats;
        }
        finally {
            this.releaseLock(myWriteLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbusEventsTotalStats getOrAddPerPeerCollector(String peer, Lock writeLock) {
        Lock myWriteLock = null;
        if (null == writeLock) {
            myWriteLock = this.acquireWriteLock();
        }
        try {
            DbusEventsTotalStats peerStats = this._perPeerStats.get(peer);
            if (null == peerStats) {
                peerStats = new AggregatedDbusEventsTotalStats(this._id, this._perPeerNamePrefix + peer, true, this.isThreadSafe(), null);
                this._perPeerStats.put(peer, peerStats);
                if (null != this._mbeanServer) {
                    peerStats.registerAsMbean(this._mbeanServer);
                }
            }
            DbusEventsTotalStats dbusEventsTotalStats = peerStats;
            return dbusEventsTotalStats;
        }
        finally {
            this.releaseLock(myWriteLock);
        }
    }

    private void mergePerSource(Integer srcId, DbusEventsTotalStats other, Lock writeLock) {
        DbusEventsTotalStats curBean = this.getOrAddPerSourceCollector(srcId, writeLock);
        curBean.mergeStats(other);
    }

    private void mergePerPeer(String peerName, DbusEventsTotalStats other, Lock writeLock) {
        DbusEventsTotalStats curBean = this.getOrAddPerPeerCollector(peerName, writeLock);
        curBean.mergeStats(other);
    }

    public String getName() {
        return this._name;
    }

    public void registerEventError(DbusEventInternalReadable.EventScanStatus writingEventStatus) {
        this._totalStats.registerEventError(writingEventStatus);
        if (NO_PEER != this._curPeer) {
            DbusEventsTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, null);
            clientStats.registerEventError(writingEventStatus);
        }
    }

    public void registerCreationTime(long s) {
        this._totalStats.registerCreationTime(s);
        if (NO_PEER != this._curPeer) {
            DbusEventsTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, null);
            clientStats.registerCreationTime(s);
        }
    }

    public void registerBufferMetrics(long r, long s, long since, long freeSpace) {
        this._totalStats.registerBufferMetrics(r, s, since, freeSpace);
    }

    public void registerTimestampOfFirstEvent(long ts) {
        this._totalStats.registerTimestampOfFirstEvent(ts);
    }

    public int getOwnerId() {
        return this._id;
    }

    public String toString() {
        return "DbusEventsStatisticsCollector [_totalStats=" + this._totalStats + ", _id=" + this._id + ", _name=" + this._name + ", _sanitizedName=" + this._sanitizedName + ", _enabled=" + this._enabled + "]";
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private final RuntimeConfigBuilder _runtime = new RuntimeConfigBuilder();

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        @Override
        public StaticConfig build() throws InvalidConfigException {
            return new StaticConfig(this._runtime);
        }
    }

    public static class StaticConfig {
        private final RuntimeConfigBuilder _runtime;

        public StaticConfig(RuntimeConfigBuilder runtime) {
            this._runtime = runtime;
        }

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }
    }

    public static class RuntimeConfigBuilder
    implements ConfigBuilder<RuntimeConfig> {
        private boolean _enabled = true;
        private DbusEventsStatisticsCollector _managedInstance = null;

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        @Override
        public RuntimeConfig build() throws InvalidConfigException {
            if (null != this._managedInstance) {
                DbusEventsStatisticsCollector dbusEventsStatisticsCollector = this._managedInstance;
                dbusEventsStatisticsCollector.getClass();
                return dbusEventsStatisticsCollector.new RuntimeConfig(this._enabled);
            }
            throw new InvalidConfigException("No ContainerStatisticsCollector instance assigned");
        }

        public DbusEventsStatisticsCollector getManagedInstance() {
            return this._managedInstance;
        }

        public void setManagedInstance(DbusEventsStatisticsCollector managedInstance) {
            this._managedInstance = managedInstance;
        }
    }

    public class RuntimeConfig
    implements ConfigApplier<RuntimeConfig> {
        private final boolean _enabled;

        public RuntimeConfig(boolean enabled) {
            this._enabled = enabled;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        @Override
        public void applyNewConfig(RuntimeConfig oldConfig) {
            DbusEventsStatisticsCollector.this.setEnabled(this.isEnabled());
        }

        public boolean equals(Object other) {
            if (null == other || !(other instanceof RuntimeConfig)) {
                return false;
            }
            return this.equalsConfig((RuntimeConfig)other);
        }

        public int hashCode() {
            return this._enabled ? 1 : 0;
        }

        @Override
        public boolean equalsConfig(RuntimeConfig otherConfig) {
            return this.isEnabled() == otherConfig.isEnabled();
        }
    }
}

