/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.monitoring.mbean;

import com.linkedin.databus.core.monitoring.events.DbusEventsTotalStatsEvent;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsTotalStats;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class AggregatedDbusEventsTotalStats
extends DbusEventsTotalStats {
    public static final String MODULE = AggregatedDbusEventsTotalStats.class.getName();
    private final Logger _log;

    public AggregatedDbusEventsTotalStats(int ownerId, String dimension, boolean enabled, boolean threadSafe, DbusEventsTotalStatsEvent initData) {
        super(ownerId, dimension, enabled, threadSafe, initData);
        this._log = Logger.getLogger((String)(MODULE + "." + dimension));
    }

    @Override
    public AggregatedDbusEventsTotalStats clone(boolean threadSafe) {
        AggregatedDbusEventsTotalStats s = new AggregatedDbusEventsTotalStats(((DbusEventsTotalStatsEvent)((Object)this._event)).ownerId, this._dimension, this._enabled.get(), threadSafe, null);
        this.cloneData((DbusEventsTotalStatsEvent)((Object)s._event));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinTimeSinceLastAccess() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampAccessed <= 0L ? -1L : System.currentTimeMillis() - ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampAccessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxTimeSinceLastAccess() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampAccessed <= 0L ? -1L : System.currentTimeMillis() - ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampAccessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinTimeSinceLastEvent() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampMaxScnEvent <= 0L ? -1L : System.currentTimeMillis() - ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampMaxScnEvent;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxTimeSinceLastEvent() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampMaxScnEvent <= 0L ? -1L : System.currentTimeMillis() - ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampMaxScnEvent;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinTimeSpan() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimeSpan;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxTimeSpan() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimeSpan;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinTimeLag() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimeLag;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxTimeLag() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimeLag;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    @Override
    protected void doMergeStats(Object eventData) {
        if (!(eventData instanceof DbusEventsTotalStatsEvent)) {
            this._log.warn((Object)("Attempt to merge unknown event class" + eventData.getClass().getName()));
            return;
        }
        DbusEventsTotalStatsEvent e = (DbusEventsTotalStatsEvent)((Object)eventData);
        if (((DbusEventsTotalStatsEvent)((Object)this._event)).ownerId > 0 && e.ownerId != ((DbusEventsTotalStatsEvent)((Object)this._event)).ownerId) {
            this._log.warn((Object)("Attempt to data for a different relay " + e.ownerId));
            return;
        }
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEvents += e.numDataEvents;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEvents += e.sizeDataEvents;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsPayload += e.sizeDataEventsPayload;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numDataEventsFiltered += e.numDataEventsFiltered;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsFiltered += e.sizeDataEventsFiltered;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeDataEventsPayloadFiltered += e.sizeDataEventsPayloadFiltered;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxSeenWinScn = this.maxValue(((DbusEventsTotalStatsEvent)((Object)this._event)).maxSeenWinScn, e.maxSeenWinScn);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).minSeenWinScn = this.minValue(((DbusEventsTotalStatsEvent)((Object)this._event)).minSeenWinScn, e.minSeenWinScn);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numSysEvents += e.numSysEvents;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sizeSysEvents += e.sizeSysEvents;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numErrHeader += e.numErrHeader;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numErrPayload += e.numErrPayload;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numInvalidEvents += e.numInvalidEvents;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampAccessed = Math.max(((DbusEventsTotalStatsEvent)((Object)this._event)).timestampAccessed, e.timestampAccessed);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampCreated = Math.min(((DbusEventsTotalStatsEvent)((Object)this._event)).timestampCreated, e.timestampCreated);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).sinceWinScn = e.sinceWinScn > 0L ? Math.min(((DbusEventsTotalStatsEvent)((Object)this._event)).sinceWinScn, e.sinceWinScn) : ((DbusEventsTotalStatsEvent)((Object)this._event)).sinceWinScn;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).minWinScn = e.minWinScn > 0L ? Math.min(((DbusEventsTotalStatsEvent)((Object)this._event)).minWinScn, e.minWinScn) : ((DbusEventsTotalStatsEvent)((Object)this._event)).minWinScn;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxWinScn = Math.max(((DbusEventsTotalStatsEvent)((Object)this._event)).maxWinScn, e.maxWinScn);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxFilteredWinScn = Math.max(((DbusEventsTotalStatsEvent)((Object)this._event)).maxFilteredWinScn, e.maxFilteredWinScn);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent = Math.max(((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMaxScnEvent, e.timestampMaxScnEvent);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMinScnEvent = e.timestampMinScnEvent > 0L ? Math.min(((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMinScnEvent, e.timestampMinScnEvent) : ((DbusEventsTotalStatsEvent)((Object)this._event)).timestampMinScnEvent;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).numFreeBytes = ((DbusEventsTotalStatsEvent)((Object)this._event)).numFreeBytes > 0L ? Math.min(((DbusEventsTotalStatsEvent)((Object)this._event)).numFreeBytes, e.numFreeBytes) : e.numFreeBytes;
        ((DbusEventsTotalStatsEvent)((Object)this._event)).latencyEvent += e.latencyEvent;
        if (e.timestampMaxScnEvent > 0L && e.timestampMinScnEvent > 0L) {
            long msecs = e.timestampMaxScnEvent - e.timestampMinScnEvent;
            ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimeSpan = this.minValue(msecs, ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimeSpan);
            ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimeSpan = this.maxValue(msecs, ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimeSpan);
        }
        ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampAccessed = this.minValue(e.timestampAccessed, ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampAccessed);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampAccessed = this.maxValue(e.timestampAccessed, ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampAccessed);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampMaxScnEvent = this.minValue(e.timestampMaxScnEvent, ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimestampMaxScnEvent);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampMaxScnEvent = this.maxValue(e.timestampMaxScnEvent, ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimestampMaxScnEvent);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimeLag = this.minValue(e.timeLag, ((DbusEventsTotalStatsEvent)((Object)this._event)).minTimeLag);
        ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimeLag = this.maxValue(e.timeLag, ((DbusEventsTotalStatsEvent)((Object)this._event)).maxTimeLag);
    }
}

