/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.monitoring.mbean;

import com.linkedin.databus.core.monitoring.StatsCollectorCallback;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectorMergeable;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectors;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;

public abstract class AbstractStatsCollectorsPartitioner<T extends StatsCollectorMergeable<T>> {
    private final Map<String, StatsCollectors<T>> _statCollectorsMap = new HashMap<String, StatsCollectors<T>>();
    private final MBeanServer _mbeanServer;
    private StatsCollectorCallback<StatsCollectors<T>> _statsCallback;
    private final int _ownerId;
    protected final String _mbeanNameSuffix;

    public AbstractStatsCollectorsPartitioner(int ownerId, String suffix, MBeanServer mbeanServer) {
        this._mbeanServer = mbeanServer;
        this._ownerId = ownerId;
        this._mbeanNameSuffix = suffix;
    }

    protected StatsCollectors<T> getBucketStatsCollector(String bucketName) {
        return this._statCollectorsMap.get(bucketName);
    }

    protected void addStatsCollector(String bucketKey, String key, T collector) {
        StatsCollectors<T> c = this._statCollectorsMap.get(bucketKey);
        if (null == c) {
            c = this.createStatsCollector(this._ownerId, bucketKey, this._mbeanServer);
            this._statCollectorsMap.put(bucketKey, c);
            this.notifyStatsAdd(c);
        }
        c.addStatsCollector(key, collector);
    }

    public void removeAllStatsCollector() {
        Iterator<Map.Entry<String, StatsCollectors<T>>> itr = this._statCollectorsMap.entrySet().iterator();
        while (itr.hasNext()) {
            StatsCollectors<T> c = itr.next().getValue();
            this.unregisterStatsCollector(c);
            this.notifyStatsRemove(c);
            itr.remove();
        }
    }

    private void notifyStatsAdd(StatsCollectors<T> collector) {
        if (null != this._statsCallback) {
            this._statsCallback.addedStats(collector);
        }
    }

    private void notifyStatsRemove(StatsCollectors<T> collector) {
        if (null != this._statsCallback) {
            this._statsCallback.removedStats(collector);
        }
    }

    public void registerStatsCallback(StatsCollectorCallback<StatsCollectors<T>> statsCallback) {
        this._statsCallback = statsCallback;
        for (Map.Entry<String, StatsCollectors<T>> e : this._statCollectorsMap.entrySet()) {
            this.notifyStatsAdd(e.getValue());
        }
    }

    protected abstract StatsCollectors<T> createStatsCollector(int var1, String var2, MBeanServer var3);

    protected abstract void unregisterStatsCollector(StatsCollectors<T> var1);
}

