/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.monitoring.mbean;

import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus.core.util.JmxUtil;
import com.linkedin.databus.core.util.ReadWriteSyncedObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.log4j.Logger;

public abstract class AbstractMonitoringMBean<T>
extends ReadWriteSyncedObject
implements DatabusMonitoringMBean<T> {
    public static final String MODULE = AbstractMonitoringMBean.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String JMX_DOMAIN = "com.linkedin.databus2";
    private static final Pattern BAD_CHARS_PATTERN = Pattern.compile("[:,?=]");
    public static final long DEFAULT_MAX_LONG_VALUE = -1L;
    public static final long DEFAULT_MIN_LONG_VALUE = -1L;
    protected final AtomicBoolean _enabled;
    protected T _event;
    protected final SpecificDatumWriter<T> _avroWriter;

    protected AbstractMonitoringMBean(boolean enabled, boolean threadSafe, T initEvent) {
        super(threadSafe);
        this._enabled = new AtomicBoolean(enabled);
        this._event = null == initEvent ? this.newDataEvent() : initEvent;
        this._avroWriter = this.getAvroWriter();
    }

    @Override
    public boolean isEnabled() {
        return this._enabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Lock writeLock = this.acquireWriteLock();
        try {
            this.resetData();
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled.set(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getStatistics(T reuse) {
        if (null == reuse) {
            reuse = this.newDataEvent();
        }
        Lock readLock = this.acquireReadLock();
        try {
            this.cloneData(reuse);
        }
        finally {
            this.releaseLock(readLock);
        }
        return reuse;
    }

    @Override
    public String toJson() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(10000);
        try {
            JsonEncoder jsonEncoder = this.createJsonEncoder(out);
            this.toJson(jsonEncoder, null);
        }
        catch (IOException ioe) {
            LOG.error((Object)"JSON serialization error", (Throwable)ioe);
            out.reset();
        }
        return out.toString();
    }

    @Override
    public T toJson(JsonEncoder jsonEncoder, T eventReuse) throws IOException {
        eventReuse = this.getStatistics(eventReuse);
        this._avroWriter.write(eventReuse, (Encoder)jsonEncoder);
        jsonEncoder.flush();
        return eventReuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeStats(DatabusMonitoringMBean<T> other) {
        if (!(other instanceof AbstractMonitoringMBean)) {
            return;
        }
        AbstractMonitoringMBean otherObj = (AbstractMonitoringMBean)other;
        if (!this._event.getClass().isInstance(otherObj._event)) {
            return;
        }
        T otherEvent = otherObj._event;
        Lock otherReadLock = otherObj.acquireReadLock();
        Lock thisWriteLock = null;
        try {
            thisWriteLock = this.acquireWriteLock(otherReadLock);
            this.doMergeStats(otherEvent);
        }
        finally {
            this.releaseLock(thisWriteLock);
            this.releaseLock(otherReadLock);
        }
    }

    public boolean registerAsMbean(MBeanServer mbeanServer) {
        boolean success = false;
        if (null != mbeanServer) {
            try {
                ObjectName objName = this.generateObjectName();
                if (mbeanServer.isRegistered(objName)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("unregistering old MBean: " + objName));
                    }
                    mbeanServer.unregisterMBean(objName);
                }
                mbeanServer.registerMBean(this, objName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean registered " + objName));
                }
                success = true;
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to register to mbean server", (Throwable)e);
            }
        }
        return success;
    }

    public boolean unregisterMbean(MBeanServer mbeanServer) {
        boolean success = false;
        if (null != mbeanServer) {
            try {
                ObjectName objName = this.generateObjectName();
                if (!this.isThreadSafe() && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The mbean " + objName.toString() + " is not thread-safe which is probably not a good idea."));
                }
                JmxUtil.unregisterMBeanSafely(mbeanServer, objName, LOG);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean unregistered " + objName));
                }
                success = true;
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to register to mbean server", (Throwable)e);
            }
        }
        return success;
    }

    public static String sanitizeString(String s) {
        return BAD_CHARS_PATTERN.matcher(s).replaceAll("_");
    }

    public abstract ObjectName generateObjectName() throws MalformedObjectNameException;

    protected abstract void resetData();

    protected abstract void cloneData(T var1);

    protected abstract T newDataEvent();

    protected abstract SpecificDatumWriter<T> getAvroWriter();

    protected abstract void doMergeStats(Object var1);

    protected Hashtable<String, String> generateBaseMBeanProps() {
        Hashtable<String, String> mbeanProps = new Hashtable<String, String>(5);
        mbeanProps.put("type", this.getClass().getSimpleName());
        return mbeanProps;
    }

    protected long maxValue(long val1, long val2) {
        if (val1 == -1L) {
            return val2;
        }
        if (val2 == -1L) {
            return val1;
        }
        return Math.max(val1, val2);
    }

    protected long minValue(long val1, long val2) {
        if (val1 == -1L) {
            return val2;
        }
        if (val2 == -1L) {
            return val1;
        }
        return Math.min(val1, val2);
    }

    public String toString() {
        return "AbstractMonitoringMBean [_event=" + this._event + "]";
    }
}

