/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.monitoring;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class HistogramBasedIntStats {
    public static final String MODULE = HistogramBasedIntStats.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final int[] _data;
    private final int[] _histogram;
    private final int[] _bucketValues;
    private final StaticConfig _staticConfig;
    private final int _bucketWidth;
    private final int _bucketRealMax;
    private int _dataStart;
    private int _dataSize;

    public HistogramBasedIntStats(StaticConfig staticConfig) {
        this._staticConfig = staticConfig;
        int bwidth = (staticConfig.getBucketsMax() - staticConfig.getBucketsMin()) / staticConfig.getBucketsNum();
        this._bucketWidth = 0 >= bwidth ? 1 : bwidth;
        this._bucketRealMax = staticConfig.getBucketsMin() + staticConfig.getBucketsNum() * this._bucketWidth;
        this._data = new int[staticConfig.getCapacity()];
        this._histogram = new int[staticConfig.getBucketsNum() + 2];
        this._bucketValues = new int[staticConfig.getBucketsNum() + 2];
        this._dataStart = -1;
        this._dataSize = 0;
        for (int i = 0; i <= this._staticConfig.getBucketsNum() + 1; ++i) {
            this._bucketValues[i] = this._staticConfig.getBucketsMin() + this._bucketWidth * (i - 1) + this._bucketWidth / 2;
        }
    }

    public void add(int v) {
        int vBucket;
        int capacity = this._staticConfig.getCapacity();
        if (-1 == this._dataStart) {
            this._dataStart = 0;
        } else if (this._dataSize == capacity) {
            for (int i = 0; i < this._staticConfig.getDropNum(); ++i) {
                int n = this._data[this._dataStart++];
                this._histogram[n] = this._histogram[n] - 1;
                this._dataStart %= capacity;
            }
            this._dataSize -= this._staticConfig.getDropNum();
        }
        int n = vBucket = this.getBucket(v);
        this._histogram[n] = this._histogram[n] + 1;
        this._data[(this._dataStart + this._dataSize++) % capacity] = vBucket;
    }

    public void clear() {
        this._dataSize = 0;
    }

    public int size() {
        return this._dataSize;
    }

    public void calcStats(Stats stats) {
        stats.clear();
        stats._num = this._dataSize;
        int totalCount = 0;
        long sumOfSq = 0L;
        for (int i = 0; i < this._staticConfig.getBucketsNum() + 2; ++i) {
            int count = this._histogram[i];
            totalCount += count;
            int curValue = this._bucketValues[i];
            stats._sum += curValue * count;
            sumOfSq += (long)(curValue * curValue * count);
            if (count <= 0) continue;
            if (curValue < stats._min) {
                stats._min = curValue;
            }
            if (curValue > stats._max) {
                stats._max = curValue;
            }
            if (Integer.MIN_VALUE == stats._median && totalCount >= this._dataSize / 2) {
                stats._median = curValue;
            }
            if (Integer.MIN_VALUE == stats._perc75 && (double)totalCount >= (double)this._dataSize * 0.75) {
                stats._perc75 = curValue;
            }
            if (Integer.MIN_VALUE == stats._perc90 && (double)totalCount >= (double)this._dataSize * 0.9) {
                stats._perc90 = curValue;
            }
            if (Integer.MIN_VALUE == stats._perc95 && (double)totalCount >= (double)this._dataSize * 0.95) {
                stats._perc95 = curValue;
            }
            if (Integer.MIN_VALUE != stats._perc99 || !((double)totalCount >= (double)this._dataSize * 0.99)) continue;
            stats._perc99 = curValue;
        }
        stats._mean = 0 != stats._num ? 1.0 * (double)stats._sum / (double)stats._num : 0.0;
        stats._stdDev = 1 >= this._dataSize ? 0.0 : Math.sqrt(((double)sumOfSq - 2.0 * stats._mean * (double)stats._sum + (double)this._dataSize * stats._mean * stats._mean) / ((double)this._dataSize - 1.0));
    }

    public int[] getHistogram() {
        return Arrays.copyOf(this._histogram, this._histogram.length);
    }

    public int[] getBucketValues() {
        return Arrays.copyOf(this._bucketValues, this._bucketValues.length);
    }

    private int getBucket(int v) {
        int bmin = this._staticConfig.getBucketsMin();
        if (v < bmin) {
            return 0;
        }
        if (v >= this._bucketRealMax) {
            return this._staticConfig.getBucketsNum() + 1;
        }
        return 1 + (v - bmin) / this._bucketWidth;
    }

    public void mergeDataFrom(HistogramBasedIntStats source, int dataPointsNum) {
        int[] otherData = source.getData();
        int realNum = Math.min(dataPointsNum, otherData.length);
        for (int i = 0; i < realNum; ++i) {
            this.add(otherData[i]);
        }
    }

    public void copyDataTo(HistogramBasedIntStats source) {
        if (this._staticConfig.getBucketsMin() != source.getStaticConfig().getBucketsMin() || this._staticConfig.getBucketsMax() != source.getStaticConfig().getBucketsMax() || this._staticConfig.getBucketsNum() != source.getStaticConfig().getBucketsNum() || this._staticConfig.getCapacity() != source.getStaticConfig().getCapacity()) {
            LOG.error((Object)"trying to merge a histogram with different configuration; ignoring");
            return;
        }
        source.copyDataAndHistogramTo(this);
    }

    public StaticConfig getStaticConfig() {
        return this._staticConfig;
    }

    protected int[] getData() {
        int[] dataCopy = new int[this._dataSize];
        return dataCopy;
    }

    protected void copyDataAndHistogramTo(HistogramBasedIntStats target) {
        System.arraycopy(this._data, 0, target._data, 0, this._data.length);
        System.arraycopy(this._histogram, 0, target._histogram, 0, this._histogram.length);
        target._dataSize = this._dataSize;
        target._dataStart = this._dataStart;
    }

    public static class StaticConfigBuilder
    implements ConfigBuilder<StaticConfig> {
        private int _capacity = 60000;
        private int _bucketsMin = 0;
        private int _bucketsMax = 100;
        private int _bucketsNum = 20;
        private int _dropNum = -1;

        public int getCapacity() {
            return this._capacity;
        }

        public void setCapacity(int capacity) {
            this._capacity = capacity;
        }

        public int getBucketsMin() {
            return this._bucketsMin;
        }

        public void setBucketsMin(int bucketsMin) {
            this._bucketsMin = bucketsMin;
        }

        public int getBucketsMax() {
            return this._bucketsMax;
        }

        public void setBucketsMax(int bucketsMax) {
            this._bucketsMax = bucketsMax;
        }

        public int getBucketsNum() {
            return this._bucketsNum;
        }

        public void setBucketsNum(int bucketsNum) {
            this._bucketsNum = bucketsNum;
        }

        public int getDropNum() {
            return this._dropNum;
        }

        public void setDropNum(int dropNum) {
            this._dropNum = dropNum;
        }

        @Override
        public StaticConfig build() throws InvalidConfigException {
            if (0 >= this._dropNum) {
                this._dropNum = Math.max((int)((double)this._capacity * 0.01), 1);
            }
            return new StaticConfig(this._capacity, this._bucketsMin, this._bucketsMax, this._bucketsNum, this._dropNum);
        }
    }

    public static class StaticConfig {
        private final int _capacity;
        private final int _bucketsMin;
        private final int _bucketsMax;
        private final int _bucketsNum;
        private final int _dropNum;

        public StaticConfig(int capacity, int bucketsMin, int bucketsMax, int bucketsNum, int dropNum) {
            this._capacity = capacity;
            this._bucketsMin = bucketsMin;
            this._bucketsMax = bucketsMax;
            this._bucketsNum = bucketsNum;
            this._dropNum = dropNum;
        }

        public int getCapacity() {
            return this._capacity;
        }

        public int getBucketsMin() {
            return this._bucketsMin;
        }

        public int getBucketsMax() {
            return this._bucketsMax;
        }

        public int getBucketsNum() {
            return this._bucketsNum;
        }

        public int getDropNum() {
            return this._dropNum;
        }
    }

    public static class Stats {
        private int _num;
        private int _max;
        private int _min;
        private int _sum;
        private int _median;
        private int _perc75;
        private int _perc90;
        private int _perc95;
        private int _perc99;
        private double _mean;
        private double _stdDev;

        public Stats() {
            this.clear();
        }

        public void clear() {
            this._max = Integer.MIN_VALUE;
            this._min = Integer.MAX_VALUE;
            this._mean = -2.147483648E9;
            this._median = Integer.MIN_VALUE;
            this._perc75 = Integer.MIN_VALUE;
            this._perc90 = Integer.MIN_VALUE;
            this._perc95 = Integer.MIN_VALUE;
            this._perc99 = Integer.MIN_VALUE;
            this._sum = 0;
            this._stdDev = 0.0;
            this._num = 0;
        }

        public int getNum() {
            return this._num;
        }

        public int getMax() {
            return this._max;
        }

        public int getMin() {
            return this._min;
        }

        public int getSum() {
            return this._sum;
        }

        public int getMedian() {
            return this._median;
        }

        public int getPerc75() {
            return this._perc75;
        }

        public int getPerc90() {
            return this._perc90;
        }

        public int getPerc95() {
            return this._perc95;
        }

        public int getPerc99() {
            return this._perc99;
        }

        public double getMean() {
            return this._mean;
        }

        public double getStdDev() {
            return this._stdDev;
        }
    }
}

