/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.data_model;

public class Role {
    public static final int UNKNOWN = 0;
    public static final int MASTER = 1;
    public static final int SLAVE = 2;
    public static final int OFFLINE = 3;
    public static final int ERROR = 4;
    public static final int ANY = 5;
    public static final String UNKNOWN_STR = "UNKNOWN";
    public static final String MASTER_STR = "MASTER";
    public static final String SLAVE_STR = "SLAVE";
    public static final String OFFLINE_STR = "OFFLINE";
    public static final String ERROR_STR = "ERROR";
    public static final String ANY_STR = "ANY";
    final int _roleVal;
    final String _role;

    public Role(int role) {
        this._roleVal = role;
        this._role = this.toString();
    }

    public Role(String roleStr) {
        this._roleVal = this.getRoleVal(roleStr);
        this._role = this.toString();
    }

    private int getRoleVal(String roleStr) {
        if (roleStr.equals(MASTER_STR)) {
            return 1;
        }
        if (roleStr.equals(SLAVE_STR)) {
            return 2;
        }
        if (roleStr.equals(OFFLINE_STR)) {
            return 3;
        }
        if (roleStr.equals(ERROR_STR)) {
            return 4;
        }
        if (roleStr.equals(ANY_STR)) {
            return 5;
        }
        return 0;
    }

    public String getRole() {
        return this._role;
    }

    private int getRoleVal() {
        return this._roleVal;
    }

    public boolean checkIfMaster() {
        return this._roleVal == 1;
    }

    public boolean checkIfSlave() {
        return this._roleVal == 2;
    }

    public boolean checkIfOffline() {
        return this._roleVal == 3;
    }

    public boolean checkIfAny() {
        return this._roleVal == 5;
    }

    public boolean checkIfError() {
        return this._roleVal == 4;
    }

    public boolean checkIfUnknown() {
        return this._roleVal == 0;
    }

    public int hashCode() {
        return this._roleVal;
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof Role)) {
            return false;
        }
        Role otherRole = (Role)other;
        if (this._roleVal == otherRole.getRoleVal()) {
            return true;
        }
        return this._roleVal == 5 || otherRole.getRoleVal() == 5;
    }

    public String toString() {
        if (this.getRoleVal() == 1) {
            return MASTER_STR;
        }
        if (this.getRoleVal() == 2) {
            return SLAVE_STR;
        }
        if (this.getRoleVal() == 3) {
            return OFFLINE_STR;
        }
        if (this.getRoleVal() == 5) {
            return ANY_STR;
        }
        if (this.getRoleVal() == 4) {
            return ERROR_STR;
        }
        return UNKNOWN_STR;
    }

    public static Role createUnknown() {
        Role r = new Role(0);
        return r;
    }
}

