/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.data_model;

import com.linkedin.databus.core.data_model.Role;
import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class PhysicalSource {
    private final String _uri;
    private final String _resourceKey;
    private final Role _role;
    public static final String PHYSICAL_SOURCE_MASTER = "MASTER";
    public static final String PHYSICAL_SOURCE_SLAVE = "SLAVE";
    public static final String PHYSICAL_SOURCE_ANY = "ANY";
    static final String ANY_PHISYCAL_SOURCE_URI = "databus:physical-source:ANY";
    static final String MASTER_PHISYCAL_SOURCE_URI = "databus:physical-source:MASTER";
    static final String SLAVE_PHISYCAL_SOURCE_URI = "databus:physical-source:SLAVE";
    public static final PhysicalSource ANY_PHISYCAL_SOURCE = new PhysicalSource("databus:physical-source:ANY", "ANY", "");
    public static final PhysicalSource MASTER_PHISYCAL_SOURCE = new PhysicalSource("databus:physical-source:MASTER", "MASTER", "");
    public static final PhysicalSource SLAVE_PHISYCAL_SOURCE = new PhysicalSource("databus:physical-source:SLAVE", "SLAVE", "");

    public PhysicalSource(String sourceUri) {
        this(sourceUri, PHYSICAL_SOURCE_MASTER, "");
    }

    public PhysicalSource(String sourceUri, String role, String resourceKey) {
        if (null == sourceUri) {
            throw new NullPointerException("physical source uri");
        }
        this._uri = sourceUri;
        this._role = new Role(role);
        this._resourceKey = resourceKey;
    }

    public static PhysicalSource createAnySourceWildcard() {
        return ANY_PHISYCAL_SOURCE;
    }

    public static PhysicalSource createMasterSourceWildcard() {
        return MASTER_PHISYCAL_SOURCE;
    }

    public static PhysicalSource createSlaveSourceWildcard() {
        return SLAVE_PHISYCAL_SOURCE;
    }

    public static PhysicalSource createFromJsonString(String json) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        Builder result = (Builder)mapper.readValue(json, Builder.class);
        return result.build();
    }

    public String getUri() {
        return this._uri;
    }

    public Role getRole() {
        return this._role;
    }

    public String getResourceKey() {
        return this._resourceKey;
    }

    public String toString() {
        return "uri=" + this._uri + ";role=" + this._role.toString() + ";rk=" + this._resourceKey;
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("{");
        sb.append("\"uri\":\"");
        sb.append(this._uri);
        sb.append("\",");
        sb.append("\"role\":\"");
        sb.append(this._role);
        sb.append("\"");
        sb.append("}");
        return sb.toString();
    }

    public boolean equalsSource(PhysicalSource other) {
        String otherUri;
        String thisUri = this._uri.replaceFirst(":ANY$", ":");
        return thisUri.equals(otherUri = other._uri.replaceFirst(":ANY$", ":")) && this._role.equals(other._role);
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof PhysicalSource)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.equalsSource((PhysicalSource)other);
    }

    public int hashCode() {
        return this._uri.hashCode() + this._role.hashCode() << 16;
    }

    public boolean isAnySourceWildcard() {
        return ANY_PHISYCAL_SOURCE.equals(this);
    }

    public boolean isMasterSourceWildcard() {
        return MASTER_PHISYCAL_SOURCE.equals(this);
    }

    public boolean isSlaveSourceWildcard() {
        return SLAVE_PHISYCAL_SOURCE.equals(this);
    }

    public boolean isWildcard() {
        return this.isAnySourceWildcard() || this.isMasterSourceWildcard() || this.isSlaveSourceWildcard();
    }

    public StringBuilder toSimpleString(StringBuilder sb) {
        if (null == sb) {
            sb = new StringBuilder(20);
        }
        sb.append("[");
        if (this.isAnySourceWildcard()) {
            sb.append(ANY_PHISYCAL_SOURCE);
        } else if (this.isMasterSourceWildcard()) {
            sb.append(MASTER_PHISYCAL_SOURCE);
        } else if (this.isSlaveSourceWildcard()) {
            sb.append(SLAVE_PHISYCAL_SOURCE);
        } else {
            sb.append("uri=").append(this._uri);
        }
        sb.append("]");
        return sb;
    }

    public String toSimpleString() {
        return this.toSimpleString(null).toString();
    }

    public static class Builder {
        private String _uri = "databus:physical-source:ANY";
        private String _role = "MASTER";
        private String _resourceKey = "";

        public String getUri() {
            return this._uri;
        }

        public void setUri(String uri) {
            this._uri = uri;
        }

        public String getRole() {
            return this._role;
        }

        public void setRole(String role) {
            this._role = role;
        }

        public String getResourceKey() {
            return this._resourceKey;
        }

        public void setResource(String rk) {
            this._resourceKey = rk;
        }

        public void makeAnySourceWildcard() {
            this._uri = PhysicalSource.ANY_PHISYCAL_SOURCE_URI;
        }

        public void makeMasterSourceWildcard() {
            this._uri = PhysicalSource.MASTER_PHISYCAL_SOURCE_URI;
        }

        public void makeSlaveSourceWildcard() {
            this._uri = PhysicalSource.SLAVE_PHISYCAL_SOURCE_URI;
        }

        public PhysicalSource build() {
            return new PhysicalSource(this._uri, this._role, this._resourceKey);
        }
    }
}

