/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.data_model;

import com.linkedin.databus.core.NamedObject;
import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class PhysicalPartition
implements NamedObject,
Comparable<PhysicalPartition> {
    private final Integer _id;
    private final String _name;
    private String _simpleStringCache;
    static final Integer ANY_PHYSICAL_PARTITION_ID = -1;
    static final String ANY_PHYSICAL_PARTITION_NAME = "*";
    public static final char DBNAME_PARTID_SEPARATOR = ':';
    public static final PhysicalPartition ANY_PHYSICAL_PARTITION = new PhysicalPartition(ANY_PHYSICAL_PARTITION_ID, "*");

    public PhysicalPartition() {
        this(ANY_PHYSICAL_PARTITION_ID, ANY_PHYSICAL_PARTITION_NAME);
    }

    public PhysicalPartition(Integer id, String name) {
        if (null == id) {
            throw new NullPointerException("id");
        }
        this._id = id;
        this._name = name;
    }

    public static PhysicalPartition parsePhysicalPartitionString(String pPartString, String del) throws IOException {
        String[] parts = pPartString.split(del);
        if (parts.length <= 1) {
            throw new IOException("invalid physical source name/id format in " + pPartString + ";del=" + del);
        }
        String idS = parts[parts.length - 1];
        Integer id = Integer.parseInt(idS);
        String name = pPartString.substring(0, pPartString.length() - idS.length() - 1);
        if (name.length() < 1) {
            throw new IOException("invalid physical source name format in " + pPartString + ";del=" + del);
        }
        if (id < 0) {
            throw new IOException("invalid physical source id format in " + pPartString + ";del=" + del);
        }
        return new PhysicalPartition(id, name);
    }

    public static PhysicalPartition createAnyPartitionWildcard() {
        return ANY_PHYSICAL_PARTITION;
    }

    public static PhysicalPartition createAnyPartitionWildcard(String dbName) {
        return new PhysicalPartition(ANY_PHYSICAL_PARTITION_ID, dbName);
    }

    public static PhysicalPartition createFromJsonString(String json) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        Builder result = (Builder)mapper.readValue(json, Builder.class);
        return result.build();
    }

    public static PhysicalPartition createFromSimpleString(String simpleString) {
        String dbName;
        if (null == simpleString) {
            return null;
        }
        int index = simpleString.indexOf(58);
        String string = dbName = index < 0 ? simpleString : simpleString.substring(0, index);
        if (dbName.length() < 1) {
            throw new IllegalArgumentException("invalid physical partition string: " + simpleString);
        }
        PhysicalPartition result = null;
        if (index < 0) {
            result = new PhysicalPartition(ANY_PHYSICAL_PARTITION_ID, dbName);
        } else {
            String idStr = simpleString.substring(index + 1);
            if (idStr.equals(ANY_PHYSICAL_PARTITION_NAME)) {
                result = new PhysicalPartition(ANY_PHYSICAL_PARTITION_ID, dbName);
            } else {
                Integer ppartId = -1;
                try {
                    ppartId = Integer.parseInt(idStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("invalid physical partition string: " + simpleString);
                }
                result = new PhysicalPartition(ppartId, dbName);
            }
        }
        return result;
    }

    public Integer getId() {
        return this._id;
    }

    public String toString() {
        return this.toJsonString();
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("{\"id\":");
        sb.append(this._id.shortValue());
        sb.append(",\"name\":");
        sb.append("\"");
        sb.append(this._name);
        sb.append("\"");
        sb.append("}");
        return sb.toString();
    }

    public String toSimpleString() {
        if (null == this._simpleStringCache) {
            this._simpleStringCache = this.toSimpleString(null).toString();
        }
        return this._simpleStringCache;
    }

    public boolean isWildcard() {
        return this.isAnyPartitionWildcard();
    }

    public boolean isAnyPartitionWildcard() {
        return this._id.equals(ANY_PHYSICAL_PARTITION_ID);
    }

    public boolean equalsPartition(PhysicalPartition other) {
        return this._id.shortValue() == other._id.shortValue() && this._name.equals(other._name);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (null == other || !(other instanceof PhysicalPartition)) {
            return false;
        }
        return this.equalsPartition((PhysicalPartition)other);
    }

    public int hashCode() {
        return this._id.hashCode() << 16 + this._name.hashCode();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public int compareTo(PhysicalPartition other) {
        int cv = this.getName().compareTo(other.getName());
        if (cv == 0) {
            return this.getId() - other.getId();
        }
        return cv;
    }

    public StringBuilder toSimpleString(StringBuilder sb) {
        if (null == sb) {
            sb = new StringBuilder(20);
        }
        sb.append(this._name).append(':');
        if (this.isAnyPartitionWildcard()) {
            sb.append(ANY_PHYSICAL_PARTITION_NAME);
        } else {
            sb.append(this._id);
        }
        return sb;
    }

    public static class Builder {
        private Integer _id = ANY_PHYSICAL_PARTITION_ID;
        private String _name = "*";

        public Integer getId() {
            return this._id;
        }

        public void setId(Integer id) {
            this._id = id;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public void makeAnyPartitionWildcard() {
            this._id = ANY_PHYSICAL_PARTITION_ID;
            this._name = PhysicalPartition.ANY_PHYSICAL_PARTITION_NAME;
        }

        public PhysicalPartition build() {
            return new PhysicalPartition(this._id, this._name);
        }
    }
}

