/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.data_model;

import com.linkedin.databus.core.data_model.LogicalSource;
import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class LogicalSourceId {
    private final LogicalSource _source;
    private final Short _id;
    static final Short ALL_LOGICAL_PARTITIONS_ID = -1;

    public LogicalSourceId(LogicalSource source, Short partitionId) {
        if (null == source) {
            throw new NullPointerException("logical partition source");
        }
        if (null == partitionId) {
            throw new NullPointerException("logical partition id");
        }
        this._source = source;
        this._id = partitionId;
    }

    public static LogicalSourceId createFromJsonString(String json) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        Builder result = (Builder)mapper.readValue(json, Builder.class);
        return result.build();
    }

    public LogicalSource getSource() {
        return this._source;
    }

    public Short getId() {
        return this._id;
    }

    public boolean isWildcard() {
        return this.isAllPartitionsWildcard();
    }

    public boolean isAllPartitionsWildcard() {
        return ALL_LOGICAL_PARTITIONS_ID.shortValue() == this._id.shortValue();
    }

    public static LogicalSourceId createAllPartitionsWildcard(LogicalSource source) {
        return new LogicalSourceId(source, ALL_LOGICAL_PARTITIONS_ID);
    }

    public boolean equalsPartition(LogicalSourceId other) {
        return (this.isAllPartitionsWildcard() || other.isAllPartitionsWildcard() || this._id.shortValue() == other._id.shortValue()) && this._source.equals(other._source);
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof LogicalSourceId)) {
            return false;
        }
        return this.equalsPartition((LogicalSourceId)other);
    }

    public int hashCode() {
        return this._id.hashCode() ^ this._source.hashCode();
    }

    public String toString() {
        return this.toJsonString();
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("{\"source\":");
        sb.append(this._source.toString());
        sb.append(",\"id\":");
        sb.append(this._id.shortValue());
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private LogicalSource.Builder _source = new LogicalSource.Builder();
        private Short _id = ALL_LOGICAL_PARTITIONS_ID;

        public LogicalSource.Builder getSource() {
            return this._source;
        }

        public void setSource(LogicalSource.Builder source) {
            this._source = source;
        }

        public Short getId() {
            return this._id;
        }

        public void setId(Short id) {
            this._id = id;
        }

        public void makeAllPartitionsWildcard(LogicalSource source) {
            this._source.setId(source.getId());
            this._source.setName(source.getName());
            this._id = ALL_LOGICAL_PARTITIONS_ID;
        }

        public LogicalSourceId build() {
            return new LogicalSourceId(this._source.build(), this._id);
        }
    }
}

