/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.data_model;

import com.linkedin.databus.core.util.IdNamePair;
import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class LogicalSource {
    private final Integer _id;
    private final String _name;
    static final Integer UNKNOWN_LOGICAL_SOURCE_ID = Short.MIN_VALUE;
    static final Integer ALL_LOGICAL_SOURCES_ID = -1;
    static final String ALL_LOGICAL_SOURCES_NAME = "*";
    public static final LogicalSource ALL_LOGICAL_SOURCES = new LogicalSource(ALL_LOGICAL_SOURCES_ID, "*");

    public LogicalSource(Integer id, String name) {
        if (null == id) {
            throw new NullPointerException("id");
        }
        if (null == name) {
            throw new NullPointerException("name");
        }
        this._id = id;
        this._name = name;
    }

    public LogicalSource(IdNamePair pair) {
        this(pair.getId().intValue(), pair.getName());
    }

    public LogicalSource(String sourceName) {
        this(UNKNOWN_LOGICAL_SOURCE_ID, sourceName);
    }

    public static LogicalSource createAllSourcesWildcard() {
        return ALL_LOGICAL_SOURCES;
    }

    public static LogicalSource createFromJsonString(String json) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        Builder result = (Builder)mapper.readValue(json, Builder.class);
        return result.build();
    }

    public Integer getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this.toJsonString();
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder(this._name.length() + 50);
        sb.append("{\"id\":");
        sb.append(this._id.shortValue());
        sb.append(",\"name\":\"");
        sb.append(this._name);
        sb.append("\"}");
        return sb.toString();
    }

    public boolean isWildcard() {
        return this.isAllSourcesWildcard();
    }

    public boolean isAllSourcesWildcard() {
        return this._id.intValue() == ALL_LOGICAL_SOURCES_ID.intValue();
    }

    public boolean equalsSource(LogicalSource other) {
        return this.isAllSourcesWildcard() || other.isAllSourcesWildcard() || this._name.equals(other.getName());
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof LogicalSource)) {
            return false;
        }
        return this.equalsSource((LogicalSource)other);
    }

    @Deprecated
    public IdNamePair asIdNamePair() {
        return new IdNamePair(this._id.longValue(), this._name);
    }

    public int hashCode() {
        return this._id.intValue() == ALL_LOGICAL_SOURCES_ID.intValue() ? this._id.hashCode() : this._name.hashCode();
    }

    public boolean idKnown() {
        return this._id.intValue() != UNKNOWN_LOGICAL_SOURCE_ID.intValue();
    }

    public StringBuilder toSimpleString(StringBuilder sb) {
        if (null == sb) {
            sb = new StringBuilder(50);
        }
        sb.append("[");
        if (this.isWildcard()) {
            sb.append(ALL_LOGICAL_SOURCES_NAME);
        } else if (this.idKnown()) {
            sb.append("name=").append(this._name).append(", id=").append(this._id);
        } else {
            sb.append("name=").append(this._name);
        }
        sb.append("]");
        return sb;
    }

    public String toSimpleString() {
        return this.toSimpleString(null).toString();
    }

    public static class Builder {
        private Integer _id = ALL_LOGICAL_SOURCES_ID;
        private String _name = "*";

        public Integer getId() {
            return this._id;
        }

        public void setId(Integer id) {
            this._id = id;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
            if (this._id.intValue() == ALL_LOGICAL_SOURCES_ID.intValue() && !LogicalSource.ALL_LOGICAL_SOURCES_NAME.equals(name)) {
                this._id = UNKNOWN_LOGICAL_SOURCE_ID;
            }
        }

        public void makeAllSourcesWildcard() {
            this._id = ALL_LOGICAL_SOURCES_ID;
            this._name = LogicalSource.ALL_LOGICAL_SOURCES_NAME;
        }

        public LogicalSource build() {
            return new LogicalSource(this._id, this._name);
        }
    }
}

