/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.data_model;

public class LogicalPartition {
    private final Short _id;
    private static final Short ALL_LOGICAL_PARTITIONS_ID = -1;
    public static final LogicalPartition ALL_LOGICAL_PARTITIONS = new LogicalPartition(ALL_LOGICAL_PARTITIONS_ID);

    public LogicalPartition(Short id) {
        if (null == id) {
            throw new NullPointerException("id");
        }
        this._id = id;
    }

    public static LogicalPartition createAllPartitionsWildcard() {
        return ALL_LOGICAL_PARTITIONS;
    }

    public Short getId() {
        return this._id;
    }

    public String toString() {
        return this.toJsonString();
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder(15);
        sb.append("{\"id\":");
        sb.append(this._id.shortValue());
        sb.append("}");
        return sb.toString();
    }

    public boolean isWildcard() {
        return this.isAllPartitionsWildcard();
    }

    public boolean isAllPartitionsWildcard() {
        return this.equalsPartition(ALL_LOGICAL_PARTITIONS);
    }

    public boolean equalsPartition(LogicalPartition other) {
        return this._id.shortValue() == other._id.shortValue();
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof LogicalPartition)) {
            return false;
        }
        return this.equalsPartition((LogicalPartition)other);
    }

    public int hashCode() {
        return this._id.hashCode();
    }
}

