/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.data_model;

import com.linkedin.databus.core.data_model.DatabusSubscription;
import com.linkedin.databus.core.data_model.LogicalSource;
import com.linkedin.databus.core.data_model.SubscriptionUriCodec;
import com.linkedin.databus2.core.DatabusException;
import java.net.URI;
import java.net.URISyntaxException;

public class LegacySubscriptionUriCodec
implements SubscriptionUriCodec {
    private static final LegacySubscriptionUriCodec THE_INSTANCE = new LegacySubscriptionUriCodec();

    public static LegacySubscriptionUriCodec getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public String getScheme() {
        return "legacy";
    }

    @Override
    public DatabusSubscription decode(URI uri) throws DatabusException {
        String scheme = uri.getScheme();
        String s = this.getScheme().equals(scheme) ? uri.getSchemeSpecificPart() : uri.toString();
        return DatabusSubscription.createSimpleSourceSubscription(new LogicalSource(s));
    }

    @Override
    public URI encode(DatabusSubscription sub) {
        try {
            String uriSsc = sub.generateSubscriptionString();
            URI result = uriSsc.indexOf(58) >= 0 ? new URI(this.getScheme(), uriSsc, null) : new URI(uriSsc);
            return result;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("unable to generate legacy subscription URI: " + e.getMessage(), e);
        }
    }
}

