/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.data_model;

import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.data_model.LegacySubscriptionUriCodec;
import com.linkedin.databus.core.data_model.LogicalSource;
import com.linkedin.databus.core.data_model.LogicalSourceId;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus.core.data_model.PhysicalSource;
import com.linkedin.databus.core.data_model.SubscriptionUriCodec;
import com.linkedin.databus.core.util.IdNamePair;
import com.linkedin.databus2.core.DatabusException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class DatabusSubscription {
    public static final Logger LOG = Logger.getLogger(DatabusSubscription.class);
    private final PhysicalSource _physicalSource;
    private final PhysicalPartition _physicalPartition;
    private final LogicalSourceId _logicalPartition;
    private static volatile SubscriptionUriCodec _defaultCodec = LegacySubscriptionUriCodec.getInstance();
    private static final Map<String, SubscriptionUriCodec> _uriCodecs = new ConcurrentHashMap<String, SubscriptionUriCodec>(3);
    private static ServiceLoader<SubscriptionUriCodec> _codecSetLoader = ServiceLoader.load(SubscriptionUriCodec.class);

    public static DatabusSubscription createFromUri(String subUriString) throws DatabusException, URISyntaxException {
        String prefix;
        int colonIdx = subUriString.indexOf(58);
        if (colonIdx >= 0 && !_uriCodecs.containsKey(prefix = subUriString.substring(0, colonIdx)) && !_defaultCodec.getScheme().equals(prefix)) {
            subUriString = _defaultCodec.getScheme() + ":" + subUriString;
        }
        URI subUri = new URI(subUriString);
        return DatabusSubscription.createFromUri(subUri);
    }

    public static List<DatabusSubscription> createFromUriList(Collection<String> subUriStringList) throws DatabusException, URISyntaxException {
        ArrayList<DatabusSubscription> subList = new ArrayList<DatabusSubscription>(subUriStringList.size());
        for (String subUriString : subUriStringList) {
            subList.add(DatabusSubscription.createFromUri(subUriString));
        }
        return subList;
    }

    public DatabusSubscription(PhysicalSource physicalSource, PhysicalPartition physicalPartition, LogicalSourceId logicalPartition) {
        if (null == physicalSource) {
            throw new NullPointerException("physical source");
        }
        if (null == physicalPartition) {
            throw new NullPointerException("physical partition");
        }
        if (null == logicalPartition) {
            throw new NullPointerException("logical partition");
        }
        this._physicalSource = physicalSource;
        this._physicalPartition = physicalPartition;
        this._logicalPartition = logicalPartition;
    }

    @Deprecated
    public static DatabusSubscription createSubscription(IdNamePair pair, short lPartitionId) {
        LogicalSource ls = new LogicalSource(pair);
        String name = pair.getName();
        String[] idx = name.split("\\.");
        if (idx.length != 2 && !name.equals("*")) {
            return DatabusSubscription.createSimpleSourceSubscription(pair.getName());
        }
        String dbName = idx[0];
        PhysicalPartition pPart = new PhysicalPartition(Integer.valueOf(lPartitionId), dbName);
        LogicalSourceId lSrcId = new LogicalSourceId(ls, lPartitionId);
        return new DatabusSubscription(PhysicalSource.createAnySourceWildcard(), pPart, lSrcId);
    }

    public static DatabusSubscription createMasterSourceSubscription(LogicalSource source) {
        return new DatabusSubscription(PhysicalSource.createMasterSourceWildcard(), PhysicalPartition.createAnyPartitionWildcard(), LogicalSourceId.createAllPartitionsWildcard(source));
    }

    public static DatabusSubscription createSlaveSourceSubscription(LogicalSource source) {
        return new DatabusSubscription(PhysicalSource.createSlaveSourceWildcard(), PhysicalPartition.createAnyPartitionWildcard(), LogicalSourceId.createAllPartitionsWildcard(source));
    }

    @Deprecated
    public static DatabusSubscription createSimpleSourceSubscription(LogicalSource source) {
        return new DatabusSubscription(PhysicalSource.createAnySourceWildcard(), PhysicalPartition.createAnyPartitionWildcard(), LogicalSourceId.createAllPartitionsWildcard(source));
    }

    @Deprecated
    private static DatabusSubscription createSimpleSourceSubscription(String source) {
        LogicalSource ls = new LogicalSource(source);
        return new DatabusSubscription(PhysicalSource.createAnySourceWildcard(), PhysicalPartition.createAnyPartitionWildcard(), LogicalSourceId.createAllPartitionsWildcard(ls));
    }

    public String generateSubscriptionString() {
        String name = this.getLogicalSource().getName();
        String[] idx = name.split("\\.");
        if (idx.length != 2 && !name.equals("*")) {
            return name;
        }
        SubscriptionUriCodec codec = DatabusSubscription.getUriCodec("espresso");
        URI u = codec.encode(this);
        return u.toString();
    }

    public String createPrettyNameFromSubscription() {
        StringBuilder sb;
        String s = this.generateSubscriptionString();
        URI u = null;
        try {
            u = new URI(s);
        }
        catch (URISyntaxException e) {
            throw new DatabusRuntimeException("Unable to decode a URI from the string s = " + s + " subscription = " + this.toString());
        }
        if (null == u.getScheme()) {
            String[] parts = s.split("\\.");
            int len = parts.length;
            if (len == 0) {
                String errMsg = "Unexpected format for subscription. sub = " + this.toString() + " string = " + s;
                throw new DatabusRuntimeException(errMsg);
            }
            if (len == 1) {
                return parts[0];
            }
            String pn = parts[len - 2] + "_" + parts[len - 1];
            return pn;
        }
        if (u.getScheme().equals("espresso")) {
            String dbName = this.getPhysicalPartition().getName();
            boolean isWildCardOnTables = this.getLogicalSource().isAllSourcesWildcard();
            String name = this.getLogicalPartition().getSource().getName();
            boolean isWildCardOnPartitions = this.getPhysicalPartition().isAnyPartitionWildcard();
            String pId = this.getPhysicalPartition().getId().toString();
            sb = new StringBuilder();
            sb.append(dbName);
            if (!isWildCardOnTables) {
                sb.append("_");
                String[] parts = name.split("\\.");
                assert (parts.length == 2);
                sb.append(parts[1]);
            }
            if (!isWildCardOnPartitions) {
                sb.append("_");
                sb.append(pId);
            }
        } else {
            String errMsg = "The subscription object described as " + this.toString() + " is not of null or espresso type codec";
            throw new DatabusRuntimeException(errMsg);
        }
        s = sb.toString();
        return s;
    }

    public static String getPrettyNameForListOfSubscriptions(List<DatabusSubscription> subscriptions) {
        if (null == subscriptions) {
            return "";
        }
        TreeSet<String> prettyNames = new TreeSet<String>();
        for (DatabusSubscription sub : subscriptions) {
            String curPartName = sub.createPrettyNameFromSubscription();
            prettyNames.add(curPartName);
        }
        StringBuilder sb = new StringBuilder();
        Iterator iter = prettyNames.iterator();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
            if (!iter.hasNext()) continue;
            sb.append("_");
        }
        return sb.toString();
    }

    public static DatabusSubscription createPhysicalPartitionReplicationSubscription(PhysicalPartition physicalPartition) {
        return new DatabusSubscription(PhysicalSource.createMasterSourceWildcard(), physicalPartition, LogicalSourceId.createAllPartitionsWildcard(LogicalSource.createAllSourcesWildcard()));
    }

    public static List<DatabusSubscription> createSubscriptionList(List<String> sources) {
        ArrayList<DatabusSubscription> subsSources = new ArrayList<DatabusSubscription>();
        for (String s : sources) {
            DatabusSubscription sub = null;
            try {
                sub = DatabusSubscription.createFromUri(s);
                subsSources.add(sub);
            }
            catch (DatabusException d) {
                LOG.error((Object)("Error processing subscription " + sub + " with exception " + d));
            }
            catch (URISyntaxException e) {
                LOG.error((Object)e);
            }
        }
        return subsSources;
    }

    public static List<String> getStrList(List<DatabusSubscription> sources) {
        ArrayList<String> strSources = new ArrayList<String>();
        for (DatabusSubscription sub : sources) {
            String s = sub.generateSubscriptionString();
            strSources.add(s);
        }
        return strSources;
    }

    public static DatabusSubscription createFromJsonString(String json) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        Builder result = (Builder)mapper.readValue(json, Builder.class);
        return result.build();
    }

    public PhysicalSource getPhysicalSource() {
        return this._physicalSource;
    }

    public PhysicalPartition getPhysicalPartition() {
        return this._physicalPartition;
    }

    public LogicalSourceId getLogicalPartition() {
        return this._logicalPartition;
    }

    public LogicalSource getLogicalSource() {
        return this._logicalPartition.getSource();
    }

    public boolean equalsSubscription(DatabusSubscription other) {
        boolean eq;
        boolean bl = eq = this._physicalSource.isAnySourceWildcard() || other._physicalSource.isAnySourceWildcard() || this._physicalSource.equals(other._physicalSource);
        if (!eq) {
            return false;
        }
        boolean bl2 = eq = this._physicalPartition.isAnyPartitionWildcard() || other._physicalPartition.isAnyPartitionWildcard() || this._physicalPartition.equals(other._physicalPartition);
        if (!eq) {
            return false;
        }
        eq = this._logicalPartition.equals(other._logicalPartition);
        return eq;
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof DatabusSubscription)) {
            return false;
        }
        return this.equalsSubscription((DatabusSubscription)other);
    }

    public int hashCode() {
        return this._physicalSource.hashCode() ^ this._physicalPartition.hashCode() ^ this._logicalPartition.hashCode();
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("{\"physicalSource\":");
        sb.append(this._physicalSource.toJsonString());
        sb.append(",\"physicalPartition\":");
        sb.append(this._physicalPartition.toJsonString());
        sb.append(",\"logicalPartition\":");
        sb.append(this._logicalPartition.toJsonString());
        sb.append("}");
        return sb.toString();
    }

    public String uniqString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._physicalPartition.getName());
        sb.append('_');
        sb.append(this._physicalPartition.getId());
        sb.append('_');
        sb.append(this._logicalPartition.getSource().getId());
        sb.append('_');
        sb.append(this._logicalPartition.getSource().getName());
        sb.append('_');
        sb.append(this._logicalPartition.getId());
        return sb.toString();
    }

    public static DatabusSubscription createFromUri(URI subUri) throws DatabusException {
        SubscriptionUriCodec codec;
        SubscriptionUriCodec subscriptionUriCodec = codec = null == subUri.getScheme() || 0 == subUri.getScheme().length() || subUri.getScheme().equals(_defaultCodec.getScheme()) ? _defaultCodec : _uriCodecs.get(subUri.getScheme());
        if (null == codec) {
            codec = _defaultCodec;
        }
        return codec.decode(subUri);
    }

    public static List<DatabusSubscription> createFromUriListString(String subUriListString) throws DatabusException, URISyntaxException {
        String[] subUriStringList = subUriListString.split(",");
        ArrayList<DatabusSubscription> subList = new ArrayList<DatabusSubscription>(subUriStringList.length);
        for (String subUriString : subUriStringList) {
            subList.add(DatabusSubscription.createFromUri(subUriString));
        }
        return subList;
    }

    public static List<String> createUriStringList(Collection<DatabusSubscription> subs, SubscriptionUriCodec codec) {
        ArrayList<String> result = new ArrayList<String>(subs.size());
        for (DatabusSubscription sub : subs) {
            String uri = codec.encode(sub).toString();
            result.add(uri);
        }
        return result;
    }

    public static void loadAndRegisterCodecs() {
        LOG.info((Object)"Registering URI codecs.");
        for (SubscriptionUriCodec codec : _codecSetLoader) {
            LOG.info((Object)("Registering URI codec:" + codec.getScheme()));
            DatabusSubscription.registerUriCodec(codec);
        }
    }

    public static void registerUriCodec(SubscriptionUriCodec codec) {
        if (null == codec.getScheme() || 0 == codec.getScheme().length()) {
            _defaultCodec = codec;
        } else {
            SubscriptionUriCodec old = _uriCodecs.put(codec.getScheme(), codec);
            if (null != old) {
                LOG.warn((Object)("replacing existing codec for scheme " + old.getScheme() + ": " + old));
            }
        }
    }

    public static void unregisterUriCodec(SubscriptionUriCodec codec) {
        if (codec.equals(_uriCodecs.get(codec.getScheme()))) {
            _uriCodecs.remove(codec.getScheme());
        }
    }

    public static void unregisterUriCodec(String codecScheme) {
        _uriCodecs.remove(codecScheme);
    }

    public static SubscriptionUriCodec getUriCodec(String scheme) {
        return _uriCodecs.get(scheme);
    }

    public String toString() {
        return this.toJsonString();
    }

    public StringBuilder toSimpleString(StringBuilder sb) {
        if (null == sb) {
            sb = new StringBuilder(100);
        }
        sb.append("[ps=");
        this._physicalSource.toSimpleString(sb).append(", pp=");
        this._physicalPartition.toSimpleString(sb).append(", ls=");
        this._logicalPartition.getSource().toSimpleString(sb).append("]");
        return sb;
    }

    public String toSimpleString() {
        return this.toSimpleString(null).toString();
    }

    public static SubscriptionUriCodec getDefaultCodec() {
        return _defaultCodec;
    }

    static {
        DatabusSubscription.loadAndRegisterCodecs();
    }

    public static class Builder {
        private PhysicalSource.Builder _physicalSource = new PhysicalSource.Builder();
        private PhysicalPartition.Builder _physicalPartition = new PhysicalPartition.Builder();
        private LogicalSourceId.Builder _logicalPartition = new LogicalSourceId.Builder();

        public PhysicalSource.Builder getPhysicalSource() {
            return this._physicalSource;
        }

        public void setPhysicalSource(PhysicalSource.Builder physicalSource) {
            this._physicalSource = physicalSource;
        }

        public PhysicalPartition.Builder getPhysicalPartition() {
            return this._physicalPartition;
        }

        public void setPhysicalPartition(PhysicalPartition.Builder physicalPartition) {
            this._physicalPartition = physicalPartition;
        }

        public LogicalSourceId.Builder getLogicalPartition() {
            return this._logicalPartition;
        }

        public void setLogicalPartition(LogicalSourceId.Builder logicalSourceId) {
            this._logicalPartition = logicalSourceId;
        }

        public DatabusSubscription build() {
            return new DatabusSubscription(this._physicalSource.build(), this._physicalPartition.build(), this._logicalPartition.build());
        }

        public boolean isEqualToSource(String source) {
            LogicalSource ls = this._logicalPartition.getSource().build();
            if (ls.isAllSourcesWildcard()) {
                return true;
            }
            return ls.getName().equals(source);
        }
    }
}

