/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.cmclient;

import com.linkedin.databus.core.cmclient.LogicalPartitionRepresentation;
import com.linkedin.databus.core.data_model.Role;
import java.text.ParseException;

public class ResourceKey
implements Comparable<ResourceKey> {
    private int NUM_SUBKEYS = 4;
    private String _physicalSource;
    private String _physicalPartition;
    private LogicalPartitionRepresentation _logicalPartitionRepresentation;
    private Role _role;

    public ResourceKey(String resourceKey) throws ParseException {
        String[] parts = resourceKey.split(",");
        if (parts.length != this.NUM_SUBKEYS) {
            throw new ParseException("Resource key " + resourceKey + " has " + parts.length + " parts instead of " + this.NUM_SUBKEYS, 0);
        }
        this._physicalSource = parts[0];
        this._physicalPartition = parts[1];
        this._logicalPartitionRepresentation = new LogicalPartitionRepresentation(parts[2]);
        this._role = new Role(parts[3]);
    }

    public String getPhysicalSource() {
        return this._physicalSource;
    }

    public String getPhysicalPartition() {
        return this._physicalPartition;
    }

    public String getLogicalPartition() {
        return this._logicalPartitionRepresentation.getLogicalPartition();
    }

    public int getLogicalPartitionNumber() {
        return this._logicalPartitionRepresentation.getPartitionNum();
    }

    public int getLogicalSchemaVersion() {
        return this._logicalPartitionRepresentation.getSchemaVersion();
    }

    public Role getRole() {
        return this._role;
    }

    public String getRoleString() {
        return this._role.toString();
    }

    public boolean isMaster() {
        return this._role.checkIfMaster();
    }

    public boolean isValidRole() {
        return this._role.checkIfMaster() || this._role.checkIfSlave();
    }

    public String toString() {
        return "ResourceKey [_physicalSource=" + this._physicalSource + ", _physicalPartition=" + this._physicalPartition + ", _logicalPartitionRepresentation=" + this._logicalPartitionRepresentation + ", _role=" + this._role + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.NUM_SUBKEYS;
        result = 31 * result + (this._logicalPartitionRepresentation == null ? 0 : this._logicalPartitionRepresentation.hashCode());
        result = 31 * result + (this._physicalPartition == null ? 0 : this._physicalPartition.hashCode());
        result = 31 * result + (this._physicalSource == null ? 0 : this._physicalSource.hashCode());
        result = 31 * result + (this._role == null ? 0 : this._role.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceKey other = (ResourceKey)obj;
        if (this.NUM_SUBKEYS != other.NUM_SUBKEYS) {
            return false;
        }
        if (this._logicalPartitionRepresentation == null ? other._logicalPartitionRepresentation != null : !this._logicalPartitionRepresentation.equals(other._logicalPartitionRepresentation)) {
            return false;
        }
        if (this._physicalPartition == null ? other._physicalPartition != null : !this._physicalPartition.equals(other._physicalPartition)) {
            return false;
        }
        if (this._physicalSource == null ? other._physicalSource != null : !this._physicalSource.equals(other._physicalSource)) {
            return false;
        }
        return this._role.equals(other._role);
    }

    @Override
    public int compareTo(ResourceKey o) {
        String s1 = "" + this._physicalSource + this._physicalPartition + this.getLogicalPartition();
        String s2 = "" + o.getPhysicalSource() + o.getPhysicalPartition() + o.getLogicalPartition();
        return s1.compareTo(s2);
    }
}

