/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.cmclient;

import java.text.ParseException;

public class LogicalPartitionRepresentation {
    private int _partitionNum;
    private int _schemaVersion;
    private String _logicalPartition;

    LogicalPartitionRepresentation(String logicalPartition) throws ParseException, NumberFormatException {
        if (logicalPartition.charAt(0) != 'p') {
            throw new ParseException(logicalPartition, 0);
        }
        String nextStr = logicalPartition.substring(1);
        String[] parts = nextStr.split("_");
        if (parts.length != 2) {
            throw new ParseException("logical Partition does not have numbers of format p[num1]_[num2]" + logicalPartition, 0);
        }
        int p = Integer.parseInt(parts[0]);
        int s = Integer.parseInt(parts[1]);
        this._logicalPartition = logicalPartition;
        this._partitionNum = p;
        this._schemaVersion = s;
    }

    LogicalPartitionRepresentation(int partitionNum, int schemaVersion) {
        this._partitionNum = partitionNum;
        this._schemaVersion = schemaVersion;
        this._logicalPartition = "p" + Integer.toString(partitionNum) + "_" + Integer.toString(schemaVersion);
    }

    public int getPartitionNum() {
        return this._partitionNum;
    }

    public int getSchemaVersion() {
        return this._schemaVersion;
    }

    public String getLogicalPartition() {
        return this._logicalPartition;
    }

    public String toString() {
        return "LogicalPartitionRepresentation [_partitionNum=" + this._partitionNum + ", _schemaVersion=" + this._schemaVersion + ", _logicalPartition=" + this._logicalPartition + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._logicalPartition == null ? 0 : this._logicalPartition.hashCode());
        result = 31 * result + this._partitionNum;
        result = 31 * result + this._schemaVersion;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogicalPartitionRepresentation other = (LogicalPartitionRepresentation)obj;
        if (this._logicalPartition == null ? other._logicalPartition != null : !this._logicalPartition.equals(other._logicalPartition)) {
            return false;
        }
        if (this._partitionNum != other._partitionNum) {
            return false;
        }
        return this._schemaVersion == other._schemaVersion;
    }
}

