/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.async;

public class LifecycleMessage {
    private Throwable _lastError = null;
    private TypeId _typeId = null;

    public static LifecycleMessage createStartMessage() {
        return new LifecycleMessage().switchToStart();
    }

    public static LifecycleMessage createShutdownMessage() {
        return new LifecycleMessage().switchToShutdown(null);
    }

    public static LifecycleMessage createShutdownMessage(Throwable reason) {
        return new LifecycleMessage().switchToShutdown(reason);
    }

    public static LifecycleMessage createPauseMessage() {
        return new LifecycleMessage().switchToPause();
    }

    public static LifecycleMessage createSuspendOnErroMessage(Throwable reason) {
        return new LifecycleMessage().switchToSuspendOnError(reason);
    }

    public static LifecycleMessage createResumeMessage() {
        return new LifecycleMessage().switchToResume();
    }

    public Throwable getLastError() {
        return this._lastError;
    }

    public TypeId getTypeId() {
        return this._typeId;
    }

    public LifecycleMessage switchToStart() {
        this._typeId = TypeId.START;
        return this;
    }

    public LifecycleMessage switchToShutdown(Throwable reason) {
        this._typeId = TypeId.SHUTDOWN;
        this._lastError = reason;
        return this;
    }

    public LifecycleMessage switchToPause() {
        this._typeId = TypeId.PAUSE;
        return this;
    }

    public LifecycleMessage switchToSuspendOnError(Throwable reason) {
        this._typeId = TypeId.SUSPEND_ON_ERROR;
        this._lastError = reason;
        return this;
    }

    public LifecycleMessage switchToResume() {
        this._typeId = TypeId.RESUME;
        return this;
    }

    public String toString() {
        return this._typeId.toString();
    }

    public static enum TypeId {
        START,
        SHUTDOWN,
        PAUSE,
        SUSPEND_ON_ERROR,
        RESUME;

    }
}

