/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventBufferMetaInfo;
import com.linkedin.databus.core.InternalDatabusEventsListenerAbstract;
import com.linkedin.databus.core.OffsetNotFoundException;
import com.linkedin.databus.core.util.BufferPosition;
import com.linkedin.databus.core.util.BufferPositionParser;
import com.linkedin.databus2.core.AssertLevel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.Date;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class ScnIndex
extends InternalDatabusEventsListenerAbstract {
    public static final String MODULE = ScnIndex.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final int SIZE_OF_SCN_OFFSET_RECORD = 16;
    public static final String SCNINDEX_METAINFO_FILE_NAME = "scnIndexMetaFile";
    private final ByteBuffer buffer;
    private final BufferPositionParser positionParser;
    private volatile int head = -1;
    private volatile int tail = 0;
    private final int maxElements;
    private long lastScnWritten = -1L;
    private int lastWrittenPosition = -1;
    private final int blockSize;
    private final int individualBufferSize;
    private final ReentrantReadWriteLock rwLock;
    private boolean updateOnNext;
    private boolean isFirstCheck = true;
    private final AssertLevel _assertLevel;
    private final File _mmapSessionDirectory;
    private final boolean _enabled;
    private boolean updatedOnCurrentWindow = false;

    public boolean isEnabled() {
        return this._enabled;
    }

    public ScnIndex(int maxIndexSize, long totalAddressedSpace, int individualBufferSize, BufferPositionParser parser, DbusEventBuffer.AllocationPolicy allocationPolicy, boolean restoreBuffer, File mmapSessionDirectory, AssertLevel assertLevel, boolean enabled, ByteOrder byteOrder) {
        this._enabled = enabled;
        this._assertLevel = null != assertLevel ? assertLevel : AssertLevel.NONE;
        this.rwLock = new ReentrantReadWriteLock();
        this.maxElements = maxIndexSize / 16;
        int proposedBlockSize = (int)(totalAddressedSpace / (long)this.maxElements);
        if (1L * (long)proposedBlockSize * (long)this.maxElements < totalAddressedSpace) {
            ++proposedBlockSize;
        }
        this.blockSize = proposedBlockSize;
        assert (1L * (long)this.blockSize * (long)this.maxElements >= totalAddressedSpace);
        this.positionParser = parser;
        int bufSize = this.maxElements * 16;
        this.buffer = this.isEnabled() ? DbusEventBuffer.allocateByteBuffer(bufSize, byteOrder, allocationPolicy, restoreBuffer, mmapSessionDirectory, new File(mmapSessionDirectory, "scnIndex")) : null;
        this._mmapSessionDirectory = mmapSessionDirectory;
        this.individualBufferSize = individualBufferSize;
        this.lastScnWritten = -1L;
        this.updateOnNext = false;
        if (!this.isEnabled()) {
            LOG.info((Object)"ScnIndex not enabled");
            return;
        }
        if (allocationPolicy == DbusEventBuffer.AllocationPolicy.MMAPPED_MEMORY && restoreBuffer) {
            File metaFile = new File(mmapSessionDirectory, SCNINDEX_METAINFO_FILE_NAME);
            DbusEventBufferMetaInfo mi = null;
            if (metaFile.exists()) {
                mi = new DbusEventBufferMetaInfo(metaFile);
                try {
                    mi.loadMetaInfo();
                    if (!mi.isValid()) {
                        throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException(mi, "metaInfoFile is not valid");
                    }
                    this.setAndValidateMetaState(mi);
                }
                catch (DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException e) {
                    throw new RuntimeException(e);
                }
            } else {
                LOG.warn((Object)("restoreMMappedBuffer is set to true, but file " + metaFile + " does't exist"));
            }
        }
        LOG.info((Object)("ScnIndex configured with: maxElements = " + this.maxElements));
    }

    private void setAndValidateMetaState(DbusEventBufferMetaInfo mi) throws DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException {
        LOG.info((Object)("loading metaInfoFile " + mi.toString()));
        DbusEventBufferMetaInfo.BufferInfo bi = mi.getScnIndexBufferInfo();
        this.buffer.limit(bi.getLimit());
        this.buffer.position(bi.getPos());
        if (this.buffer.position() > this.buffer.limit() || this.buffer.limit() > this.buffer.capacity() || this.buffer.capacity() != bi.getCapacity()) {
            throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException(mi, "ScnIndex buffer is not valid: pos =" + this.buffer.position() + "; limit = " + this.buffer.limit() + "; cap=" + this.buffer.capacity() + "; miCapacity= " + bi.getCapacity());
        }
        int scnBufferSize = mi.getInt("scnBufferSize");
        if (scnBufferSize != this.buffer.capacity()) {
            throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException(mi, "Invalid scnBufferSize in meta file:" + scnBufferSize + "(expected =" + this.buffer.capacity() + ")");
        }
        this.lastScnWritten = mi.getLong("lastScnWritten");
        this.updateOnNext = mi.getBool("updateOnNext");
        this.head = mi.getInt("head");
        this.lastScnWritten = mi.getLong("lastScnWritten");
        this.tail = mi.getInt("tail");
        int miMaxElements = mi.getInt("maxElements");
        if (miMaxElements != this.maxElements || this.maxElements * 16 != scnBufferSize) {
            throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException(mi, "maxElements in meta file didn't match maxElements:" + miMaxElements + " != " + this.maxElements);
        }
        this.lastWrittenPosition = mi.getInt("lastWrittenPosition");
        int miBlockSize = mi.getInt("blockSize");
        if (miBlockSize != this.blockSize) {
            throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException(mi, "miBlockSize in meta file didn't match blockSize:" + miBlockSize + " != " + this.blockSize);
        }
        int miIndividualBufferSize = mi.getInt("individualBufferSize");
        if (miIndividualBufferSize != this.individualBufferSize) {
            throw new DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException(mi, "miIndividualBufferSize in meta file didn't match individualBufferSize:" + miIndividualBufferSize + " != " + this.individualBufferSize);
        }
        this.isFirstCheck = mi.getBool("isFirstCheck");
        this.updatedOnCurrentWindow = mi.getBool("updatedOnCurrentWindow");
        this.assertHead();
        this.assertTail();
        this.assertOrder();
        this.assertOffsets();
    }

    public void saveBufferMetaInfo() throws IOException {
        if (!this.isEnabled()) {
            return;
        }
        DbusEventBufferMetaInfo mi = new DbusEventBufferMetaInfo(new File(this._mmapSessionDirectory, SCNINDEX_METAINFO_FILE_NAME));
        LOG.info((Object)("about to save scnindex state into " + mi.toString()));
        mi.setScnIndexBufferInfo(new DbusEventBufferMetaInfo.BufferInfo(this.buffer.position(), this.buffer.limit(), this.buffer.capacity()));
        mi.setVal("scnBufferSize", Integer.toString(this.buffer.capacity()));
        mi.setVal("lastScnWritten", Long.toString(this.lastScnWritten));
        mi.setVal("updateOnNext", Boolean.toString(this.updateOnNext));
        mi.setVal("head", Integer.toString(this.head));
        mi.setVal("tail", Integer.toString(this.tail));
        mi.setVal("maxElements", Integer.toString(this.maxElements));
        mi.setVal("lastScnWritten", Long.toString(this.lastScnWritten));
        mi.setVal("lastWrittenPosition", Integer.toString(this.lastWrittenPosition));
        mi.setVal("blockSize", Integer.toString(this.blockSize));
        mi.setVal("individualBufferSize", Integer.toString(this.individualBufferSize));
        mi.setVal("isFirstCheck", Boolean.toString(this.isFirstCheck));
        mi.setVal("updatedOnCurrentWindow", Boolean.toString(this.updatedOnCurrentWindow));
        mi.saveAndClose();
    }

    @Override
    public void close() {
        if (this.isEnabled()) {
            this.flushMMappedBuffers();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        if (this.isEnabled()) {
            sb.append("{\"head\": ");
            sb.append(this.head);
            sb.append(", \"headIdx\":");
            sb.append(this.head / 16);
            sb.append(", \"tail\":");
            sb.append(this.tail);
            sb.append(", \"tailIdx\":");
            sb.append(this.tail / 16);
            sb.append(", \"lastWrittenPosition\":");
            sb.append(this.lastWrittenPosition);
            sb.append(", \"lastScnWritten\":");
            sb.append(this.lastScnWritten);
            sb.append(", \"size\":");
            sb.append(this.size());
            sb.append(", \"maxSize\":");
            sb.append(this.maxElements);
            sb.append(", \"minScn\":");
            sb.append(this.getMinScn());
            sb.append(", \"blockSize\":");
            sb.append(this.blockSize);
            sb.append(" \"updateOnNext\":");
            sb.append(this.updateOnNext);
            sb.append(" \"assertLevel\":");
            sb.append((Object)this._assertLevel);
            sb.append("}\n");
        } else {
            sb.append("{\"enabled\" : false}");
        }
        return sb.toString();
    }

    public void printVerboseString(Logger log, Level l) {
        PatternLayout defaultLayout = new PatternLayout("%m%n");
        ConsoleAppender defaultAppender = new ConsoleAppender((Layout)defaultLayout);
        Logger newLog = Logger.getLogger((String)"Simple");
        newLog.removeAllAppenders();
        newLog.addAppender((Appender)defaultAppender);
        newLog.setAdditivity(false);
        newLog.setLevel(Level.ALL);
        log.log((Priority)l, (Object)this.toString());
        if (!this.isEnabled()) {
            log.log((Priority)l, (Object)"ScnIndex is disabled");
            return;
        }
        long currentScn = -1L;
        long currentOffset = -1L;
        long beginBlock = 0L;
        long endBlock = 0L;
        newLog.log((Priority)l, (Object)("logger name: " + log.getName() + " ts:" + new Date()));
        for (int position = 0; position < this.buffer.limit(); position += 16) {
            long nextOffset = this.getOffset(position);
            if (currentOffset < 0L) {
                currentOffset = nextOffset;
            }
            long nextBlock = position / 16;
            long nextScn = this.getScn(position);
            if (currentScn < 0L) {
                currentScn = nextScn;
            }
            if (nextOffset != currentOffset || currentScn != nextScn) {
                newLog.log((Priority)l, (Object)this.buildBlockIndexString(beginBlock, endBlock, currentScn, currentOffset));
                currentOffset = nextOffset;
                beginBlock = nextBlock;
                currentScn = nextScn;
            }
            endBlock = nextBlock;
        }
        newLog.log((Priority)l, (Object)this.buildBlockIndexString(beginBlock, endBlock, currentScn, currentOffset));
    }

    private String buildBlockIndexString(long beginBlock, long endBlock, long scn, long offset) {
        String block = "" + endBlock;
        if (beginBlock != endBlock) {
            block = "[" + beginBlock + "-" + endBlock + "]";
        }
        return block + ":" + scn + "->" + offset + " " + this.positionParser.toString(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinScn() {
        if (!this.isEnabled()) {
            throw new RuntimeException("ScnIndex not enabled");
        }
        this.acquireReadLock();
        try {
            long minScn;
            if (this.empty()) {
                long l = -1L;
                return l;
            }
            long l = minScn = this.getScn(this.head);
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void acquireReadLock() {
        this.rwLock.readLock().lock();
    }

    private void releaseReadLock() {
        this.rwLock.readLock().unlock();
    }

    void acquireWriteLock() {
        this.rwLock.writeLock().lock();
    }

    void releaseWriteLock() {
        this.rwLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScnOffset(int blockNumber, long scn, long offset) {
        boolean isDebug = LOG.isDebugEnabled();
        this.assertEquals("SCN Index Tail Check", this.buffer.position(), this.tail, AssertLevel.QUICK);
        int startPos = this.tail;
        this.updatedOnCurrentWindow = false;
        if (this.lastWrittenPosition == blockNumber * 16) {
            return;
        }
        try {
            boolean overwritingHead;
            this.acquireWriteLock();
            int currentWritePosition = this.tail;
            boolean bl = overwritingHead = currentWritePosition == this.head;
            if (this.lastWrittenPosition >= 0) {
                long lastWrittenScn = this.getScn(this.lastWrittenPosition);
                long lastWrittenOffset = this.getOffset(this.lastWrittenPosition);
                while (!overwritingHead && currentWritePosition != blockNumber * 16) {
                    if (currentWritePosition == this.head) {
                        overwritingHead = true;
                        break;
                    }
                    if (isDebug) {
                        LOG.trace((Object)("ScnIndex:Extend:[" + this.buffer.position() + "]" + lastWrittenScn + "->" + lastWrittenOffset));
                    }
                    this.buffer.putLong(lastWrittenScn);
                    this.buffer.putLong(lastWrittenOffset);
                    this.lastWrittenPosition = currentWritePosition;
                    if (this.buffer.position() == this.buffer.limit()) {
                        this.buffer.position(0);
                    }
                    currentWritePosition = this.buffer.position();
                }
                if (currentWritePosition == this.head) {
                    overwritingHead = true;
                }
            } else {
                overwritingHead = false;
            }
            if (!overwritingHead) {
                if (isDebug) {
                    LOG.debug((Object)("ScnIndex:Write:[" + this.buffer.position() + "]" + scn + "->" + offset));
                }
                this.buffer.putLong(scn);
                this.buffer.putLong(offset);
                this.lastScnWritten = scn;
                this.lastWrittenPosition = currentWritePosition;
                this.updatedOnCurrentWindow = true;
                if (this.buffer.position() == this.buffer.limit()) {
                    this.buffer.position(0);
                }
                currentWritePosition = this.buffer.position();
            }
            if (this.head < 0) {
                this.head = startPos;
            }
            this.tail = this.buffer.position();
            if (isDebug) {
                LOG.debug((Object)("Setting SCNIndex tail to :" + this.tail + " after writing EVB offset :" + this.positionParser.toString(offset) + " for SCN : " + scn + " till block number :" + blockNumber));
            }
            if (this._assertLevel.quickEnabled()) {
                this.assertHead();
                this.assertTail();
                if (this._assertLevel.mediumEnabled()) {
                    this.assertOrder();
                    this.assertOffsets();
                }
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    int getBlockNumber(long offset) {
        if (!this.isEnabled()) {
            throw new RuntimeException("ScnIndex not enabled");
        }
        long bufferIndex = this.positionParser.bufferIndex(offset);
        long buf_offset = this.positionParser.bufferOffset(offset);
        long blockNumber = (bufferIndex * (long)this.individualBufferSize + buf_offset) / (long)this.blockSize;
        return (int)blockNumber;
    }

    void flushMMappedBuffers() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.buffer instanceof MappedByteBuffer) {
            ((MappedByteBuffer)this.buffer).force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScnIndexEntry getClosestOffset(long searchScn) throws OffsetNotFoundException {
        this.acquireReadLock();
        try {
            if (!this.isEnabled()) {
                throw new RuntimeException("ScnIndex not enabled");
            }
            if (this.empty()) {
                LOG.info((Object)"ScnIndex is empty");
                throw new OffsetNotFoundException();
            }
            int startRightOfs = this.tail;
            int left = this.head;
            int right = startRightOfs;
            int index = ScnIndex.midPoint(left, right, this.buffer.limit());
            long currScn = this.getScn(index);
            boolean found = false;
            while (!found) {
                if (this.isClosestScn(currScn, searchScn, index, startRightOfs)) {
                    int lessIndex = ScnIndex.decrement(index, this.buffer.limit());
                    long lessScn = this.getScn(lessIndex);
                    while (index != this.head && currScn == lessScn) {
                        index = lessIndex;
                        currScn = lessScn;
                        lessIndex = ScnIndex.decrement(index, this.buffer.limit());
                        lessScn = this.getScn(lessIndex);
                    }
                    found = true;
                    ScnIndexEntry scnIndexEntry = new ScnIndexEntry(currScn, this.getOffset(index));
                    return scnIndexEntry;
                }
                if (currScn > searchScn) {
                    if (index == right || (left + 16) % this.buffer.limit() == right) {
                        LOG.error((Object)("Case 1 : currScn > searchScn and index == rightindex = " + index + " right = " + right + " left = " + left + " buffer.limit = " + this.buffer.limit() + " searchScn = " + searchScn + " currScn = " + currScn));
                        this.printVerboseString(LOG, Level.ERROR);
                        throw new OffsetNotFoundException();
                    }
                    right = index;
                } else {
                    if (index == left) {
                        LOG.error((Object)("Case 2 : currScn <= searchScn and index == leftindex = " + index + " right = " + right + " left = " + left + " buffer.limit = " + this.buffer.limit() + " searchScn = " + searchScn + " currScn = " + currScn));
                        this.printVerboseString(LOG, Level.ERROR);
                        throw new OffsetNotFoundException();
                    }
                    left = index;
                }
                int prevIndex = index;
                index = ScnIndex.midPoint(left, right, this.buffer.limit());
                if (prevIndex == index) {
                    LOG.error((Object)("Case 3 : currScn > searchScn and prevIndex == indexindex = " + index + " prevIndex = " + prevIndex + " right = " + right + " left = " + left + " buffer.limit = " + this.buffer.limit() + " searchScn = " + searchScn + " currScn = " + currScn));
                    this.printVerboseString(LOG, Level.ERROR);
                    throw new OffsetNotFoundException();
                }
                currScn = this.getScn(index);
            }
            ScnIndexEntry scnIndexEntry = new ScnIndexEntry(currScn, this.getOffset(index));
            return scnIndexEntry;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean empty() {
        return ScnIndex.numElements(this.head, this.tail, this.buffer.limit()) == 0;
    }

    private long getScn(int entryOffset) {
        return this.buffer.getLong(entryOffset);
    }

    private long getOffset(int entryOffset) {
        return this.buffer.getLong(entryOffset + 8);
    }

    private int entryIndexOfs(int entryIndex) {
        return (this.head + entryIndex * 16) % (16 * this.maxElements);
    }

    private long getEntryScn(int entryIndex) {
        if (-1 == this.head) {
            return -1L;
        }
        return this.getScn(this.entryIndexOfs(entryIndex));
    }

    private long getEntryOffset(int entryIndex) {
        if (-1 == this.head) {
            return -1L;
        }
        return this.getOffset(this.entryIndexOfs(entryIndex));
    }

    private boolean isClosestScn(long indexScn, long searchScn, int index, int maxIndex) {
        if (indexScn == searchScn) {
            return true;
        }
        if (indexScn < searchScn) {
            if ((index + 16) % this.buffer.limit() == maxIndex) {
                return true;
            }
            return this.getScn((index + 16) % this.buffer.limit()) > searchScn;
        }
        return false;
    }

    private int size() {
        return ScnIndex.numElements(this.head, this.tail, this.maxElements * 16);
    }

    private static int numElements(int left, int right, int end) {
        if (left < 0) {
            return 0;
        }
        if (left == right) {
            return end / 16;
        }
        if (left < right) {
            return (right - left) / 16;
        }
        return (end - left + right) / 16;
    }

    private boolean full() {
        return ScnIndex.numElements(this.head, this.tail, this.buffer.limit()) == this.maxElements;
    }

    private static int midPoint(int left, int right, int end) {
        int size = ScnIndex.numElements(left, right, end);
        return (left + size / 2 * 16) % end;
    }

    private static int decrement(int index, int end) {
        if (index >= 16) {
            return index - 16;
        }
        return end - 16;
    }

    public void clear() {
        if (!this.isEnabled()) {
            return;
        }
        this.buffer.rewind();
        this.head = -1;
        this.tail = 0;
        this.lastScnWritten = -1L;
        this.lastWrittenPosition = this.head;
        this.updateOnNext = false;
    }

    @Override
    public void onEvent(DbusEvent event, long offset, int size) {
        if (!this.isEnabled()) {
            return;
        }
        boolean shouldUpdate = this.shouldUpdate(event);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ScnIndex:onEvent:offset" + offset + " Event:" + event.sequence() + ";shouldUpdate=" + shouldUpdate + ";eop=" + event.isEndOfPeriodMarker()));
        }
        if (shouldUpdate) {
            if (event.sequence() < this.lastScnWritten) {
                throw new RuntimeException("Event Sequence " + event.sequence() + " < lastScnWritten " + this.lastScnWritten);
            }
            int blockNumber = this.getBlockNumber(offset);
            this.setScnOffset(blockNumber, event.sequence(), offset);
        }
    }

    private boolean shouldUpdate(DbusEvent event) {
        boolean returnVal = this.updateOnNext && !event.isControlMessage();
        this.updateOnNext = event.isEndOfPeriodMarker();
        return returnVal;
    }

    public boolean isEmpty() {
        if (!this.isEnabled()) {
            throw new RuntimeException("ScnIndex not enabled");
        }
        return this.head == -1;
    }

    protected void setUpdateOnNext(boolean val) {
        if (!this.isEnabled()) {
            return;
        }
        this.updateOnNext = val;
    }

    protected boolean getUpdateOnNext() {
        if (!this.isEnabled()) {
            throw new RuntimeException("ScnIndex not enabled");
        }
        return this.updateOnNext;
    }

    public long getLargerOffset(long offset) {
        if (!this.isEnabled()) {
            throw new RuntimeException("ScnIndex not enabled");
        }
        boolean trace = false;
        int blockNumber = this.getBlockNumber(offset);
        long currentOffset = this.getOffset(blockNumber * 16);
        int maxIterations = ScnIndex.numElements(this.head, this.tail, this.buffer.limit());
        if (trace) {
            LOG.info((Object)("offset = " + offset + ";blockNumber = " + blockNumber + ";currentOffset = " + currentOffset + ";currentScn = " + this.getScn(blockNumber * 16)));
            LOG.info((Object)("maxIterations = " + maxIterations));
        }
        long prevOffset = currentOffset;
        while (prevOffset == currentOffset && maxIterations > 0) {
            if (++blockNumber >= this.maxElements) {
                blockNumber = 0;
            }
            prevOffset = currentOffset;
            currentOffset = this.getOffset(blockNumber * 16);
            --maxIterations;
        }
        if (maxIterations == 0) {
            return -1L;
        }
        if (trace) {
            LOG.info((Object)("Returning currentOffset = " + currentOffset + " prevOffset = " + prevOffset + " offset = " + offset));
        }
        return currentOffset;
    }

    void moveHead(long offset) {
        if (!this.isEnabled()) {
            return;
        }
        this.moveHead(offset, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveHead(long newHeadOffset, long newHeadScn) {
        int proposedHead;
        if (!this.isEnabled()) {
            return;
        }
        boolean debugEnabled = LOG.isDebugEnabled();
        int blockNumber = -1;
        if (newHeadOffset < 0L) {
            if (this.head >= 0) {
                LOG.warn((Object)("track(ScnIndex.head): resetting head to -1: " + newHeadOffset));
            }
            proposedHead = -1;
        } else {
            blockNumber = this.getBlockNumber(newHeadOffset);
            proposedHead = blockNumber * 16;
        }
        this.acquireWriteLock();
        try {
            boolean moveTail;
            boolean bl = moveTail = newHeadScn >= 0L && this.head < this.tail && this.tail <= proposedHead || proposedHead >= this.tail && proposedHead < this.head;
            if (moveTail && blockNumber >= 0) {
                long oldHeadOfs;
                long oldHeadScn = this.head >= 0 ? this.getScn(this.head) : -1L;
                long l = oldHeadOfs = this.head >= 0 ? this.getOffset(this.head) : -1L;
                if (0 == proposedHead && this.head > 0) {
                    LOG.info((Object)("in:" + newHeadScn));
                }
                if (debugEnabled) {
                    LOG.debug((Object)("adjusting tail to match net head position; before: proposedHead=" + proposedHead + " newOfs=" + newHeadOffset + " newScn=" + newHeadScn + " oldScn=" + oldHeadScn + " oldOfs=" + oldHeadOfs));
                    LOG.debug((Object)this);
                }
                this.setScnOffset(blockNumber, newHeadScn, oldHeadScn == newHeadScn ? oldHeadOfs : newHeadOffset);
                if (debugEnabled) {
                    LOG.debug((Object)("adjusting tail to match net head position; after " + this));
                }
            }
            this.head = proposedHead;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("After move head: " + this));
            }
            if (this.head >= 0) {
                long oldHeadOfs = this.getOffset(this.head);
                if (oldHeadOfs != newHeadOffset) {
                    int i = this.head;
                    int n = this.size();
                    long curOfs = oldHeadOfs;
                    do {
                        this.buffer.putLong(i + 8, newHeadOffset);
                        if (this.buffer.limit() - (i += 16) < 16) {
                            i = 0;
                        }
                        if (--n <= 0) continue;
                        curOfs = this.getOffset(i);
                    } while (i != this.tail && n > 0 && curOfs == oldHeadOfs);
                }
            } else {
                this.tail = 0;
            }
            if (this._assertLevel.quickEnabled()) {
                this.assertHead();
                this.assertTail();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void assertEquals(String message, long exp, long actual, AssertLevel level) {
        if (this._assertLevel.getIntValue() < level.getIntValue()) {
            return;
        }
        if (exp != actual) {
            LOG.fatal((Object)("FAIL :" + message + ", Expected :" + exp + ", Actual :" + actual));
            throw new RuntimeException("FAIL :" + message + ", Expected :" + exp + ", Actual :" + actual);
        }
    }

    public void assertHeadPosition(long evbHead) {
        int blockNumber;
        if (!this.isEnabled()) {
            return;
        }
        long expHead = -1L;
        if (evbHead > 0L && (expHead = (long)((blockNumber = this.getBlockNumber(evbHead)) * 16)) != (long)this.head) {
            String msg = "SCN Index Head is (" + this.head + ") Expected Head was (" + expHead + ") Event Buffer Head is :" + evbHead;
            LOG.fatal((Object)msg);
            LOG.fatal((Object)"SCN Index is (assertHeadPosition):");
            this.printVerboseString(LOG, Level.FATAL);
            throw new RuntimeException(msg.toString());
        }
    }

    public void assertLastWrittenPos(BufferPosition evbStartPos) {
        int blockNumber;
        if (!this.isEnabled()) {
            return;
        }
        long expTail = -1L;
        long evbStartLoc = evbStartPos.getRealPosition();
        if (evbStartPos.getPosition() > 0L && !this.isFirstCheck && this.updatedOnCurrentWindow && (expTail = (long)((blockNumber = this.getBlockNumber(evbStartLoc)) * 16)) != (long)this.lastWrittenPosition) {
            StringBuilder msg = new StringBuilder();
            msg.append("SCN Index LWP is (" + this.lastWrittenPosition + ") Expected LWP was (" + expTail + ") Event Buffer Start Index is :" + evbStartPos);
            msg.append("SCN Index is(assertLastWrittenPos) :" + this.toString());
            msg.append("SCN at LWP: " + this.getScn(this.lastWrittenPosition) + ", Offset :" + this.positionParser.toString(this.getOffset(this.lastWrittenPosition)));
            LOG.fatal((Object)msg);
            throw new RuntimeException(msg.toString());
        }
        this.isFirstCheck = false;
    }

    private void smartVerbosePrint() {
        if (LOG.isDebugEnabled() || this.maxElements < 10000) {
            this.printVerboseString(LOG, Level.ERROR);
        }
    }

    private void assertTail() {
        if (this.empty()) {
            if (0 != this.tail) {
                throw new AssertionError((Object)("invalid empty tail: " + this.tail + "; state: " + this));
            }
        } else {
            if (0 > this.tail || this.maxElements * 16 <= this.tail) {
                throw new AssertionError((Object)("invalid tail: " + this.tail + "; state: " + this));
            }
            if (0 != this.tail % 16) {
                throw new AssertionError((Object)("tail not aligned: " + this.tail + "; state: " + this));
            }
        }
    }

    private void assertHead() {
        if (this.empty()) {
            if (this.head != -1) {
                throw new AssertionError((Object)("invalid empty head: " + this.head + "; state: " + this));
            }
        } else {
            if (0 != this.head % 16) {
                throw new AssertionError((Object)("head not aligned: " + this.head + "; state: " + this));
            }
            if (0 > this.head || this.maxElements * 16 <= this.head) {
                throw new AssertionError((Object)("invalid head: " + this.head + "; state: " + this));
            }
        }
    }

    private void assertOrder() {
        int sz = this.size();
        if (0 == sz) {
            return;
        }
        for (int i = 0; i < sz - 1; ++i) {
            long scn1 = this.getEntryScn(i);
            long scn2 = this.getEntryScn(i + 1);
            long ofs1 = this.getEntryOffset(i);
            long ofs2 = this.getEntryOffset(i + 1);
            if (scn1 > scn2) {
                this.smartVerbosePrint();
                throw new AssertionError((Object)("scn[" + i + "] = " + scn1 + " > " + scn2 + " = scn[" + (i + 1) + "]; \nstate:" + this));
            }
            if (scn1 == scn2) {
                if (ofs1 == ofs2) continue;
                this.smartVerbosePrint();
                throw new AssertionError((Object)("scn[" + i + "] = " + scn1 + " == " + scn2 + " = scn[" + (i + 1) + "] but ofs[" + i + "] = " + ofs1 + "!= " + ofs2 + " = ofs[" + (i + 1) + "]; \nstate:" + this));
            }
            if (ofs1 < ofs2) continue;
            this.smartVerbosePrint();
            throw new AssertionError((Object)("ofs[" + i + "] = " + ofs1 + " >= " + ofs2 + " = ofs[" + (i + 1) + "] but scn[" + i + "] = " + scn1 + " < " + scn2 + " = scn[" + (i + 1) + "]; \nstate:" + this));
        }
    }

    private void assertOffsets() {
        int sz = this.size();
        if (0 == sz) {
            return;
        }
        long minGen = Long.MAX_VALUE;
        long maxGen = Long.MIN_VALUE;
        int minGenIdx = -1;
        int maxGenIdx = -1;
        long minOfs = -1L;
        long maxOfs = 2L;
        int lastNewOfs = -1;
        int prevOfs = -1;
        for (int i = 0; i < sz; ++i) {
            int indexOfs = this.entryIndexOfs(i);
            long ofs1 = this.getOffset(indexOfs);
            long ofs_1 = prevOfs != -1 ? this.getOffset(prevOfs) : -1L;
            long gen1 = this.positionParser.bufferGenId(ofs1);
            long block1 = this.getBlockNumber(ofs1);
            int expBlock = -1;
            expBlock = i == 0 || ofs1 != ofs_1 ? indexOfs / 16 : lastNewOfs / 16;
            if (gen1 < minGen) {
                minGen = gen1;
                minGenIdx = i;
                minOfs = ofs1;
            }
            if (gen1 > maxGen) {
                maxGen = gen1;
                maxGenIdx = i;
                maxOfs = ofs1;
            }
            if ((long)expBlock != block1) {
                this.smartVerbosePrint();
                throw new AssertionError((Object)("block(offset[" + i + "]=" + ofs1 + ")=" + block1 + " != " + expBlock + "; state:" + this));
            }
            if (ofs1 != ofs_1) {
                lastNewOfs = indexOfs;
            }
            prevOfs = indexOfs;
        }
        if (maxGen - minGen > 1L) {
            this.smartVerbosePrint();
            throw new AssertionError((Object)("genId (ofs[" + minGenIdx + "]) + 1 = " + (minGen + 1L) + " < " + maxGen + " = genId(ofs[ " + maxGenIdx + "]); minOfs=" + minOfs + "->" + this.positionParser.toString(minOfs) + "; maxOfs=" + maxOfs + "->" + this.positionParser.toString(maxOfs) + "; \nstate:" + this));
        }
    }

    int getHead() {
        if (!this.isEnabled()) {
            throw new RuntimeException("ScnIndex not enabled");
        }
        return this.head;
    }

    int getTail() {
        if (!this.isEnabled()) {
            throw new RuntimeException("ScnIndex not enabled");
        }
        return this.tail;
    }

    BufferPositionParser getPositionParser() {
        if (!this.isEnabled()) {
            throw new RuntimeException("ScnIndex not enabled");
        }
        return this.positionParser;
    }

    public class ScnIndexEntry {
        private long _scn;
        private long _offset;

        public long getScn() {
            return this._scn;
        }

        public void setScn(long scn) {
            this._scn = scn;
        }

        public long getOffset() {
            return this._offset;
        }

        public void setOffset(long offset) {
            this._offset = offset;
        }

        public ScnIndexEntry(long scn, long offset) {
            this._scn = scn;
            this._offset = offset;
        }
    }
}

