/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import org.apache.log4j.Logger;

public class RelayEventTraceOption {
    public static final String MODULE = RelayEventTraceOption.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final Option _option;
    private final boolean _isAppendOnly;
    private final String _filename;
    private final boolean _isNeedFileSuffix;

    public RelayEventTraceOption(Option traceOption, String traceFilename, boolean isAppendOnly, boolean needFileSuffix) {
        this._option = traceOption;
        this._filename = traceFilename;
        this._isAppendOnly = isAppendOnly;
        this._isNeedFileSuffix = needFileSuffix;
    }

    public RelayEventTraceOption(Option traceOption) {
        this(traceOption, null, false, false);
    }

    public Option getOption() {
        return this._option;
    }

    public String getFilename() {
        return this._filename;
    }

    public boolean isAppendOnly() {
        return this._isAppendOnly;
    }

    public boolean isNeedFileSuffix() {
        return this._isNeedFileSuffix;
    }

    public static class RelayEventTraceOptionBuilder
    implements ConfigBuilder<RelayEventTraceOption> {
        public static final String DEFAULT_TRACE_OPTION_FILENAME = "databus_relay_event_trace";
        private String _option;
        private boolean _isAppendOnly;
        private String _filename;
        private boolean _isNeedFileSuffix;

        public RelayEventTraceOptionBuilder() {
            this._option = Option.none.toString();
            this._isAppendOnly = false;
            this._isNeedFileSuffix = false;
            this._filename = DEFAULT_TRACE_OPTION_FILENAME;
        }

        public RelayEventTraceOptionBuilder(RelayEventTraceOptionBuilder other) {
            this._option = other._option;
            this._isAppendOnly = other._isAppendOnly;
            this._filename = other._filename;
            this._isNeedFileSuffix = other._isNeedFileSuffix;
        }

        public String getOption() {
            return this._option;
        }

        public boolean isAppendOnly() {
            return this._isAppendOnly;
        }

        public boolean isNeedFileSuffix() {
            return this._isNeedFileSuffix;
        }

        public String getFilename() {
            return this._filename;
        }

        public void setOption(String option) {
            this._option = option;
        }

        public void setAppendOnly(boolean _isAppendOnly) {
            this._isAppendOnly = _isAppendOnly;
        }

        public void setNeedFileSuffix(boolean needFileSuffix) {
            this._isNeedFileSuffix = needFileSuffix;
        }

        public void setFilename(String _filename) {
            this._filename = _filename;
        }

        @Override
        public RelayEventTraceOption build() throws InvalidConfigException {
            LOG.info((Object)("Relay event trace option: " + this._option));
            LOG.info((Object)("Relay event trace filename: " + this._filename));
            LOG.info((Object)("Relay event trace file append only: " + this._isAppendOnly));
            LOG.info((Object)("Relay event trace need file suffix: " + this._isNeedFileSuffix));
            return new RelayEventTraceOption(Option.valueOf(this._option), this._filename, this._isAppendOnly, this._isNeedFileSuffix);
        }
    }

    public static enum Option {
        none,
        file;

    }
}

