/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.Encoding;
import com.linkedin.databus.core.InternalDatabusEventsListenerAbstract;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;

public class FileBasedEventTrackingCallback
extends InternalDatabusEventsListenerAbstract {
    public static final String MODULE = FileBasedEventTrackingCallback.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private String _filename;
    protected FileChannel _writeChannel;
    private boolean _append;
    private FileOutputStream _file;

    public FileBasedEventTrackingCallback(String filename, boolean append) {
        this(filename, append, 0);
    }

    public FileBasedEventTrackingCallback(String filename, boolean append, int numEventsPerBatch) {
        this._append = append;
        this._filename = filename;
        LOG.info((Object)(MODULE + " using " + filename + " for event tracking"));
        LOG.info((Object)(MODULE + " append-only mode is set to " + append));
    }

    public void init() throws IOException {
        this.openFile(this._filename);
    }

    public void openFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (!this._append) {
            file.createNewFile();
        }
        this._file = new FileOutputStream(file, this._append);
        this._writeChannel = this._file.getChannel();
    }

    @Override
    public void close() throws IOException {
        LOG.info((Object)("closing " + this._filename));
        this._writeChannel.force(true);
        this._writeChannel.close();
        this._file.close();
    }

    public void endEvents() {
        try {
            this.close();
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Couldn't endEvents for " + this._file), (Throwable)ioe);
        }
    }

    @Override
    public void onEvent(DbusEvent event, long offset, int size) {
        this.onEvent(event);
    }

    public void onEvent(DbusEvent event) {
        if (!event.isEndOfPeriodMarker()) {
            DbusEventInternalReadable dBusEvent = (DbusEventInternalReadable)event;
            dBusEvent.writeTo(this._writeChannel, Encoding.JSON);
        }
    }
}

