/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventInternalWritable;
import com.linkedin.databus.core.Encoding;
import com.linkedin.databus.core.InternalDatabusEventsListenerAbstract;
import com.linkedin.databus.core.InvalidEventException;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

@Deprecated
public class EventLogReader
extends InternalDatabusEventsListenerAbstract {
    public static final String MODULE = EventLogReader.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final boolean _enabled;
    private final DbusEventBuffer _eventBuffer;
    private final File _topLevelLogDir;
    private final File _readSessionDir;
    private final ArrayList<File> _filesToRead;
    private boolean _eventSeen;
    private String _firstEventContent;
    private long _lastEopOffset;
    long _firstEventSequence;

    public EventLogReader(boolean enabled, DbusEventBuffer eventBuffer, File topLevelLogDir, File readSessionDir) {
        this._enabled = enabled;
        this._eventBuffer = eventBuffer;
        this._topLevelLogDir = topLevelLogDir;
        this._readSessionDir = readSessionDir;
        this._filesToRead = new ArrayList();
        if (this._readSessionDir == null) {
            LOG.warn((Object)("EventLogReader did not find any pre-existing logs to read from, no directories under writeDir:" + this._topLevelLogDir));
        } else {
            if (this._readSessionDir.listFiles().length > 0) {
                Encoding encoding = this.getEncoding(this._readSessionDir.listFiles()[0]);
                for (File f : this._readSessionDir.listFiles()) {
                    LOG.info((Object)f.getAbsolutePath());
                    if (this.getEncoding(f) != encoding) {
                        LOG.error((Object)("Encoding " + (Object)((Object)encoding) + " did not match encoding for File " + f.getAbsolutePath()));
                        continue;
                    }
                    this._filesToRead.add(f);
                }
            }
            Collections.sort(this._filesToRead, new LastModifiedSorter());
            this._eventSeen = false;
            this._firstEventContent = null;
            this._lastEopOffset = -1L;
            LOG.info((Object)("Configured with top-level log Directory :" + this._topLevelLogDir.getAbsolutePath()));
            LOG.info((Object)("Inferred read-session directory :" + this._readSessionDir.getAbsolutePath()));
            if (this._filesToRead.size() == 0) {
                LOG.warn((Object)("EventLogReader did not find any pre-existing logs to read from, no files under read session Dir:" + this._readSessionDir));
            }
        }
    }

    public EventLogReader(StaticConfig staticConfig) {
        this(staticConfig.isEnabled(), staticConfig.getEventBuffer(), staticConfig.getTopLevelLogDir(), staticConfig.getReadSessionDir());
    }

    private Encoding getEncoding(File f) {
        if (f.getAbsolutePath().endsWith(".bin")) {
            return Encoding.BINARY;
        }
        if (f.getAbsolutePath().endsWith(".json")) {
            return Encoding.JSON;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Checkpoint read() {
        Checkpoint checkPoint = new Checkpoint();
        checkPoint.setFlexible();
        if (this._enabled) {
            this._eventBuffer.addInternalListener(checkPoint);
            this._eventBuffer.addInternalListener(this);
            if (this._filesToRead != null) {
                for (File f : this._filesToRead) {
                    FileChannel readChannel = null;
                    try {
                        readChannel = new FileInputStream(f).getChannel();
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    int numEvents = 0;
                    try {
                        numEvents = this._eventBuffer.readEvents((ReadableByteChannel)readChannel, this.getEncoding(f));
                    }
                    catch (InvalidEventException e) {
                        e.printStackTrace();
                    }
                    LOG.info((Object)("Read " + numEvents + " events"));
                }
                this._eventBuffer.removeInternalListener(checkPoint);
                this._eventBuffer.removeInternalListener(this);
                LOG.info((Object)("Checkpoint = " + checkPoint));
                if (this._eventSeen) {
                    DbusEventInternalWritable event;
                    DbusEventBuffer.DbusEventIterator iter = this._eventBuffer.acquireIterator("EventLogReader:firstEvent");
                    try {
                        long result;
                        event = iter.next();
                        String firstEventContent = event.toString();
                        if (this._firstEventContent.equalsIgnoreCase(firstEventContent) && !event.isEndOfPeriodMarker() && (result = this._eventBuffer.deleteFirstWindow()) < 0L) {
                            throw new RuntimeException("eventBuffer could not delete first window");
                        }
                    }
                    finally {
                        this._eventBuffer.releaseIterator(iter);
                    }
                    if (this._lastEopOffset >= 0L) {
                        DbusEventBuffer dbusEventBuffer = this._eventBuffer;
                        dbusEventBuffer.getClass();
                        iter = dbusEventBuffer.new DbusEventBuffer.DbusEventIterator(this._lastEopOffset, this._eventBuffer.getTail(), "EventLogReader:lastEOP");
                        try {
                            event = iter.next();
                            if (!event.isEndOfPeriodMarker()) {
                                throw new RuntimeException("Tried reading end of period marker, but failed");
                            }
                            if (iter.hasNext()) {
                                this._eventBuffer.setTail(iter.getCurrentPosition());
                            }
                        }
                        catch (NoSuchElementException e) {
                            LOG.error((Object)("NoSuchElementException at : " + this._eventBuffer.getBufferPositionParser().toString(this._lastEopOffset)));
                            throw e;
                        }
                        finally {
                            this._eventBuffer.releaseIterator(iter);
                        }
                    }
                }
            }
        }
        return checkPoint;
    }

    @Override
    public void onEvent(DbusEvent event, long offset, int size) {
        if (!this._eventSeen) {
            this._firstEventContent = event.toString();
            this._eventSeen = true;
            this._firstEventSequence = event.sequence();
        }
        if (event.isEndOfPeriodMarker()) {
            this._lastEopOffset = offset;
        }
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        public static final boolean DEFAULT_ENABLED = false;
        public static final String DEFAULT_TOP_LEVEL_LOG_DIR = "eventLog";
        public static final String DEFAULT_READ_SESSION_DIR = null;
        protected DbusEventBuffer _eventBuffer;
        protected boolean _enabled;
        protected String _topLevelLogDir;
        protected String _readSessionDir;

        public Config() {
            this._enabled = false;
            this._topLevelLogDir = DEFAULT_TOP_LEVEL_LOG_DIR;
            this._readSessionDir = DEFAULT_READ_SESSION_DIR;
        }

        public Config(Config other) {
            this._eventBuffer = other._eventBuffer;
            this._enabled = other._enabled;
            this._topLevelLogDir = other._topLevelLogDir;
            this._readSessionDir = other._readSessionDir;
        }

        public DbusEventBuffer getEventBuffer() {
            return this._eventBuffer;
        }

        public void setEventBuffer(DbusEventBuffer eventBuffer) {
            this._eventBuffer = eventBuffer;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public String getTopLevelLogDir() {
            return this._topLevelLogDir;
        }

        public void setTopLevelLogDir(String topLevelLogDir) {
            this._topLevelLogDir = topLevelLogDir;
        }

        public String getReadSessionDir() {
            return this._readSessionDir;
        }

        public void setReadSessionDir(String readSessionDir) {
            this._readSessionDir = readSessionDir;
        }

        @Override
        public StaticConfig build() throws InvalidConfigException {
            LOG.info((Object)("Event Log Reader enabled : " + this._enabled));
            File topLevelLogDir = new File(this._topLevelLogDir);
            if (topLevelLogDir.exists() && !topLevelLogDir.canRead()) {
                throw new InvalidConfigException("Invalid Config value : Cannot read from top level log dir: " + this._topLevelLogDir);
            }
            if (this._readSessionDir == null) {
                File[] allFiles = topLevelLogDir.listFiles();
                long newestTime = 0L;
                File readSessionDir = null;
                if (allFiles != null) {
                    for (File f : allFiles) {
                        if (!f.isDirectory() || f.lastModified() <= newestTime) continue;
                        newestTime = f.lastModified();
                        readSessionDir = f;
                    }
                }
                if (readSessionDir != null) {
                    this._readSessionDir = readSessionDir.getAbsolutePath();
                }
            }
            return new StaticConfig(this._eventBuffer, this._enabled, this._topLevelLogDir, this._readSessionDir);
        }
    }

    public static class StaticConfig {
        protected DbusEventBuffer _eventBuffer;
        private final boolean _enabled;
        private final File _topLevelLogDir;
        private final File _readSessionDir;
        private EventLogReader _existingLogReader;

        public StaticConfig(DbusEventBuffer eventBuffer, boolean enabled, String topLevelLogDir, String readSessionDir) {
            this._eventBuffer = eventBuffer;
            this._enabled = enabled;
            this._topLevelLogDir = new File(topLevelLogDir);
            this._readSessionDir = readSessionDir != null ? new File(readSessionDir) : null;
        }

        public DbusEventBuffer getEventBuffer() {
            return this._eventBuffer;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public File getTopLevelLogDir() {
            return this._topLevelLogDir;
        }

        public File getReadSessionDir() {
            return this._readSessionDir;
        }

        public EventLogReader getOrCreateEventLogReader(DbusEventBuffer eventBuffer) {
            this._eventBuffer = eventBuffer;
            this._existingLogReader = new EventLogReader(this);
            return this._existingLogReader;
        }
    }

    private class LastModifiedSorter
    implements Comparator<File> {
        private LastModifiedSorter() {
        }

        @Override
        public int compare(File o1, File o2) {
            return (int)(o1.lastModified() - o2.lastModified());
        }
    }
}

