/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DbusPrettyLogUtils {
    public static void logAtLevel(String msg, Throwable t, Logger log, Level level) {
        switch (level.toInt()) {
            case 20000: {
                DbusPrettyLogUtils.logExceptionAtInfo(msg, t, log);
                break;
            }
            case 30000: {
                DbusPrettyLogUtils.logExceptionAtWarn(msg, t, log);
                break;
            }
            case 40000: {
                DbusPrettyLogUtils.logExceptionAtError(msg, t, log);
                break;
            }
            default: {
                DbusPrettyLogUtils.logExceptionAtInfo(msg, t, log);
            }
        }
    }

    public static void logExceptionAtInfo(String msg, Throwable t, Logger log) {
        if (null == log) {
            return;
        }
        if (t == null) {
            log.info((Object)msg);
        } else {
            log.info((Object)(msg + ". Exception message = " + t + ". Exception cause = " + t.getCause()));
            if (log.isDebugEnabled()) {
                log.debug((Object)". Exception trace = ", t);
            }
        }
    }

    public static void logExceptionAtWarn(String msg, Throwable t, Logger log) {
        if (null == log) {
            return;
        }
        if (null == t) {
            log.warn((Object)msg);
        } else {
            log.warn((Object)(msg + ". Exception message = " + t + ". Exception cause = " + t.getCause()));
            if (log.isDebugEnabled()) {
                log.debug((Object)". Exception trace = ", t);
            }
        }
    }

    public static void logExceptionAtDebug(String msg, Throwable t, Logger log) {
        if (null == log || !log.isDebugEnabled()) {
            return;
        }
        if (null == t) {
            log.debug((Object)msg);
        } else {
            log.debug((Object)(msg + ". Exception message = " + t + ". Exception cause = " + t.getCause()));
            log.debug((Object)". Exception trace = ", t);
        }
    }

    public static void logExceptionAtError(String msg, Throwable t, Logger log) {
        if (null == log) {
            return;
        }
        if (null == t) {
            log.error((Object)msg);
        } else {
            log.error((Object)(msg + ". Exception message = " + t + ". Exception cause = " + t.getCause()));
            if (log.isDebugEnabled()) {
                log.debug((Object)". Exception trace = ", t);
            }
        }
    }
}

