/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DbusPrettyLogUtils;
import java.util.IllegalFormatException;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DbusLogAccumulator {
    public static final int MAX_NUMBER_OF_LOG_MSGS = 256;
    private int _totalNumberOfMsgs;
    private final CircularFifoBuffer _msgs;

    @Deprecated
    public static void addLog(String s, Logger log) {
        if (null == log) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)s);
        }
    }

    public DbusLogAccumulator() {
        this(256);
    }

    public DbusLogAccumulator(int maxNumberMsgs) {
        this._msgs = new CircularFifoBuffer(maxNumberMsgs);
        this.reset();
    }

    public void reset() {
        this._msgs.clear();
        this._totalNumberOfMsgs = 0;
    }

    public void addMessage(String msg) {
        this.addMessage(new DebugMessage(msg));
    }

    public void addMessage(String format, Object val) {
        this.addMessage(new DebugMessage(format, val));
    }

    public void addMessage(DebugMessage msg) {
        this._msgs.add((Object)msg);
        ++this._totalNumberOfMsgs;
    }

    public int getTotalNumberOfMessages() {
        return this._totalNumberOfMsgs;
    }

    public int getNumberOfMessages() {
        return this._msgs.size();
    }

    public void prettyLog(Logger log, Level level) {
        for (Object o : this._msgs) {
            DebugMessage dm = (DebugMessage)o;
            String msg = dm.toString();
            Throwable t = dm.getException();
            DbusPrettyLogUtils.logAtLevel(msg, t, log, level);
        }
    }

    public static class DebugMessage {
        private final String _format;
        private final Object[] _params;
        private Throwable _exception;

        public DebugMessage(String format, Object ... params) {
            this._format = format;
            this._params = params;
            this._exception = null;
        }

        public DebugMessage(String msg) {
            this(null, msg);
        }

        public DebugMessage setException(Throwable e) {
            this._exception = e;
            return this;
        }

        public Throwable getException() {
            return this._exception;
        }

        public String toString() {
            if (this._format != null) {
                try {
                    return String.format(this._format, this._params);
                }
                catch (IllegalFormatException e) {
                    return "failed to format with " + this._format + ":" + e.getMessage();
                }
            }
            if (this._params[0] == null) {
                return "null";
            }
            return this._params[0].toString();
        }
    }
}

