/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusPartitionId;
import com.linkedin.databus.core.DbusPartitionRouter;
import com.linkedin.databus.core.util.FnvHashFunction;
import com.linkedin.databus.core.util.HashFunction;
import com.linkedin.databus.core.util.JenkinsHashFunction;

public class DbusHashPartitionRouter
implements DbusPartitionRouter {
    private final HashFunction _hash;
    private final int _numBuckets;

    public DbusHashPartitionRouter(String hashConf, int numBuckets) {
        this._numBuckets = numBuckets;
        this._hash = this.getHashFunction(hashConf);
    }

    private HashFunction getHashFunction(String hashConf) {
        HashType hashType = HashType.valueOf(hashConf);
        HashFunction fun = null;
        switch (hashType) {
            case FNV: {
                fun = new FnvHashFunction();
                break;
            }
            case JENKINS: {
                fun = new JenkinsHashFunction();
                break;
            }
            default: {
                throw new RuntimeException("Unknown Hash Type :" + hashConf);
            }
        }
        return fun;
    }

    @Override
    public DbusPartitionId getPartitionId(DbusEvent event) {
        boolean isKeyNumber = event.isKeyNumber();
        long partition = 0L;
        if (isKeyNumber) {
            long key = event.key();
            partition = this._hash.hash(key, this._numBuckets);
        } else {
            byte[] bytes = event.keyBytes();
            partition = this._hash.hash(bytes, this._numBuckets);
        }
        int part = (int)partition;
        DbusPartitionId partitionId = new DbusPartitionId(part);
        return partitionId;
    }

    public static enum HashType {
        FNV,
        JENKINS;

    }
}

