/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventInfo;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventInternalWritable;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.DbusEventV2;
import com.linkedin.databus.core.KeyTypeNotImplementedException;
import com.linkedin.databus.core.UnsupportedDbusEventVersionRuntimeException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;

public class DbusEventV2Factory
extends DbusEventFactory {
    public static final Logger LOG = Logger.getLogger((String)"DbusEventV2Factory");

    public DbusEventV2Factory() {
        this(ByteOrder.BIG_ENDIAN);
    }

    public DbusEventV2Factory(ByteOrder byteOrder) {
        super(byteOrder);
        LOG.info((Object)byteOrder);
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                sb.append("\n\t").append(ste);
            }
            LOG.info((Object)sb);
        }
    }

    @Override
    public byte getVersion() {
        return 2;
    }

    @Override
    public DbusEventInternalWritable createWritableDbusEvent() {
        return new DbusEventV2();
    }

    @Override
    public int serializeLongKeyEndOfPeriodMarker(ByteBuffer serializationBuffer, DbusEventInfo eventInfo) {
        if (serializationBuffer.order() != this.getByteOrder()) {
            throw new DatabusRuntimeException("ByteBuffer byte-order mismatch [DbusEventV2Factory.serializeLongKeyEndOfPeriodMarker()]");
        }
        if (eventInfo.getEventSerializationVersion() != 2) {
            throw new UnsupportedDbusEventVersionRuntimeException(eventInfo.getEventSerializationVersion());
        }
        return DbusEventV2.serializeEvent(DbusEventInternalWritable.EOPMarkerKey, serializationBuffer, eventInfo);
    }

    @Override
    public DbusEventInternalReadable createLongKeyEOPEvent(long seq, short partN) {
        ByteBuffer buf = DbusEventV2.serializeEndOfPeriodMarker(seq, partN, this.getByteOrder());
        return this.createReadOnlyDbusEventFromBuffer(buf, 0);
    }

    @Override
    protected DbusEventInternalReadable createLongKeyControlEvent(long sequence, short srcId, String msg) {
        DbusEventInfo eventInfo;
        try {
            byte[] payload = msg.getBytes("UTF-8");
            eventInfo = new DbusEventInfo(null, sequence, -1, 0, System.nanoTime(), srcId, DbusEventInternalWritable.emptyMd5, payload, false, true, 2, 0, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new DatabusRuntimeException("Non-UTF-8 characters in control event: " + msg, e);
        }
        DbusEventKey key = DbusEventInternalWritable.ZeroLongKeyObject;
        try {
            int evtLen = DbusEventV2Factory.computeEventLength(key, eventInfo);
            ByteBuffer tmpBuffer = ByteBuffer.allocate(evtLen).order(this.getByteOrder());
            DbusEventV2Factory.serializeEvent(key, tmpBuffer, eventInfo);
            return this.createReadOnlyDbusEventFromBuffer(tmpBuffer, 0);
        }
        catch (KeyTypeNotImplementedException e) {
            throw new DatabusRuntimeException("Unexpected exception on key " + key, e);
        }
    }
}

