/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core;

import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventInfo;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusEventInternalWritable;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.DbusEventPart;
import com.linkedin.databus.core.DbusEventSerializable;
import com.linkedin.databus.core.DbusEventUtils;
import com.linkedin.databus.core.DbusEventV1;
import com.linkedin.databus.core.DbusEventV1Factory;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus.core.KeyTypeNotImplementedException;
import com.linkedin.databus.core.util.ByteBufferCRC32;
import com.linkedin.databus.core.util.StringUtils;
import com.linkedin.databus.core.util.Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class DbusEventV2
extends DbusEventSerializable {
    public static final String MODULE = DbusEventV2.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private static final int VersionOffset = 0;
    private static final int MagicOffset = 1;
    private static final int HeaderLenOffset = 5;
    private static final int HeaderCrcOffset = 9;
    private static final int BodyCrcOffset = 13;
    private static final int TotalLenOffset = 17;
    private static final int AttributesOffset = 21;
    private static final int TimestampOffset = 23;
    private static final int SourceIdOffset = 31;
    private static final int PartitionIdOffset = 35;
    private static final int SequenceOffset = 37;
    private static final int FixedHeaderLen = 45;
    private static final int StringKeyLengthOffset = 45;
    private static final int StringKeyLengthSize = 4;
    private static final int LongKeyOffset = 45;
    private static final int LongKeyLength = 8;
    private static final int SchemaKeyOffset = 45;
    private static final short KEY_TYPE_MASK = 12;
    private static final short KEY_TYPE_SHIFT = 2;
    private static final short LONG_KEY_TYPE = 1;
    private static final short STRING_KEY_TYPE = 2;
    private static final short SCHEMA_KEY_TYPE = 3;
    private static final short OPCODE_MASK = 3;
    private static final int DELETE_OP_CODE = 2;
    private static final int UPSERT_OP_CODE = 1;
    private static final int CONTROL_EVENT_OP_CODE = 0;
    private static final short FLAG_IS_REPLICATED = 16;
    private static final short FLAG_TRACE_ON = 32;
    private static final short FLAG_HAS_PAYLOAD_METADATA_PART = 64;
    private static final short FLAG_HAS_PAYLOAD_PART = 128;
    private static final int MAGIC = -889266451;

    public DbusEventV2() {
        this._inited = false;
    }

    public DbusEventV2(ByteBuffer buf, int position) {
        this.resetInternal(buf, position);
    }

    @Override
    public void setSequence(long sequence) {
        this._buf.putLong(this._position + 37, sequence);
    }

    @Override
    public void applyCrc() {
        long headerCrc = ByteBufferCRC32.getChecksum(this._buf, this._position + 13, this.numBytesForHeaderCrc());
        Utils.putUnsignedInt(this._buf, this._position + 9, headerCrc);
    }

    @Override
    public void setSize(int sz) {
        this._buf.putInt(this._position + 17, sz);
    }

    @Override
    public void setHeaderCrc(long crc) {
        Utils.putUnsignedInt(this._buf, this._position + 9, crc);
    }

    @Override
    public void setValue(byte[] bytes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setValueCrc(long crc) {
        Utils.putUnsignedInt(this._buf, this._position + 13, crc);
    }

    @Override
    public DbusEvent clone(DbusEvent e) {
        DbusEventV2 reuse = (DbusEventV2)e;
        if (null == reuse) {
            reuse = new DbusEventV2(this._buf, this._position);
        } else {
            if (!(e instanceof DbusEventV2)) {
                throw new UnsupportedClassVersionError("Unsupported class:" + e.getClass().getSimpleName());
            }
            reuse.resetInternal(this._buf, this._position);
        }
        return reuse;
    }

    @Override
    public void setSrcId(int srcId) {
        this._buf.putInt(this._position + 31, srcId);
    }

    @Override
    public void setSchemaId(byte[] payloadSchemaId) {
        int payloadPartPosition = this.payloadPartPosition();
        if (payloadPartPosition == -1) {
            throw new DatabusRuntimeException("No payload in which to set schema ID");
        }
        DbusEventPart.replaceSchemaDigest(this._buf, payloadPartPosition, payloadSchemaId);
    }

    @Override
    public void recomputeCrcsAfterEspressoRewrite() {
        long valueCrc = this.getCalculatedValueCrc();
        this.setValueCrc(valueCrc);
        this.applyCrc();
    }

    @Override
    public DbusEventInternalReadable reset(ByteBuffer buf, int position) {
        if (buf.get(position) != 2) {
            this.verifyByteOrderConsistency(buf, "DbusEventV2.reset()");
            return DbusEventV1Factory.createReadOnlyDbusEventFromBufferUnchecked(buf, position);
        }
        this.resetInternal(buf, position);
        return this;
    }

    @Override
    public long headerCrc() {
        return Utils.getUnsignedInt(this._buf, this._position + 9);
    }

    @Override
    public DbusEventInternalReadable.EventScanStatus scanEvent(boolean logErrors) {
        long bodyCrc;
        int eventLengthFromHeader;
        DbusEventInternalReadable.HeaderScanStatus h = this.scanHeader(logErrors);
        if (h != DbusEventInternalReadable.HeaderScanStatus.OK) {
            return h == DbusEventInternalReadable.HeaderScanStatus.ERR ? DbusEventInternalReadable.EventScanStatus.ERR : DbusEventInternalReadable.EventScanStatus.PARTIAL;
        }
        int bytesInBuffer = this._buf.limit() - this._position;
        if (bytesInBuffer < (eventLengthFromHeader = this._buf.getInt(this._position + 17))) {
            return DbusEventInternalReadable.EventScanStatus.PARTIAL;
        }
        long calculatedBodyCrc = this.getCalculatedValueCrc();
        if (calculatedBodyCrc != (bodyCrc = this.bodyCrc())) {
            if (logErrors) {
                LOG.error((Object)("bodyCrcInEvent = " + bodyCrc));
                LOG.error((Object)(",calculatedBodyCrc = " + calculatedBodyCrc));
                LOG.error((Object)(",crc-ed block size = " + this.valueLength()));
                LOG.error((Object)(",event sequence = " + this.sequence()));
                LOG.error((Object)(",timestamp = " + this.timestampInNanos()));
            }
            return DbusEventInternalReadable.EventScanStatus.ERR;
        }
        return DbusEventInternalReadable.EventScanStatus.OK;
    }

    @Override
    public int payloadLength() {
        return this.valueLength();
    }

    @Override
    public long bodyCrc() {
        return Utils.getUnsignedInt(this._buf, this._position + 13);
    }

    private int bodyLength() {
        return this._buf.getInt(this._position + 17) - this.headerLength();
    }

    @Override
    public long getCalculatedValueCrc() {
        return ByteBufferCRC32.getChecksum(this._buf, this._position + this.headerLength(), this.bodyLength());
    }

    @Override
    public DbusEventInternalWritable createCopy() {
        throw new UnsupportedOperationException("Not imeplemented");
    }

    @Override
    public short schemaVersion() {
        DbusEventPart payloadPart = this.getPayloadPart();
        if (payloadPart == null) {
            return 0;
        }
        return payloadPart.getSchemaVersion();
    }

    private int headerLength() {
        return this._buf.getInt(this._position + 5);
    }

    @Override
    protected DbusEventInternalReadable.HeaderScanStatus scanHeader(boolean logErrors) {
        int bytesInBuffer;
        if (this.getVersion() != 2 && logErrors) {
            LOG.error((Object)("Incorrect version byte in header:" + this.getVersion()));
        }
        if ((bytesInBuffer = this._buf.limit() - this._position) < 9) {
            return DbusEventInternalReadable.HeaderScanStatus.PARTIAL;
        }
        if (this.headerLength() < 45 && logErrors) {
            LOG.error((Object)("Header length too small:" + this.headerLength()));
        }
        if (bytesInBuffer < this.headerLength()) {
            return DbusEventInternalReadable.HeaderScanStatus.PARTIAL;
        }
        long calculatedHeaderCrc = this.getCalculatedHeaderCrc();
        if (calculatedHeaderCrc != this.headerCrc()) {
            if (logErrors) {
                LOG.error((Object)("Header CRC mismatch: Calculated:" + calculatedHeaderCrc + ",found:" + this.headerCrc()));
            }
            return DbusEventInternalReadable.HeaderScanStatus.ERR;
        }
        return DbusEventInternalReadable.HeaderScanStatus.OK;
    }

    @Override
    protected boolean isPartial() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public byte getVersion() {
        return this._buf.get(this._position + 0);
    }

    @Override
    public int getMagic() {
        return this._buf.getInt(this._position + 1);
    }

    @Override
    public boolean isExtReplicatedEvent() {
        return this.isAttributeSet((short)16);
    }

    private short getKeyTypeAttribute() {
        return this._buf.getShort(this._position + 21);
    }

    @Override
    public boolean isKeyNumber() {
        return this.getKeyType(this.getKeyTypeAttribute()) == DbusEventKey.KeyType.LONG;
    }

    @Override
    public boolean isKeyString() {
        return this.getKeyType(this.getKeyTypeAttribute()) == DbusEventKey.KeyType.STRING;
    }

    @Override
    public boolean isKeySchema() {
        return this.getKeyType(this.getKeyTypeAttribute()) == DbusEventKey.KeyType.SCHEMA;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isAttributeSet((short)32);
    }

    private boolean hasPayloadPart() {
        return this.isAttributeSet((short)128);
    }

    private boolean hasMetadata() {
        return this.isAttributeSet((short)64);
    }

    @Override
    public DbusOpcode getOpcode() {
        return this.getOpCode(this._buf.getShort(this._position + 21));
    }

    @Override
    public long timestampInNanos() {
        return this._buf.getLong(this._position + 23);
    }

    @Override
    public int size() {
        return this._buf.getInt(this._position + 17);
    }

    @Override
    public long sequence() {
        return this._buf.getLong(this._position + 37);
    }

    @Override
    public long key() {
        assert (this.isKeyNumber());
        return this._buf.getLong(this._position + 45);
    }

    @Override
    public int keyLength() {
        throw new UnsupportedOperationException("DbusEvent.keyLength() is deprecated");
    }

    @Override
    public int keyBytesLength() {
        assert (this.isKeyString()) : "Key type not string = " + (Object)((Object)this.getKeyType(this.getKeyTypeAttribute()));
        return this._buf.getInt(this._position + 45);
    }

    @Override
    public byte[] keyBytes() {
        assert (this.isKeyString()) : "Key type = " + (Object)((Object)this.getKeyType(this.getKeyTypeAttribute()));
        int strKeyLen = this.keyBytesLength();
        byte[] dst = new byte[strKeyLen];
        int offsetToCopyFrom = 49;
        for (int i = 0; i < strKeyLen; ++i) {
            dst[i] = this._buf.get(this._position + offsetToCopyFrom + i);
        }
        return dst;
    }

    @Override
    public short srcId() {
        int srcId = this.getSourceId();
        assert (srcId <= Short.MAX_VALUE) : "Source ID = " + srcId + " not handled by caller";
        return (short)srcId;
    }

    @Override
    public int getSourceId() {
        return this._buf.getInt(this._position + 31);
    }

    @Override
    public short physicalPartitionId() {
        return this._buf.getShort(this._position + 35);
    }

    @Override
    public short logicalPartitionId() {
        return this._buf.getShort(this._position + 35);
    }

    @Override
    public short getPartitionId() {
        return this.physicalPartitionId();
    }

    @Override
    public byte[] schemaId() {
        DbusEventPart payloadPart = this.getPayloadPart();
        if (payloadPart == null) {
            return null;
        }
        return payloadPart.getSchemaDigest();
    }

    @Override
    public void schemaId(byte[] md5) {
        DbusEventPart payloadPart = this.getPayloadPart();
        if (payloadPart == null) {
            return;
        }
        byte[] srcBytes = payloadPart.getSchemaDigest();
        for (int i = 0; i < 16; ++i) {
            md5[i] = srcBytes[i];
        }
    }

    private int payloadPartPosition() {
        if (!this.hasPayloadPart()) {
            return -1;
        }
        int payloadPartPosition = this._position + this.headerLength();
        if (this.hasMetadata()) {
            payloadPartPosition += DbusEventPart.partLength(this._buf, payloadPartPosition);
        }
        return payloadPartPosition;
    }

    @Override
    public int valueLength() {
        if (!this.hasPayloadPart()) {
            return 0;
        }
        return this._buf.getInt(this.payloadPartPosition());
    }

    @Override
    public ByteBuffer value() {
        DbusEventPart payloadPart = this.getPayloadPart();
        if (payloadPart == null) {
            return null;
        }
        return payloadPart.getData();
    }

    @Override
    public DbusEventPart getPayloadPart() {
        int payloadPartPosition = this.payloadPartPosition();
        if (payloadPartPosition == -1) {
            return null;
        }
        return this.getDbusEventPart(payloadPartPosition);
    }

    @Override
    public DbusEventPart getPayloadMetadataPart() {
        if (!this.hasMetadata()) {
            return null;
        }
        return this.getDbusEventPart(this._position + this.headerLength());
    }

    @Override
    public DbusEventPart getKeyPart() {
        assert (this.isKeySchema()) : "Key type = " + (Object)((Object)this.getKeyType(this.getKeyTypeAttribute()));
        return this.getDbusEventPart(this._position + 45);
    }

    private DbusEventPart getDbusEventPart(int dbusEventPartStartPos) {
        ByteBuffer dbusEventPartBB = this._buf.asReadOnlyBuffer().order(this._buf.order());
        dbusEventPartBB.position(dbusEventPartStartPos);
        DbusEventPart dbusEventPart = DbusEventPart.decode(dbusEventPartBB);
        return dbusEventPart;
    }

    private DbusEventKey.KeyType getKeyType(short attributes) {
        switch ((attributes & 0xC) >> 2) {
            case 1: {
                return DbusEventKey.KeyType.LONG;
            }
            case 2: {
                return DbusEventKey.KeyType.STRING;
            }
            case 3: {
                return DbusEventKey.KeyType.SCHEMA;
            }
        }
        throw new DatabusRuntimeException("Unexpected attribute value:" + attributes);
    }

    private DbusOpcode getOpCode(short attributes) {
        switch (attributes & 3) {
            case 1: {
                return DbusOpcode.UPSERT;
            }
            case 2: {
                return DbusOpcode.DELETE;
            }
            case 0: {
                return null;
            }
        }
        throw new DatabusRuntimeException("Unexpected op code " + (attributes & 3));
    }

    private int numBytesForHeaderCrc() {
        return this._buf.getInt(this._position + 5) - 13;
    }

    private boolean isAttributeSet(short attribute) {
        return (this._buf.getShort(this._position + 21) & attribute) == attribute;
    }

    private long getCalculatedHeaderCrc() {
        return ByteBufferCRC32.getChecksum(this._buf, this._position + 13, this.numBytesForHeaderCrc());
    }

    private static short setOpCode(DbusOpcode opCode, short attributes, int srcId) {
        if (DbusEventUtils.isControlSrcId(srcId)) {
            return attributes;
        }
        if (opCode == null) {
            opCode = DbusOpcode.UPSERT;
        }
        switch (opCode) {
            case UPSERT: {
                attributes = (short)(attributes | 1);
                break;
            }
            case DELETE: {
                attributes = (short)(attributes | 2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unimplemented opCode:" + (Object)((Object)opCode));
            }
        }
        return attributes;
    }

    private static short setKeyType(DbusEventKey key, short attributes) {
        switch (key.getKeyType()) {
            case STRING: {
                attributes = (short)(attributes | 8);
                break;
            }
            case LONG: {
                attributes = (short)(attributes | 4);
                break;
            }
            case SCHEMA: {
                attributes = (short)(attributes | 0xC);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unimplemented key type:" + (Object)((Object)key.getKeyType()));
            }
        }
        return attributes;
    }

    public static void setKey(ByteBuffer buf, DbusEventKey key) {
        switch (key.getKeyType()) {
            case STRING: {
                byte[] keyBytes = key.getStringKeyInBytes();
                buf.putInt(keyBytes.length).put(keyBytes);
                break;
            }
            case LONG: {
                buf.putLong(key.getLongKey());
                break;
            }
            case SCHEMA: {
                key.getSchemaKey().encode(buf);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unimplemented key type:" + (Object)((Object)key.getKeyType()));
            }
        }
    }

    private static boolean shouldEncodePayloadPart(DbusEventInfo eventInfo) {
        return eventInfo.getPayloadSchemaVersion() > 0 || eventInfo.getValueLength() > 0;
    }

    public static int serializeEvent(DbusEventKey key, ByteBuffer buf, DbusEventInfo dbusEventInfo) {
        int start = buf.position();
        buf.put((byte)2);
        buf.putInt(-889266451);
        buf.putInt(0);
        buf.putInt(0);
        buf.putInt(0);
        buf.putInt(0);
        short attributes = 0;
        attributes = DbusEventV2.setOpCode(dbusEventInfo.getOpCode(), attributes, dbusEventInfo.getSrcId());
        attributes = DbusEventV2.setKeyType(key, attributes);
        if (dbusEventInfo.isEnableTracing()) {
            attributes = (short)(attributes | 0x20);
        }
        if (dbusEventInfo.isReplicated()) {
            attributes = (short)(attributes | 0x10);
        }
        DbusEventPart metadata = dbusEventInfo.getMetadata();
        if (DbusEventV2.shouldEncodePayloadPart(dbusEventInfo)) {
            attributes = (short)(attributes | 0x80);
        }
        if (metadata != null) {
            attributes = (short)(attributes | 0x40);
        }
        buf.putShort(attributes);
        buf.putLong(dbusEventInfo.getTimeStampInNanos());
        buf.putInt(dbusEventInfo.getSrcId());
        buf.putShort(dbusEventInfo.getpPartitionId());
        buf.putLong(dbusEventInfo.getSequenceId());
        DbusEventV2.setKey(buf, key);
        int hdrEndPos = buf.position();
        if (metadata != null) {
            metadata.encode(buf);
        }
        if ((attributes & 0x80) != 0) {
            ByteBuffer bb = dbusEventInfo.getValueByteBuffer();
            if (bb == null) {
                bb = ByteBuffer.allocate(1).order(buf.order());
                bb.limit(0);
            }
            DbusEventPart valuePart = new DbusEventPart(DbusEvent.SchemaDigestType.MD5, dbusEventInfo.getSchemaId(), dbusEventInfo.getPayloadSchemaVersion(), bb);
            valuePart.encode(buf);
        }
        int end = buf.position();
        buf.putInt(start + 5, hdrEndPos - start);
        buf.putInt(start + 17, end - start);
        long bodyCrc = ByteBufferCRC32.getChecksum(buf, hdrEndPos, end - hdrEndPos);
        Utils.putUnsignedInt(buf, start + 13, bodyCrc);
        if (dbusEventInfo.isAutocommit()) {
            long hdrCrc = ByteBufferCRC32.getChecksum(buf, start + 13, hdrEndPos - start - 13);
            Utils.putUnsignedInt(buf, start + 9, hdrCrc);
        }
        return buf.position() - start;
    }

    public static int serializeEvent(DbusEventKey key, short pPartitionId, short lPartitionId, long timeStampInNanos, short srcId, byte[] schemaId, byte[] value, boolean enableTracing, ByteBuffer serializationBuffer) throws KeyTypeNotImplementedException {
        throw new UnsupportedOperationException("Unimplemented as yet");
    }

    public static int computeEventLength(DbusEventKey key, DbusEventInfo eventInfo) throws KeyTypeNotImplementedException {
        int evtLen = 45;
        switch (key.getKeyType()) {
            case LONG: {
                evtLen += 8;
                break;
            }
            case STRING: {
                evtLen += key.getStringKeyInBytes().length + 4;
                break;
            }
            case SCHEMA: {
                evtLen += key.getSchemaKey().computePartLength();
                break;
            }
            default: {
                String msg = "Unknown key type:" + (Object)((Object)key.getKeyType());
                LOG.error((Object)msg);
                throw new KeyTypeNotImplementedException(msg);
            }
        }
        DbusEventPart metadata = eventInfo.getMetadata();
        if (metadata != null) {
            evtLen += metadata.computePartLength();
        }
        if (DbusEventV2.shouldEncodePayloadPart(eventInfo)) {
            evtLen += DbusEventPart.computePartLength(DbusEvent.SchemaDigestType.MD5, eventInfo.getValueLength());
        }
        return evtLen;
    }

    public DbusEventInternalWritable convertToV1() throws KeyTypeNotImplementedException {
        DbusEventKey key;
        DbusEventV1Factory eventV1Factory = new DbusEventV1Factory();
        ByteBuffer curValue = this.value();
        if (this.isKeyNumber()) {
            key = new DbusEventKey(this.key());
        } else if (this.isKeyString()) {
            key = new DbusEventKey(this.keyBytes());
        } else {
            String msg = "Conversion not supported for this key type:" + (Object)((Object)this.getKeyType(this.getKeyTypeAttribute()));
            LOG.error((Object)msg);
            throw new KeyTypeNotImplementedException(msg);
        }
        byte[] schemaId = this.schemaId();
        if (schemaId == null) {
            schemaId = DbusEventInternalWritable.emptyMd5;
        }
        boolean autocommit = true;
        DbusEventInfo dbusEventInfo = new DbusEventInfo(this.getOpcode(), this.sequence(), this.getPartitionId(), this.getPartitionId(), this.timestampInNanos(), (short)this.getSourceId(), schemaId, null, this.isTraceEnabled(), autocommit);
        if (curValue != null) {
            dbusEventInfo.setValueByteBuffer(curValue);
        }
        int newEventSize = DbusEventFactory.computeEventLength(key, dbusEventInfo);
        ByteBuffer serializationBuffer = ByteBuffer.allocate(newEventSize);
        serializationBuffer.order(this._buf.order());
        int size = DbusEventV1.serializeEvent(key, serializationBuffer, dbusEventInfo);
        if (size != newEventSize) {
            throw new DatabusRuntimeException("event size doesn't match after conversion from V2 to V1");
        }
        serializationBuffer.limit(size);
        return new DbusEventV1(serializationBuffer, 0);
    }

    public static ByteBuffer serializeEndOfPeriodMarker(long seq, short partition, ByteOrder byteOrder) {
        DbusEventKey key = DbusEventInternalWritable.EOPMarkerKey;
        DbusEventInfo eventInfo = new DbusEventInfo(null, seq, partition, partition, System.nanoTime(), -2, DbusEventInternalWritable.emptyMd5, new byte[0], false, true, 2, 0, null);
        try {
            int evtLen = DbusEventV2.computeEventLength(key, eventInfo);
            ByteBuffer buf = ByteBuffer.allocate(evtLen).order(byteOrder);
            DbusEventV2.serializeEvent(key, buf, eventInfo);
            return buf;
        }
        catch (KeyTypeNotImplementedException e) {
            throw new DatabusRuntimeException("Unexpected exception on key :" + key, e);
        }
    }

    public String toString() {
        if (this._buf == null) {
            return "buf=null";
        }
        boolean valid = true;
        try {
            valid = this.isValid(true);
        }
        catch (Exception ex) {
            LOG.error((Object)"DbusEventV2.toString() : Got Exception while trying to validate the event ", (Throwable)ex);
            valid = false;
        }
        if (!valid) {
            StringBuilder sb = new StringBuilder("Position: ");
            sb.append(this._position);
            sb.append(", buf: ");
            sb.append(this._buf != null ? this._buf.toString() : "null");
            sb.append(", validity: false; hexDump:");
            if (this._buf != null && this._position >= 0) {
                sb.append(StringUtils.hexdumpByteBufferContents(this._buf, this._position, 100));
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("Version=").append(this.getVersion()).append(";Position=").append(this._position).append(";isEndOfPeriodMarker=").append(this.isEndOfPeriodMarker()).append(";isExtReplicated=").append(this.isExtReplicatedEvent()).append(";HeaderCrc=").append("0x").append(Integer.toHexString((int)this.headerCrc())).append(";Length=").append(this.size()).append(";KeyType=").append((Object)this.getKeyType(this.getKeyTypeAttribute())).append(";Key=");
        if (this.isKeyString()) {
            sb.append("0x").append(Hex.encodeHexString((byte[])this.keyBytes()));
        } else if (this.isKeyNumber()) {
            sb.append(this.key());
        } else if (this.isKeySchema()) {
            sb.append(this.getKeyPart().toString());
        }
        sb.append(";Sequence=").append(this.sequence()).append(";PartitionId=").append(this.getPartitionId()).append(";Timestamp=").append(this.timestampInNanos()).append(";SrcId=").append(this.srcId()).append(";SchemaId=").append(this.schemaId() == null ? "null" : "0x" + Hex.encodeHexString((byte[])this.schemaId())).append(";ValueCrc=").append("0x").append(Integer.toHexString((int)this.bodyCrc())).append(";HasMetadata=").append(this.hasMetadata()).append(";hasPayloadPart=").append(this.hasPayloadPart()).append(";PayloadLen=").append(this.payloadLength());
        if (this.hasMetadata()) {
            sb.append(";Metadata={").append(this.getPayloadMetadataPart().toString()).append("}");
        }
        return sb.toString();
    }
}

